/**
 * $Id: controller.h,v 1.3 2006-05-20 02:40:51 nkeynes Exp $
 *
 * Definitions for the standard controller device
 *
 * Copyright (c) 2005 Nathan Keynes.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/* First word of controller condition */
#define BUTTON_C            0x00000001 /* not on standard controller */
#define BUTTON_B            0x00000002
#define BUTTON_A            0x00000004
#define BUTTON_START        0x00000008
#define BUTTON_DPAD_UP      0x00000010
#define BUTTON_DPAD_DOWN    0x00000020
#define BUTTON_DPAD_LEFT    0x00000040
#define BUTTON_DPAD_RIGHT   0x00000080
#define BUTTON_Z            0x00000100 /* not on standard controller */
#define BUTTON_Y            0x00000200
#define BUTTON_X            0x00000400
#define BUTTON_D            0x00000800 /* not on standard controller */
#define BUTTON_LEFT_TRIGGER 0xFF000000 /* Bitmask */
#define BUTTON_RIGHT_TRIGGER 0x00FF0000 /* Bitmask */

/* Second word of controller condition (bitmasks) */
#define JOY_X_AXIS          0x000000FF
#define JOY_Y_AXIS          0x0000FF00
#define JOY_X_AXIS_CENTER   0x00000080
#define JOY_Y_AXIS_CENTER   0x00008000
#define JOY2_X_AXIS         0x00FF0000 /* not on standard controller */
#define JOY2_Y_AXIS         0xFF000000 /* not on standard controller */

/* The following bits are used by the emulator for flags but don't actually
 * appear in the hardware
 */
#define JOY_LEFT            0x80000001
#define JOY_RIGHT           0x80000002
#define JOY_UP              0x80000004
#define JOY_DOWN            0x80000008

/* Standard controller ID */
#define CONTROLLER_IDENT {0x00, 0x00, 0x00, 0x01,  0x00, 0x0f, 0x06, 0xfe,  0x00, 0x00, 0x00, 0x00, \
0x00, 0x00, 0x00, 0x00,  0xff, 0x00, 0x44, 0x72,  0x65, 0x61, 0x6d, 0x63,  0x61, 0x73, 0x74, 0x20,  \
 0x43, 0x6f, 0x6e, 0x74,  0x72, 0x6f, 0x6c, 0x6c,  0x65, 0x72, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20, \
 0x20, 0x20, 0x20, 0x20,  0x50, 0x72, 0x6f, 0x64,  0x75, 0x63, 0x65, 0x64,  0x20, 0x42, 0x79, 0x20, \
 0x6f, 0x72, 0x20, 0x55,  0x6e, 0x64, 0x65, 0x72,  0x20, 0x4c, 0x69, 0x63,  0x65, 0x6e, 0x73, 0x65, \
 0x20, 0x46, 0x72, 0x6f,  0x6d, 0x20, 0x53, 0x45,  0x47, 0x41, 0x20, 0x45,  0x4e, 0x54, 0x45, 0x52, \
 0x50, 0x52, 0x49, 0x53,  0x45, 0x53, 0x2c, 0x4c,  0x54, 0x44, 0x2e, 0x20,  0x20, 0x20, 0x20, 0x20, \
            0xae, 0x01, 0xf4, 0x01}
#define CONTROLLER_VERSION {0x56, 0x65, 0x72, 0x73,  0x69, 0x6f, 0x6e, 0x20,  0x31, 0x2e, 0x30, 0x31, \
 0x30, 0x2c, 0x31, 0x39,  0x39, 0x38, 0x2f, 0x30,  0x39, 0x2f, 0x32, 0x38,  0x2c, 0x33, 0x31, 0x35, \
 0x2d, 0x36, 0x32, 0x31,  0x31, 0x2d, 0x41, 0x42,  0x20, 0x20, 0x20, 0x2c,  0x41, 0x6e, 0x61, 0x6c, \
 0x6f, 0x67, 0x20, 0x4d,  0x6f, 0x64, 0x75, 0x6c,  0x65, 0x20, 0x3a, 0x20,  0x54, 0x68, 0x65, 0x20, \
 0x34, 0x74, 0x68, 0x20,  0x45, 0x64, 0x69, 0x74,  0x69, 0x6f, 0x6e, 0x2e,  0x35, 0x2f, 0x38, 0x20, \
            0x20, 0x2b, 0x44, 0x46 }
