
.586
.MODEL FLAT, C
.STACK
.DATA
.CODE

;****************************************************************
; CopyBlock - copies a block from base_addr+offset to dest_addr, while unswapping the
;  data within.
;
; edi = dest_addr -> end of dest
; ecx = num_words
; esi = base_addr (preserved)
; edx = offset (preserved)
;****************************************************************

ALIGN 4

CopyBlock PROC
	push eax
	push ebx
	push esi
	push edx

	or ecx,ecx
	jz copyblock_end

	push ecx

	; first, set the source address and check if not on a dword boundary
	push esi
	push edx
	mov ebx,edx
	and edx,0FFFFFFFCh
	add esi,edx

	and ebx,3				; ebx = # we DON'T need to copy
	jz copyblock_copy

	mov edx,4				; ecx = # we DO need to copy
	sub edx,ebx

	; load the first word, accounting for swapping

	mov eax,dword ptr [esi]
	add esi,4
copyblock_precopy_skip:
	rol eax,8
	dec ebx
	jnz copyblock_precopy_skip

copyblock_precopy_copy:
	rol eax,8
	mov byte ptr [edi],al
	inc edi
	dec edx
	jnz copyblock_precopy_copy

	mov eax,dword ptr [esi]
	add esi,4
	bswap eax
	mov dword ptr [edi],eax
	add edi,4

	dec ecx		; 1 less word to copy
	jz copyblock_postcopy

copyblock_copy:
	mov eax,dword ptr [esi]
	bswap eax
	mov dword ptr [edi],eax

	mov eax,dword ptr [esi+4]
	bswap eax
	mov dword ptr [edi+4],eax

	add esi,8
	add edi,8

	dec ecx
	jnz copyblock_copy

copyblock_postcopy:
	pop edx
	pop esi
	pop ecx

	; check again if on dword boundary
	mov ebx,edx						; ebx = # we DO need to copy

	and ebx,3
	jz copyblock_end

	shl ecx,3						; ecx = num_words * 8
	add edx,ecx
	and edx,0FFFFFFFCh
	add esi,edx

	mov eax,dword ptr [esi]

copyblock_postcopy_copy:
	rol eax,8
	mov byte ptr [edi],al
	inc edi
	dec ebx
	jnz copyblock_postcopy_copy

copyblock_end:
	pop edx
	pop esi
	pop ebx
	pop eax
	ret
CopyBlock ENDP

;****************************************************************
; SwapBlock - swaps every other 32-bit word at addr
;
; ecx = num_words -> 0
; edi = addr -> end of dest
;****************************************************************

ALIGN 4

SwapBlock32 PROC
	push eax
	push ebx
	or ecx,ecx
	jz swapblock_end
swapblock_loop:
	mov eax,dword ptr [edi]
	mov ebx,dword ptr [edi+4]
	mov dword ptr [edi],ebx
	mov dword ptr [edi+4],eax
	add edi,8
	dec ecx
	jnz swapblock_loop
swapblock_end:
	pop ebx
	pop eax
	ret
SwapBlock32 ENDP

ALIGN 4

SwapBlock64 PROC
	push eax
	push ebx
	push edx
	shr ecx,1
	or ecx,ecx
	jz swapblock_end
swapblock_loop:
	mov eax,dword ptr [edi]
	mov ebx,dword ptr [edi+4]
	mov edx,dword ptr [edi+8]
	mov dword ptr [edi+8],eax
	mov eax,dword ptr [edi+12]
	mov dword ptr [edi+12],ebx
	mov dword ptr [edi+0],edx
	mov dword ptr [edi+4],eax
	add edi,16
	dec ecx
	jnz swapblock_loop
swapblock_end:
	pop edx
	pop ebx
	pop eax
	ret
SwapBlock64 ENDP

END