/*
*	Glide64 - Glide video plugin for Nintendo 64 emulators.
*	Copyright (c) 2002  Dave2001
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//****************************************************************
//
// Glide64 - Glide Plugin for Nintendo 64 emulators (tested mostly with Project64)
// Project started on December 29th, 2001
//
// To modify Glide64:
// * Write your name and (optional)email, commented by your work, so I know who did it, and so that you can find which parts you modified when it comes time to send it to me.
// * Do NOT send me the whole project or file that you modified.  Take out your modified code sections, and tell me where to put them.  If people sent the whole thing, I would have many different versions, but no idea how to combine them all.
//
// Official Glide64 development channel: #Glide64 on EFnet
//
// Original author: Dave2001 (Dave2999@hotmail.com)
// Other authors: Gonetz, Gugaman
//
//****************************************************************

//****************************************************************
// Size: 2, Format: 0

DWORD Load16bRGBA (DWORD dst, DWORD src, int wid_64, int height, int line, int real_width, int tile)
{
	if (wid_64 < 1) wid_64 = 1;
	if (height < 1) height = 1;
	int ext = (real_width - (wid_64 << 2)) << 1;
	__asm {
		mov esi,dword ptr [src]
		mov edi,dword ptr [dst]

		mov ecx,dword ptr [height]
y_loop:
		push ecx

		mov ecx,dword ptr [wid_64]
x_loop:
		mov eax,dword ptr [esi]		// read both pixels
		add esi,4
		bswap eax
		mov edx,eax

		ror ax,1
		ror eax,16
		ror ax,1

		mov dword ptr [edi],eax
		add edi,4

		// * copy
		mov eax,dword ptr [esi]		// read both pixels
		add esi,4
		bswap eax
		mov edx,eax

		ror ax,1
		ror eax,16
		ror ax,1

		mov dword ptr [edi],eax
		add edi,4
		// *

		dec ecx
		jnz x_loop

		pop ecx
		dec ecx
		jz end_y_loop
		push ecx

		add esi,dword ptr [line]
		add edi,dword ptr [ext]

		mov ecx,dword ptr [wid_64]
x_loop_2:
		mov eax,dword ptr [esi+4]		// read both pixels
		bswap eax
		mov edx,eax

		ror ax,1
		ror eax,16
		ror ax,1

		mov dword ptr [edi],eax
		add edi,4

		// * copy
		mov eax,dword ptr [esi]		// read both pixels
		add esi,8
		bswap eax
		mov edx,eax

		ror ax,1
		ror eax,16
		ror ax,1

		mov dword ptr [edi],eax
		add edi,4
		// *

		dec ecx
		jnz x_loop_2
		
		add esi,dword ptr [line]
		add edi,dword ptr [ext]

		pop ecx
		dec ecx
		jnz y_loop

end_y_loop:
	}

	return (1 << 16) | GR_TEXFMT_ARGB_1555;
}

//****************************************************************
// Size: 2, Format: 3
//
// ** by Gugaman/Dave2001 **

DWORD Load16bIA (DWORD dst, DWORD src, int wid_64, int height, int line, int real_width, int tile)
{
	if (wid_64 < 1) wid_64 = 1;
	if (height < 1) height = 1;
	int ext = (real_width - (wid_64 << 2)) << 1;
	__asm {
		mov esi,dword ptr [src]
		mov edi,dword ptr [dst]

		mov ecx,dword ptr [height]
y_loop:
		push ecx

		mov ecx,dword ptr [wid_64]
x_loop:
		mov eax,dword ptr [esi]		// read both pixels
		add esi,4
		mov dword ptr [edi],eax
		add edi,4

		// * copy
		mov eax,dword ptr [esi]		// read both pixels
		add esi,4
		mov dword ptr [edi],eax
		add edi,4
		// *

		dec ecx
		jnz x_loop

		pop ecx
		dec ecx
		jz end_y_loop
		push ecx

		add esi,dword ptr [line]
		add edi,dword ptr [ext]

		mov ecx,dword ptr [wid_64]
x_loop_2:
		mov eax,dword ptr [esi+4]		// read both pixels
		mov dword ptr [edi],eax
		add edi,4

		// * copy
		mov eax,dword ptr [esi]		// read both pixels
		add esi,8
		mov dword ptr [edi],eax
		add edi,4
		// *

		dec ecx
		jnz x_loop_2
		
		add esi,dword ptr [line]
		add edi,dword ptr [ext]

		pop ecx
		dec ecx
		jnz y_loop

end_y_loop:
	}

	return (1 << 16) | GR_TEXFMT_ALPHA_INTENSITY_88;
}