/*
*	Glide64 - Glide video plugin for Nintendo 64 emulators.
*	Copyright (c) 2002  Dave2001
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//****************************************************************
//
// Glide64 - Glide Plugin for Nintendo 64 emulators (tested mostly with Project64)
// Project started on December 29th, 2001
//
// To modify Glide64:
// * Write your name and (optional)email, commented by your work, so I know who did it, and so that you can find which parts you modified when it comes time to send it to me.
// * Do NOT send me the whole project or file that you modified.  Take out your modified code sections, and tell me where to put them.  If people sent the whole thing, I would have many different versions, but no idea how to combine them all.
//
// Official Glide64 development channel: #Glide64 on EFnet
//
// Original author: Dave2001 (Dave2999@hotmail.com)
// Other authors: Gonetz, Gugaman
//
//****************************************************************

#include "Gfx #1.3.h"
#include "Resource.h"
#include "ToolTips.h"

PROPSHEETHEADER	m_PropSheet;
PROPSHEETPAGE m_psp[NUM_PAGES];

#ifdef TEXTURE_FILTER
#include "Ext_TxFilter.h"
TEXFILTER texfltr[] = {
  {NO_FILTER, "None"},
  {SMOOTH_FILTER_1, "Smooth filtering 1"},
  {SMOOTH_FILTER_2, "Smooth filtering 2"},
  {SMOOTH_FILTER_3, "Smooth filtering 3"},
  {SMOOTH_FILTER_4, "Smooth filtering 4"},
  {SHARP_FILTER_1,  "Sharp filtering 1"},
  {SHARP_FILTER_2,  "Sharp filtering 2"},
};

TEXFILTER texenht[] = {
  {NO_ENHANCEMENT,    "None"},
  {X2_ENHANCEMENT,    "X2"},
  {X2SAI_ENHANCEMENT, "X2SAI"},
  {HQ2X_ENHANCEMENT,  "HQ2X"},
  {LQ2X_ENHANCEMENT,  "LQ2X"},
  {HQ4X_ENHANCEMENT,  "HQ4X"},
};

TEXFILTER texcmpr[] = {
  {NO_COMPRESSION,   "None"},
//  {NCC_COMPRESSION,  "NCC"},
  {S3TC_COMPRESSION, "S3TC"},
  {FXT1_COMPRESSION, "FXT1"},
};

TEXFILTER texhirs[] = {
  {NO_HIRESTEXTURES,   "Do not use"},
  {RICE_HIRESTEXTURES,  "Rice format"},
//  {GHQ_HIRESTEXTURES, "GlideHQ format"},
//  {JABO_HIRESTEXTURES, "Jabo format"},
};
#endif


/******************************************************************
Function: DllConfig
Purpose:  This function is optional function that is provided
to allow the user to configure the dll
input:    a handle to the window that calls this function
output:   none
*******************************************************************/ 
void CALL DllConfig ( HWND hParent )
{
  ReadSettings ();
  if (romopen)
  {
    char name[21] = "DEFAULT";
    ReadSpecialSettings (name);
    
    // get the name of the ROM
    for (int i=0; i<20; i++)
      name[i] = gfx.HEADER[(32+i)^3];
    name[20] = 0;
    
    // remove all trailing spaces
    while (name[strlen(name)-1] == ' ')
      name[strlen(name)-1] = 0;
    
    ReadSpecialSettings (name);
  }
  m_PropSheet.hwndParent = hParent;
  if (PropertySheet(&m_PropSheet))
  {
    // re-init to resize window if in windowed mode
    if (fullscreen && !ev_fullscreen) {
      ReleaseGfx ();
      InitGfx (TRUE);
    }
  }
}


//
// ConfigProc - window proceedure for the configuration dialog
//
BOOL CALLBACK ConfigPageProc (HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch (uMsg)
  {
  case WM_NOTIFY:
    switch (((NMHDR FAR *) lParam)->code) {
#ifdef USE_TOOLTIPS
    case PSN_SETACTIVE: 
      if (!g_hhk)
      {
        g_hwndDlg = hwndDlg;
        g_hinst = hInstance;
        g_hwndTT = NULL;
        DoCreateDialogTooltip ();
      }
      break;
    case TTN_NEEDTEXT:
      OnWMNotify (lParam);
      break;
    case PSN_KILLACTIVE: 
    case PSN_QUERYCANCEL:
      //user clicked OK or selected another page
      if (g_hwndDlg == hwndDlg)
      {
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
        g_hwndTT = NULL;
        g_hwndDlg = NULL;
      }
      break;		
#endif
    case PSN_APPLY:
      // Save the resolution
      HWND hwndRes = GetDlgItem (hwndDlg, IDC_RESOLUTION);
      settings.res_data = SendMessage (hwndRes, CB_GETCURSEL, 0, 0);
      HWND hwndWireframe = GetDlgItem (hwndDlg, IDC_WIREFRAME);
      settings.wireframe = (SendMessage (hwndWireframe, BM_GETCHECK, 0, 0)==BST_CHECKED)?1:0;
      HWND hwndWfmode = GetDlgItem (hwndDlg, IDC_WFMODE);
      settings.wfmode = SendMessage (hwndWfmode, CB_GETCURSEL, 0, 0);
      HWND hwndU = GetDlgItem (hwndDlg, IDC_UCODE);
      settings.ucode = SendMessage (hwndU, CB_GETCURSEL, 0, 0);
      
      // Actually set the new resolution numbers
      settings.scr_res_x = settings.res_x = resolutions[settings.res_data][0];
      settings.scr_res_y = settings.res_y = resolutions[settings.res_data][1];
      
      // Rendering
      // Filter modes
      settings.filtering = (BYTE)SendMessage (GetDlgItem (hwndDlg, IDC_FILTER),
        CB_GETCURSEL, 0, 0);
      // Buffer swapping modes
      settings.swapmode = (BYTE)SendMessage (GetDlgItem (hwndDlg, IDC_SWAP),
        CB_GETCURSEL, 0, 0);
      //LOD calculation modes	
      settings.lodmode = (BYTE)SendMessage (GetDlgItem (hwndDlg, IDC_LOD),
        CB_GETCURSEL, 0, 0);
      
      
      
#define GETBN(id,var) var=((SendMessage(GetDlgItem(hwndDlg,id),BM_GETCHECK,0,0)==BST_CHECKED)?1:0)
      
      GETBN (IDC_BUFFERCLEAR, settings.buff_clear);
      
      // Autodetect
      GETBN (IDC_AUTODETECT, settings.autodetect_ucode);
      
      // Glide card #
      if (SendMessage (GetDlgItem (hwndDlg, IDC_GID1),
        BM_GETCHECK, 0, 0)==BST_CHECKED)
        settings.card_id = 0;
      if (SendMessage (GetDlgItem (hwndDlg, IDC_GID2),
        BM_GETCHECK, 0, 0)==BST_CHECKED)
        settings.card_id = 1;
      if (SendMessage (GetDlgItem (hwndDlg, IDC_GID3),
        BM_GETCHECK, 0, 0)==BST_CHECKED)
        settings.card_id = 2;
      if (SendMessage (GetDlgItem (hwndDlg, IDC_GID4),
        BM_GETCHECK, 0, 0)==BST_CHECKED)
        settings.card_id = 3;
      
      GETBN (IDC_WRAP_BIG_TEX, settings.wrap_big_tex);
      GETBN (IDC_CORONA, settings.flame_corona);
      //GETBN (IDC_RE2_VIDEO, settings.RE2_native_video);
      
      GETBN (IDC_FOG, settings.fog);
      GETBN (IDC_VSYNC, settings.vsync);
      GETBN (IDC_CRC, settings.fast_crc);
      
      GETBN (IDC_FB_READ_ALWAYS, settings.fb_read_always);
      GETBN (IDC_FB_INFO, settings.fb_get_info);
      GETBN (IDC_FB_ALPHA, settings.fb_read_alpha);
      GETBN (IDC_FB_SMART, settings.fb_smart);
      GETBN (IDC_ENABLEMB, settings.fb_motionblur);
      GETBN (IDC_HIRESFB,  settings.fb_hires);
      GETBN (IDC_DB_CLEAR, settings.fb_depth_clear);
      GETBN (IDC_DB_RENDER, settings.fb_depth_render);
      
      GETBN (IDC_CUSTOM, settings.custom_ini);
      GETBN (IDC_HOTKEYS, settings.hotkeys);
      
      WriteSettings ();
      if (g_hwndDlg == hwndDlg)
      {
#ifdef USE_TOOLTIPS
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
#endif
        g_hwndDlg = NULL;
      }
      break;
  }
  return 0;
  
  case WM_INITDIALOG:
    {
      // Add the video modes to the list
      HWND hwndRes = GetDlgItem (hwndDlg, IDC_RESOLUTION);
      
#define ADDRES(s,x) SendMessage(hwndRes,CB_ADDSTRING,0,(LPARAM)s);
      
      // MUST be in this order (SST1VID.H)
      ADDRES ("320x200", 0x00);
      ADDRES ("320x240", 0x01);
      ADDRES ("400x256", 0x02);
      ADDRES ("512x384", 0x03);
      ADDRES ("640x200", 0x04);
      ADDRES ("640x350", 0x05);
      ADDRES ("640x400", 0x06);
      ADDRES ("640x480", 0x07);
      ADDRES ("800x600", 0x08);
      ADDRES ("960x720", 0x09);
      ADDRES ("856x480", 0x0A);
      ADDRES ("512x256", 0x0B);
      ADDRES ("1024x768", 0x0C);
      ADDRES ("1280x1024", 0x0D);
      ADDRES ("1600x1200", 0x0E);
      ADDRES ("400x300", 0x0F);
      ADDRES ("1152x864", 0x10);
      ADDRES ("1280x960", 0x11);
      ADDRES ("1600x1024", 0x12);
      ADDRES ("1792x1344", 0x13);
      ADDRES ("1856x1392", 0x14);
      ADDRES ("1920x1440", 0x15);
      ADDRES ("2048x1536", 0x16);
      ADDRES ("2048x2048", 0x17);
      SendMessage (hwndRes, CB_SETCURSEL, settings.res_data, 0);
      
      HWND hwndWireframe = GetDlgItem (hwndDlg, IDC_WIREFRAME);
      SendMessage (hwndWireframe, BM_SETCHECK, settings.wireframe?BST_CHECKED:BST_UNCHECKED, 0);
      HWND hwndWfmode = GetDlgItem (hwndDlg, IDC_WFMODE);
      SendMessage (hwndWfmode, CB_ADDSTRING, 0, (LPARAM)"Original colors");
      SendMessage (hwndWfmode, CB_ADDSTRING, 0, (LPARAM)"Vertex colors");
      SendMessage (hwndWfmode, CB_ADDSTRING, 0, (LPARAM)"Red only");
      SendMessage (hwndWfmode, CB_SETCURSEL, settings.wfmode, 0);
      
      HWND hwndU = GetDlgItem (hwndDlg, IDC_UCODE);
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"0: RSP SW 2.0X (ex. Mario)");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"1: F3DEX 1.XX (ex. Star Fox)");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"2: F3DEX 2.XX (ex. Zelda OOT)");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"3: RSP SW 2.0D EXT (ex. Waverace)");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"4: RSP SW 2.0D EXT (ex. Shadows of the Empire)");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"5: RSP SW 2.0 (ex. Diddy Kong Racing)");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"6: S2DEX 1.XX (ex. Yoshi's Story)");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"7: RSP SW PD Perfect Dark");
      SendMessage (hwndU, CB_ADDSTRING, 0, (LPARAM)"8: F3DEXBG 2.08 Conker's Bad Fur Day");
      SendMessage (hwndU, CB_SETCURSEL, settings.ucode, 0);
      
      // Rendering
      // Filter modes
      HWND hwndFilter = GetDlgItem (hwndDlg, IDC_FILTER);
      SendMessage (hwndFilter, CB_ADDSTRING, 0, (LPARAM)"Automatic");
      SendMessage (hwndFilter, CB_ADDSTRING, 0, (LPARAM)"Force Bilinear");
      SendMessage (hwndFilter, CB_ADDSTRING, 0, (LPARAM)"Force Point-sampled");
      SendMessage (hwndFilter, CB_SETCURSEL, settings.filtering, 0);
      
      // Buffer swapping modes
      HWND hwndSwap = GetDlgItem (hwndDlg, IDC_SWAP);
      SendMessage (hwndSwap, CB_ADDSTRING, 0, (LPARAM)"old");
      SendMessage (hwndSwap, CB_ADDSTRING, 0, (LPARAM)"new");
      SendMessage (hwndSwap, CB_ADDSTRING, 0, (LPARAM)"hybrid");
      SendMessage (hwndSwap, CB_SETCURSEL, settings.swapmode, 0);
      
      // LOD calculation modes modes
      HWND hwndLOD = GetDlgItem (hwndDlg, IDC_LOD);
      SendMessage (hwndLOD, CB_ADDSTRING, 0, (LPARAM)"off");
      SendMessage (hwndLOD, CB_ADDSTRING, 0, (LPARAM)"fast");
      SendMessage (hwndLOD, CB_ADDSTRING, 0, (LPARAM)"precise");
      SendMessage (hwndLOD, CB_SETCURSEL, settings.lodmode, 0);
      
#define CHECKBN(id,set) SendMessage(GetDlgItem(hwndDlg,id),BM_SETCHECK,(set)?BST_CHECKED:BST_UNCHECKED, 0);
      
      CHECKBN (IDC_BUFFERCLEAR, settings.buff_clear);
      
      // Autodetect
      CHECKBN (IDC_AUTODETECT, settings.autodetect_ucode);
      
      // Glide card #
      CHECKBN (IDC_GID1, settings.card_id==0);
      CHECKBN (IDC_GID2, settings.card_id==1);
      CHECKBN (IDC_GID3, settings.card_id==2);
      CHECKBN (IDC_GID4, settings.card_id==3);
      
      
      // Special fixes
      CHECKBN (IDC_WRAP_BIG_TEX, settings.wrap_big_tex);
      CHECKBN (IDC_CORONA, settings.flame_corona);
      //CHECKBN (IDC_RE2_VIDEO, settings.RE2_native_video);
      
      CHECKBN (IDC_FOG, settings.fog);
      CHECKBN (IDC_VSYNC, settings.vsync);
      CHECKBN (IDC_CRC, settings.fast_crc);
      
      //Frame buffer
      CHECKBN (IDC_FB_READ_ALWAYS, settings.fb_read_always);
      CHECKBN (IDC_FB_INFO, settings.fb_get_info);
      CHECKBN (IDC_FB_ALPHA, settings.fb_read_alpha);
      CHECKBN (IDC_FB_SMART, settings.fb_smart);
      CHECKBN (IDC_ENABLEMB, settings.fb_motionblur);
      CHECKBN (IDC_HIRESFB,  settings.fb_hires);
      CHECKBN (IDC_DB_CLEAR, settings.fb_depth_clear);
      CHECKBN (IDC_DB_RENDER, settings.fb_depth_render);
      
      CHECKBN (IDC_CUSTOM, settings.custom_ini);
      CHECKBN (IDC_HOTKEYS, settings.hotkeys);
      
      BOOL enable = !settings.custom_ini;
      EnableWindow(hwndFilter, enable);
      
      HWND hwndFog = GetDlgItem (hwndDlg, IDC_FOG);
      EnableWindow(hwndFog, enable);
      
      HWND hwndBuffClear = GetDlgItem (hwndDlg, IDC_BUFFERCLEAR);
      EnableWindow(hwndBuffClear, enable);
      
      EnableWindow(hwndSwap, enable);
      
      HWND hwndFBSmart = GetDlgItem (hwndDlg, IDC_FB_SMART);
      EnableWindow(hwndFBSmart, enable);
      
      HWND hwndAlpha = GetDlgItem (hwndDlg, IDC_FB_ALPHA);
      EnableWindow(hwndAlpha, enable);
      
      HWND hwndFBClear = GetDlgItem (hwndDlg, IDC_DB_CLEAR);
      EnableWindow(hwndFBClear, enable);
    }
    return 1;
    
  case WM_COMMAND:
    if (HIWORD(wParam) == BN_CLICKED) 
    {
      if (LOWORD(wParam) == IDC_CUSTOM)
      {
        HWND hwndCustom = GetDlgItem (hwndDlg, IDC_CUSTOM);
        BOOL enable = (SendMessage(hwndCustom, BM_GETCHECK, 0, 0) != BST_CHECKED);
        
        HWND hwndFilter = GetDlgItem (hwndDlg, IDC_FILTER);
        EnableWindow(hwndFilter, enable);
        
        HWND hwndFog = GetDlgItem (hwndDlg, IDC_FOG);
        EnableWindow(hwndFog, enable);
        
        HWND hwndBuffClear = GetDlgItem (hwndDlg, IDC_BUFFERCLEAR);
        EnableWindow(hwndBuffClear, enable);
        
        HWND hwndSwap = GetDlgItem (hwndDlg, IDC_SWAP);
        EnableWindow(hwndSwap, enable);
        
        HWND hwndFBSmart = GetDlgItem (hwndDlg, IDC_FB_SMART);
        EnableWindow(hwndFBSmart, enable);
        
        HWND hwndAlpha = GetDlgItem (hwndDlg, IDC_FB_ALPHA);
        EnableWindow(hwndAlpha, enable);
        
        HWND hwndFBClear = GetDlgItem (hwndDlg, IDC_DB_CLEAR);
        EnableWindow(hwndFBClear, enable);
      }
      else if (LOWORD(wParam) == IDC_WRAPPER)
      {
        GRCONFIGWRAPPEREXT grConfigWrapperExt = (GRCONFIGWRAPPEREXT)grGetProcAddress("grConfigWrapperExt");
        if (grConfigWrapperExt)
          grConfigWrapperExt(hInstance, hwndDlg);
      }
      else if (LOWORD(wParam) == IDC_DB_RENDER)
      {
        if (SendMessage(GetDlgItem (hwndDlg, IDC_DB_RENDER), BM_GETCHECK, 0, 0) == BST_CHECKED)
        {
          settings.fb_depth_clear = TRUE;
          HWND hwndFBClear = GetDlgItem (hwndDlg, IDC_DB_CLEAR);
          SendMessage(hwndFBClear, BM_SETCHECK, BST_CHECKED, 0);
          EnableWindow(hwndFBClear, 0);
        }
        else
        {
          HWND hwndCustom = GetDlgItem (hwndDlg, IDC_CUSTOM);
          BOOL enable = (SendMessage(hwndCustom, BM_GETCHECK, 0, 0) != BST_CHECKED);
          HWND hwndFBClear = GetDlgItem (hwndDlg, IDC_DB_CLEAR);
          EnableWindow(hwndFBClear, enable);
        }
      }
    }
    return 0;
  }
  
  return 0;
}


BOOL CALLBACK DebugPageProc (HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch (uMsg)
  {
  case WM_NOTIFY:
    switch (((NMHDR FAR *) lParam)->code) {
#ifdef USE_TOOLTIPS
    case PSN_SETACTIVE: 
      if (!g_hhk)
      {
        g_hwndDlg = hwndDlg;
        g_hinst = hInstance;
        g_hwndTT = NULL;
        DoCreateDialogTooltip ();
      }
      break;
    case TTN_NEEDTEXT:
      OnWMNotify (lParam);
      break;
    case PSN_KILLACTIVE: 
    case PSN_QUERYCANCEL:
      //user clicked OK or selected another page
      if (g_hwndDlg == hwndDlg)
      {
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
        g_hwndDlg = NULL;
      }
      break;		
#endif
    case PSN_APPLY:
      // Debug/misc options
      GETBN (IDC_LOGGING, settings.logging);
      GETBN (IDC_LOGCLEAR, settings.log_clear);
      GETBN (IDC_RUNINWINDOW, settings.run_in_window);
      
      GETBN (IDC_CPU_HACK, settings.cpu_write_hack);
      
      GETBN (IDC_LOG_E, settings.elogging);
      GETBN (IDC_CACHEFILTER, settings.filter_cache);
      
      GETBN (IDC_UNKRED, settings.unk_as_red);
      GETBN (IDC_LOGUNK, settings.log_unk);
      GETBN (IDC_UNKCLEAR, settings.unk_clear);
      
      WriteSettings ();
      if (g_hwndDlg == hwndDlg)
      {
#ifdef USE_TOOLTIPS
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
#endif
        g_hwndDlg = NULL;
      }
      break;
    }
    return 0;
    
    case WM_INITDIALOG:
      {
        // Debug/misc options
        CHECKBN (IDC_LOGGING, settings.logging);
        CHECKBN (IDC_LOGCLEAR, settings.log_clear);
        CHECKBN (IDC_RUNINWINDOW, settings.run_in_window);
        CHECKBN (IDC_LOG_E, settings.elogging);
        CHECKBN (IDC_CPU_HACK, settings.cpu_write_hack);
        CHECKBN (IDC_CACHEFILTER, settings.filter_cache);
        CHECKBN (IDC_UNKRED, settings.unk_as_red);
        CHECKBN (IDC_LOGUNK, settings.log_unk);
        CHECKBN (IDC_UNKCLEAR, settings.unk_clear);
        
        
      }
      return 1;
      
    case WM_COMMAND:
      return 0;
  }
  
  return 0;
}


BOOL CALLBACK StatisticsPageProc (HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch (uMsg)
  {
  case WM_NOTIFY:
    switch (((NMHDR FAR *) lParam)->code) {
#ifdef USE_TOOLTIPS
    case PSN_SETACTIVE: 
      if (!g_hhk)
      {
        g_hwndDlg = hwndDlg;
        g_hinst = hInstance;
        g_hwndTT = NULL;
        DoCreateDialogTooltip ();
      }
      break;
    case TTN_NEEDTEXT:
      OnWMNotify (lParam);
      break;
    case PSN_KILLACTIVE: 
    case PSN_QUERYCANCEL:
      //user clicked OK or selected another page
      if (g_hwndDlg == hwndDlg)
      {
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
        g_hwndDlg = NULL;
      }
      break;		
#endif
    case PSN_APPLY:
      // speed counters
      settings.show_fps =
        ((SendMessage (GetDlgItem (hwndDlg, IDC_FPS),BM_GETCHECK, 0, 0)==BST_CHECKED)?1:0) |
        ((SendMessage (GetDlgItem (hwndDlg, IDC_FPS1),BM_GETCHECK, 0, 0)==BST_CHECKED)?2:0) |
        ((SendMessage (GetDlgItem (hwndDlg, IDC_FPS2),BM_GETCHECK, 0, 0)==BST_CHECKED)?4:0) |
        ((SendMessage (GetDlgItem (hwndDlg, IDC_FPS3),BM_GETCHECK, 0, 0)==BST_CHECKED)?8:0);
      
      GETBN (IDC_CLOCK, settings.clock);
      GETBN (IDC_CLOCK24, settings.clock_24_hr);
      
      WriteSettings ();
      if (g_hwndDlg == hwndDlg)
      {
#ifdef USE_TOOLTIPS
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
#endif
        g_hwndDlg = NULL;
      }
      break;
    }
    return 0;
    
    case WM_INITDIALOG:
      {
        // speed counters
        CHECKBN (IDC_FPS, settings.show_fps&1);
        CHECKBN (IDC_FPS1, settings.show_fps&2);
        CHECKBN (IDC_FPS2, settings.show_fps&4);
        CHECKBN (IDC_FPS3, settings.show_fps&8);
        
        CHECKBN (IDC_CLOCK, settings.clock);
        CHECKBN (IDC_CLOCK24, settings.clock_24_hr);
      }
      return 1;
      
    case WM_COMMAND:
      return 0;
  }
  
  return 0;
}

#ifdef TEXTURE_FILTER
BOOL CALLBACK TexFilterPageProc (HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch (uMsg)
  {
  case WM_NOTIFY:
    switch (((NMHDR FAR *) lParam)->code) {
#ifdef USE_TOOLTIPS
    case PSN_SETACTIVE: 
      if (!g_hhk)
      {
        g_hwndDlg = hwndDlg;
        g_hinst = hInstance;
        g_hwndTT = NULL;
        DoCreateDialogTooltip ();
      }
      break;
    case TTN_NEEDTEXT:
      OnWMNotify (lParam);
      break;
    case PSN_KILLACTIVE: 
    case PSN_QUERYCANCEL:
      //user clicked OK or selected another page
      if (g_hwndDlg == hwndDlg)
      {
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
        g_hwndDlg = NULL;
      }
      break;		
#endif
    case PSN_APPLY:
      // speed counters
      settings.ghq_fltr = (BYTE)SendMessage (GetDlgItem (hwndDlg, IDC_TEXFILTER_FILTER),
        CB_GETCURSEL, 0, 0);
      
      settings.ghq_enht = (BYTE)SendMessage (GetDlgItem (hwndDlg, IDC_TEXFILTER_ENHT),
        CB_GETCURSEL, 0, 0);
      
      settings.ghq_cmpr = (BYTE)SendMessage (GetDlgItem (hwndDlg, IDC_TEXFILTER_CMPR),
        CB_GETCURSEL, 0, 0);
      
      settings.ghq_hirs = (BYTE)SendMessage (GetDlgItem (hwndDlg, IDC_TEXFILTER_HIRES_FORMAT),
        CB_GETCURSEL, 0, 0);
      
      GETBN (IDC_TEXFILTER_ENHT_COMPRESS, settings.ghq_enht_cmpr);
//      GETBN (IDC_TEXFILTER_ENHT_TILE, settings.ghq_enht_tile);
//      GETBN (IDC_TEXFILTER_ENHT_F16BPP, settings.ghq_enht_f16bpp);
      settings.ghq_enht_tile = settings.ghq_enht_f16bpp = FALSE;
      GETBN (IDC_TEXFILTER_ENHT_GZ, settings.ghq_enht_gz);
      GETBN (IDC_TEXFILTER_HIRS_COMPRESS, settings.ghq_hirs_cmpr);
      GETBN (IDC_TEXFILTER_HIRS_TILE, settings.ghq_hirs_tile);
      GETBN (IDC_TEXFILTER_HIRS_F16BPP, settings.ghq_hirs_f16bpp);
      GETBN (IDC_TEXFILTER_HIRS_GZ, settings.ghq_hirs_gz);
      GETBN (IDC_TEXFILTER_CACHE_SAVE, settings.ghq_cache_save);
      GETBN (IDC_TEXFILTER_ENHT_IGNORE_BG, settings.ghq_enht_nobg);
      GETBN (IDC_TEXFILTER_HIRS_ALTCRC, settings.ghq_hirs_altcrc);
      GETBN (IDC_TEXFILTER_HIRS_LET_TEXARTISTS_FLY, settings.ghq_hirs_let_texartists_fly);
      
   	  char achTemp[4];
      SendMessage(GetDlgItem(hwndDlg, IDC_TEXFILTER_CACHE_SIZE), WM_GETTEXT, 4, 
        (LPARAM) achTemp);
      settings.ghq_cache_size = atoi((const char*)achTemp);
      
      WriteSettings ();
      if (g_hwndDlg == hwndDlg)
      {
#ifdef USE_TOOLTIPS
        if (g_hhk) UnhookWindowsHookEx (g_hhk);
        g_hhk = NULL;
#endif
        g_hwndDlg = NULL;
      }
      break;
    }
    return 0;
    
    case WM_INITDIALOG:
      {
        __try
        {
          if (!fullscreen)
          {
            grGlideInit ();
            grSstSelect (settings.card_id);
          }
          const char *extensions = grGetString (GR_EXTENSION);
          if (strstr (extensions, "EVOODOO"))
            evoodoo = 1;
          else
            evoodoo = 0;
          if (strstr (extensions, "TEXFMT"))
            sup_32bit_tex = TRUE;
          else
            sup_32bit_tex = FALSE;
          if (!fullscreen)
            grGlideShutdown ();
        }
        __except(EXCEPTION_EXECUTE_HANDLER)
        {
          ;
        }
        
        int i;
        HWND hwndTexFilter = GetDlgItem (hwndDlg, IDC_TEXFILTER_FILTER);
        for (i = 0; i < 7; i++)
          SendMessage (hwndTexFilter, CB_ADDSTRING, 0, (LPARAM)texfltr[i].menu_text);
        SendMessage (hwndTexFilter, CB_SETCURSEL, settings.ghq_fltr, 0);
        
        HWND hwndTexEnht = GetDlgItem (hwndDlg, IDC_TEXFILTER_ENHT);
        for (i = 0; i < 6; i++)
          SendMessage (hwndTexEnht, CB_ADDSTRING, 0, (LPARAM)texenht[i].menu_text);
        SendMessage (hwndTexEnht, CB_SETCURSEL, settings.ghq_enht, 0);
        
        HWND hwndTexHirs = GetDlgItem (hwndDlg, IDC_TEXFILTER_HIRES_FORMAT);
        for (i = 0; i < 2; i++)
          SendMessage (hwndTexHirs, CB_ADDSTRING, 0, (LPARAM)texhirs[i].menu_text);
        SendMessage (hwndTexHirs, CB_SETCURSEL, settings.ghq_hirs, 0);
        
        HWND hwndTexCmpr = GetDlgItem (hwndDlg, IDC_TEXFILTER_CMPR);
        if (sup_32bit_tex)
        {
          int num_of_comp = evoodoo ? 2 : 3;
          for (i = 0; i < num_of_comp; i++)
            SendMessage (hwndTexCmpr, CB_ADDSTRING, 0, (LPARAM)texcmpr[i].menu_text);
          SendMessage (hwndTexCmpr, CB_SETCURSEL, settings.ghq_cmpr, 0);
          CHECKBN (IDC_TEXFILTER_ENHT_COMPRESS, settings.ghq_enht_cmpr);
          CHECKBN (IDC_TEXFILTER_HIRS_COMPRESS, settings.ghq_hirs_cmpr);

//          CHECKBN (IDC_TEXFILTER_ENHT_F16BPP, settings.ghq_enht_f16bpp);
          CHECKBN (IDC_TEXFILTER_HIRS_F16BPP, settings.ghq_hirs_f16bpp);
        }
        else
        {
          settings.ghq_cmpr = 0;
          settings.ghq_enht_cmpr = settings.ghq_hirs_cmpr = FALSE;
          SendMessage (hwndTexCmpr, CB_ADDSTRING, 0, (LPARAM)texcmpr[0].menu_text);
          SendMessage (hwndTexCmpr, CB_SETCURSEL, 0, 0);
          EnableWindow(hwndTexCmpr, 0);
          EnableWindow(GetDlgItem (hwndDlg, IDC_TEXFILTER_CMPR_TEXT), 0);
          CHECKBN (IDC_TEXFILTER_ENHT_COMPRESS, 0);
          CHECKBN (IDC_TEXFILTER_HIRS_COMPRESS, 0);
          EnableWindow(GetDlgItem (hwndDlg, IDC_TEXFILTER_ENHT_COMPRESS), 0);
          EnableWindow(GetDlgItem (hwndDlg, IDC_TEXFILTER_HIRS_COMPRESS), 0);

          settings.ghq_enht_f16bpp = settings.ghq_hirs_f16bpp = TRUE;
//          CHECKBN (IDC_TEXFILTER_ENHT_F16BPP, 1);
          CHECKBN (IDC_TEXFILTER_HIRS_F16BPP, 1);
//          EnableWindow(GetDlgItem (hwndDlg, IDC_TEXFILTER_ENHT_F16BPP), 0);
          EnableWindow(GetDlgItem (hwndDlg, IDC_TEXFILTER_HIRS_F16BPP), 0);
        }

//        CHECKBN (IDC_TEXFILTER_ENHT_TILE, settings.ghq_enht_tile);
        CHECKBN (IDC_TEXFILTER_ENHT_GZ, settings.ghq_enht_gz);
        CHECKBN (IDC_TEXFILTER_HIRS_TILE, settings.ghq_hirs_tile);
        CHECKBN (IDC_TEXFILTER_HIRS_GZ, settings.ghq_hirs_gz);
        CHECKBN (IDC_TEXFILTER_CACHE_SAVE, settings.ghq_cache_save);
        CHECKBN (IDC_TEXFILTER_ENHT_IGNORE_BG, settings.ghq_enht_nobg);
        CHECKBN (IDC_TEXFILTER_HIRS_ALTCRC, settings.ghq_hirs_altcrc);
        CHECKBN (IDC_TEXFILTER_HIRS_LET_TEXARTISTS_FLY, settings.ghq_hirs_let_texartists_fly);
        
        char achTemp[8];
        sprintf(achTemp, "%d", settings.ghq_cache_size);
        SendMessage(GetDlgItem (hwndDlg, IDC_TEXFILTER_CACHE_SIZE), WM_SETTEXT, 0, (LPARAM) achTemp);
      }
      return 1;
      
    case WM_COMMAND:
      if (HIWORD(wParam) == BN_CLICKED) 
      {
        if (LOWORD(wParam) == IDC_TEXFILTER_SPEED)
        {
          if (sup_32bit_tex)
          {
            SendMessage ( GetDlgItem (hwndDlg, IDC_TEXFILTER_CMPR), CB_SETCURSEL, 1, 0);
            CHECKBN (IDC_TEXFILTER_ENHT_COMPRESS, 1);
            CHECKBN (IDC_TEXFILTER_HIRS_COMPRESS, 1);
//            CHECKBN (IDC_TEXFILTER_ENHT_TILE, 1);
            CHECKBN (IDC_TEXFILTER_HIRS_TILE, 1);
          }
          else
          {
            SendMessage ( GetDlgItem (hwndDlg, IDC_TEXFILTER_CMPR), CB_SETCURSEL, 0, 0);
            CHECKBN (IDC_TEXFILTER_ENHT_COMPRESS, 0);
            CHECKBN (IDC_TEXFILTER_HIRS_COMPRESS, 0);
//            CHECKBN (IDC_TEXFILTER_ENHT_TILE, 0);
            CHECKBN (IDC_TEXFILTER_HIRS_TILE, 0);
          }
//          CHECKBN (IDC_TEXFILTER_ENHT_F16BPP, 1);
          CHECKBN (IDC_TEXFILTER_HIRS_F16BPP, 1);
        }
        else if (LOWORD(wParam) == IDC_TEXFILTER_QUALITY)
        {
          if (sup_32bit_tex)
          {
//          CHECKBN (IDC_TEXFILTER_ENHT_F16BPP, 0);
          CHECKBN (IDC_TEXFILTER_HIRS_F16BPP, 0);
//          CHECKBN (IDC_TEXFILTER_ENHT_TILE, 0);
          CHECKBN (IDC_TEXFILTER_HIRS_TILE, 0);
          }
          else
          {
//          CHECKBN (IDC_TEXFILTER_ENHT_F16BPP, 1);
          CHECKBN (IDC_TEXFILTER_HIRS_F16BPP, 1);
//          CHECKBN (IDC_TEXFILTER_ENHT_TILE, 1);
          CHECKBN (IDC_TEXFILTER_HIRS_TILE, 1);
          }
          CHECKBN (IDC_TEXFILTER_ENHT_COMPRESS, 0);
          CHECKBN (IDC_TEXFILTER_HIRS_COMPRESS, 0);
          SendMessage ( GetDlgItem (hwndDlg, IDC_TEXFILTER_CMPR), CB_SETCURSEL, 0, 0);
        }
      }
      return 0;
  }
  
  return 0;
}
#endif
