/*
*	Glide64 - Glide video plugin for Nintendo 64 emulators.
*	Copyright (c) 2002  Dave2001
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//****************************************************************
//
// Glide64 - Glide Plugin for Nintendo 64 emulators (tested mostly with Project64)
// Project started on December 29th, 2001
//
// To modify Glide64:
// * Write your name and (optional)email, commented by your work, so I know who did it, and so that you can find which parts you modified when it comes time to send it to me.
// * Do NOT send me the whole project or file that you modified.  Take out your modified code sections, and tell me where to put them.  If people sent the whole thing, I would have many different versions, but no idea how to combine them all.
//
// Official Glide64 development channel: #Glide64 on EFnet
//
// Original author: Dave2001 (Dave2999@hotmail.com)
// Other authors: Gonetz, Gugaman
//
//****************************************************************

// INI code v1.1

#include "Gfx #1.3.h"

FILE *ini;
int sectionstart;
int last_line;		// last good line
int last_line_ret;	// last line ended in return?
WORD cr = 0x0A0D;

BOOL INI_Open ()
{
	// Get the path of the dll, ex: C:\Games\Project64\Plugin\Glide64.dll
	char path[256];
	GetModuleFileName (hInstance, path, 256);

	// Find the previous backslash
	int i;
	for (i=strlen(path)-1; i>0; i--)
	{
		if (path[i] == '\\')
			break;
	}
	if (path == 0) return FALSE;
	path[i+1] = 0;

	strcat (path, "Glide64.ini");

	// Open the file
	ini = fopen (path, "r+b");
	if (ini == NULL)
	{
		ini = fopen (path, "w+b");
		if (ini == NULL)
			return FALSE;
	}

	sectionstart = 0;
	last_line = 0;
	last_line_ret = 1;

	return TRUE;
}

void INI_Close ()
{
	fclose(ini);
}

void INI_InsertSpace(int space)
{
	// Since there is no good way to normally insert to or delete from a certain location in
	//  a file, this function was added.  It will insert (or delete) space bytes at the
	//  current location.

	// note: negative count means delete
	char chunk[2048];
	int len, file, start_pos, cur_pos;

	file = _fileno(ini);

	start_pos = ftell(ini);
	fseek(ini,0,SEEK_END);

	// if adding, extend the file
	if (space > 0)
		_chsize (file, _filelength(file)+space);

	while (1) {
		cur_pos = ftell(ini);
		len = cur_pos - start_pos;
		if (len == 0) break;
		if (len > 2048) len = 2048;

		fseek (ini,-len,SEEK_CUR);
		fread (chunk,1,len,ini);
		fseek (ini,-len+space,SEEK_CUR);
		fwrite (chunk,1,len,ini);
		fseek (ini,-len-space,SEEK_CUR);
	}

	// if deleted, make the file shorter
	if (space < 0)
		_chsize (file, _filelength(file)+space);
}

BOOL INI_FindSection (char *sectionname, BOOL create)
{
	char line[256], section[64];
	char *p;
	int  i, sectionfound, ret;

	rewind (ini);

	last_line = 0;
	sectionfound = 0;

	while(!feof(ini)) {
		ret = 0;
		*line=0;
		fgets(line,255,ini);

		// remove enter
		i=strlen(line);
		if(line[i-1]=='\n') ret=1, line[i-2]=0;

		// remove comments
		p=line;
		while(*p)
		{
			if (p[0]=='/' && p[1]=='/')
			{
				p[0]=0;
				break;
			}
			p++;
		}

		// skip starting space
		p=line;
		while(*p<=' ' && *p) p++;

		// empty line
		if(!*p) continue;

		last_line=ftell(ini);	// where to add if not found
		last_line_ret = ret;

		if(*p!='[') continue;

		p++;
		for (i=0;i<63;i++)
		{
			if(*p==']' || !*p) break;
			section[i]=*p++;
		}
		section[i]=0;

		if(!stricmp(section,sectionname))
		{
			sectionstart=ftell(ini);
			sectionfound=1;
			return TRUE;
		}
	}

	if (!sectionfound && create)
	{
		// create the section
		fseek(ini,last_line,SEEK_SET);
		INI_InsertSpace ((!last_line_ret) * 2 + 6 + strlen(sectionname));
		if (!last_line_ret) fwrite (&cr, 1, 2, ini);
		fwrite (&cr, 1, 2, ini);
		sprintf (section, "[%s]", sectionname);
		fwrite (section, 1, strlen(section), ini);
		fwrite (&cr, 1, 2, ini);
		sectionstart = ftell(ini);
		last_line = sectionstart;
		last_line_ret = 1;
		return TRUE;
	}

	return FALSE;
}

// Reads the value of item 'itemname' as a string.
char *INI_ReadString (char *itemname, char *value, char *def_value, BOOL create)
{
	char line[256], name[64];
	char *p, *n;
	int ret, i;
	*value = 0;

	fseek(ini,sectionstart,SEEK_SET);

	while(!feof(ini)) {
		ret = 0;
		*line=0;
		fgets(line,255,ini);

		// remove enter
		i=strlen(line);
		if(line[i-1]=='\n') ret=1, line[i-2]=0;

		// remove comments
		p=line;
		while(*p)
		{
			if (p[0]==';')
			{
				p[0]=0;
				break;
			}
			p++;
		}

		// skip starting space
		p=line;
		while(*p<=' ' && *p) p++;

		// empty line
		if(!*p) continue;

		// new section
		if(*p=='[') break;

		last_line=ftell(ini);	// where to add if not found
		last_line_ret = ret;

		// read name
		n = name;
		while(*p && *p!='=' && *p>' ') *n++ = *p++;
		*n = 0;

		if(!stricmp(name,itemname))
		{
			// skip spaces/equal sign
			while(*p<=' ' || *p=='=') p++;

			// read value
			n = value;
			while(*p) *n++ = *p++;

			// remove trailing spaces
			while (*(n-1) == ' ') n--;

			*n=0;

			return value;
		}
	}

	// uh-oh, not found.  we need to create
	if (create)
	{
		fseek(ini,last_line,SEEK_SET);
		INI_InsertSpace ((!last_line_ret) * 2 + strlen(itemname) + strlen(def_value) + 5);
		if (!last_line_ret) fwrite (&cr, 1, 2, ini);
		sprintf (line, "%s = %s", itemname, def_value);
		fwrite (line, 1, strlen(line), ini);
		fwrite (&cr, 1, 2, ini);
		last_line = ftell(ini);
		last_line_ret = 1;
	}

	strcpy (value, def_value);
	return value;
}

// Reads the value of item 'itemname' as a string.
void INI_WriteString (char *itemname, char *value)
{
	char line[256], name[64];
	char *p, *n;
	int ret, i;

	fseek(ini,sectionstart,SEEK_SET);

	while(!feof(ini)) {
		ret = 0;
		*line=0;
		fgets(line,255,ini);

		// remove enter
		i=strlen(line);
		if(line[i-1]=='\n') ret=1, line[i-2]=0;

		// remove comments
		p=line;
		while(*p)
		{
			if (p[0]=='/' && p[1]=='/')
			{
				p[0]=0;
				break;
			}
			p++;
		}

		// skip starting space
		p=line;
		while(*p<=' ' && *p) p++;

		// empty line
		if(!*p) continue;

		// new section
		if(*p=='[') break;

		last_line=ftell(ini);	// where to add if not found
		last_line_ret = ret;

		// read name
		n = name;
		while(*p && *p!='=' && *p>' ') *n++ = *p++;
		*n = 0;

		if(!stricmp(name,itemname))
		{
			INI_InsertSpace (-i + (strlen(itemname) + strlen(value) + 5));
			sprintf (line, "%s = %s", itemname, value);
			fseek (ini, -i, SEEK_CUR);
			fwrite (line, 1, strlen(line), ini);
			fwrite (&cr, 1, 2, ini);
			last_line = ftell(ini);
			last_line_ret = 1;
			return;
		}
	}

	// uh-oh, not found.  we need to create
	fseek(ini,last_line,SEEK_SET);
	INI_InsertSpace ((!last_line_ret) * 2 + strlen(itemname) + strlen(value) + 5);
	if (!last_line_ret) fwrite (&cr, 1, 2, ini);
	sprintf (line, "%s = %s", itemname, value);
	fwrite (line, 1, strlen(line), ini);
	fwrite (&cr, 1, 2, ini);
	last_line = ftell(ini);
	last_line_ret = 1;
	return;
}

int INI_ReadInt (char *itemname, int def_value, BOOL create)
{
	char value[64], def[64];
	_itoa (def_value, def, 10);
	INI_ReadString (itemname, value, def, create);
	return atoi (value);
}

void INI_WriteInt (char *itemname, int value)
{
	char valstr[64];
	_itoa (value, valstr, 10);
	INI_WriteString (itemname, valstr);
}
