/*
*	Glide64 - Glide video plugin for Nintendo 64 emulators.
*	Copyright (c) 2002  Dave2001
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//****************************************************************
//
// Glide64 - Glide Plugin for Nintendo 64 emulators (tested mostly with Project64)
// Project started on December 29th, 2001
//
// To modify Glide64:
// * Write your name and (optional)email, commented by your work, so I know who did it, and so that you can find which parts you modified when it comes time to send it to me.
// * Do NOT send me the whole project or file that you modified.  Take out your modified code sections, and tell me where to put them.  If people sent the whole thing, I would have many different versions, but no idea how to combine them all.
//
// Official Glide64 development channel: #Glide64 on EFnet
//
// Original author: Dave2001 (Dave2999@hotmail.com)
// Other authors: Gonetz, Gugaman
//
//****************************************************************

DWORD Load8bCI (DWORD dst, DWORD src, int wid_64, int height, int line, int real_width, int tile)
{
	if (wid_64 < 1) wid_64 = 1;
	if (height < 1) height = 1;
	int ext = (real_width - (wid_64 << 3)) << 1;
	DWORD pal = (DWORD)rdp.pal_8;

	if (rdp.tlut_mode == 2)
	{
		__asm {
			mov ebx,dword ptr [pal]
				
				mov esi,dword ptr [src]
				mov edi,dword ptr [dst]
				
				mov ecx,dword ptr [height]
y_loop:
			push ecx
				
				mov ecx,dword ptr [wid_64]
x_loop:
			push ecx
				
				mov eax,dword ptr [esi]		// read all 4 pixels
				bswap eax
				add esi,4
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// * copy
				mov eax,dword ptr [esi]		// read all 4 pixels
				bswap eax
				add esi,4
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				// *
				
				pop ecx
				
				dec ecx
				jnz x_loop
				
				pop ecx
				dec ecx
				jz end_y_loop
				push ecx
				
				add esi,dword ptr [line]
				add edi,dword ptr [ext]
				
				mov ecx,dword ptr [wid_64]
x_loop_2:
			push ecx
				
				mov eax,dword ptr [esi+4]		// read all 4 pixels
				bswap eax
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// * copy
				mov eax,dword ptr [esi]		// read all 4 pixels
				bswap eax
				add esi,8
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,1
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,1
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				// *
				
				pop ecx
				
				dec ecx
				jnz x_loop_2
				
				add esi,dword ptr [line]
				add edi,dword ptr [ext]
				
				pop ecx
				dec ecx
				jnz y_loop
				
end_y_loop:
	}
	return (1 << 16) | GR_TEXFMT_ARGB_1555;
	}
	else
	{
		__asm {
			mov ebx,dword ptr [pal]
				
				mov esi,dword ptr [src]
				mov edi,dword ptr [dst]
				
				mov ecx,dword ptr [height]
ia_y_loop:
			push ecx
				
				mov ecx,dword ptr [wid_64]
ia_x_loop:
			push ecx
				
				mov eax,dword ptr [esi]		// read all 4 pixels
				bswap eax
				add esi,4
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// * copy
				mov eax,dword ptr [esi]		// read all 4 pixels
				bswap eax
				add esi,4
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				// *
				
				pop ecx
				
				dec ecx
				jnz ia_x_loop
				
				pop ecx
				dec ecx
				jz ia_end_y_loop
				push ecx
				
				add esi,dword ptr [line]
				add edi,dword ptr [ext]
				
				mov ecx,dword ptr [wid_64]
ia_x_loop_2:
			push ecx
				
				mov eax,dword ptr [esi+4]		// read all 4 pixels
				bswap eax
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// * copy
				mov eax,dword ptr [esi]		// read all 4 pixels
				bswap eax
				add esi,8
				mov edx,eax
				
				// 1st dword output {
				shr eax,15
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				mov eax,edx
				shr eax,23
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				
				// 2nd dword output {
				mov eax,edx
				shl eax,1
				and eax,0x1FE
				mov cx,word ptr [ebx+eax]
				ror cx,8
				shl ecx,16
				
				shr edx,7
				and edx,0x1FE
				mov cx,word ptr [ebx+edx]
				ror cx,8
				
				mov dword ptr [edi],ecx
				add edi,4
				// }
				// *
				
				pop ecx
				
				dec ecx
				jnz ia_x_loop_2
				
				add esi,dword ptr [line]
				add edi,dword ptr [ext]
				
				pop ecx
				dec ecx
				jnz ia_y_loop
				
ia_end_y_loop:
	}
	return (1 << 16) | GR_TEXFMT_ALPHA_INTENSITY_88;
	}
	
	return 0;
}

//****************************************************************
// Size: 1, Format: 3
//
// ** by Gugaman **

DWORD Load8bIA (DWORD dst, DWORD src, int wid_64, int height, int line, int real_width, int tile)  
{ 
	if (rdp.tlut_mode != 0)
		return Load8bCI (dst, src, wid_64, height, line, real_width, tile);
	
	if (wid_64 < 1) wid_64 = 1;  
	if (height < 1) height = 1;  
	int ext = (real_width - (wid_64 << 3));  
	__asm {  
		mov esi,dword ptr [src]  
			mov edi,dword ptr [dst]  
			
			mov ecx,dword ptr [height]  
y_loop:  
		push ecx  
			
			mov ecx,dword ptr [wid_64]  
x_loop:  
		mov eax,dword ptr [esi]          // read all 4 pixels  
			add esi,4  
			
			xor ebx,ebx 
			mov edx,eax 
			shr eax,4//all alpha 
			and eax,0x0F0F0F0F 
			or ebx,eax 
			mov eax,edx//intensity 
			shl eax,4 
			and eax,0xF0F0F0F0 
			or ebx,eax 
			
			mov dword ptr [edi],ebx // save dword 
			add edi,4  
			
			mov eax,dword ptr [esi]          // read all 4 pixels  
			add esi,4  
			
			xor ebx,ebx 
			mov edx,eax 
			shr eax,4//all alpha 
			and eax,0x0F0F0F0F 
			or ebx,eax 
			mov eax,edx//intensity 
			shl eax,4 
			and eax,0xF0F0F0F0 
			or ebx,eax 
			
			mov dword ptr [edi],ebx // save dword 
			add edi,4  
			// *  
			
			dec ecx  
			jnz x_loop  
			
			pop ecx  
			dec ecx  
			jz end_y_loop  
			push ecx  
			
			add esi,dword ptr [line]  
			add edi,dword ptr [ext]  
			
			mov ecx,dword ptr [wid_64]  
x_loop_2:  
		mov eax,dword ptr [esi+4]          // read both pixels  
			
			xor ebx,ebx 
			mov edx,eax 
			shr eax,4//all alpha 
			and eax,0x0F0F0F0F 
			or ebx,eax 
			mov eax,edx//intensity 
			shl eax,4 
			and eax,0xF0F0F0F0 
			or ebx,eax 
			
			mov dword ptr [edi],ebx //save dword 
			add edi,4  
			
			mov eax,dword ptr [esi]          // read both pixels  
			add esi,8  
			
			xor ebx,ebx 
			mov edx,eax 
			shr eax,4//all alpha 
			and eax,0x0F0F0F0F 
			or ebx,eax 
			mov eax,edx//intensity 
			shl eax,4 
			and eax,0xF0F0F0F0 
			or ebx,eax 
			
			mov dword ptr [edi],ebx //save dword 
			add edi,4  
			// *  
			
			dec ecx  
			jnz x_loop_2  
            
			add esi,dword ptr [line]  
			add edi,dword ptr [ext]  
			
			pop ecx  
			dec ecx  
			jnz y_loop  
			
end_y_loop:  
	}  
	
	return /*(0 << 16) | */GR_TEXFMT_ALPHA_INTENSITY_44;  
} 

//****************************************************************
// Size: 1, Format: 4
//
// ** by Gugaman **

DWORD Load8bI (DWORD dst, DWORD src, int wid_64, int height, int line, int real_width, int tile)  
{ 
	if (rdp.tlut_mode != 0)
		return Load8bCI (dst, src, wid_64, height, line, real_width, tile);
	
	if (wid_64 < 1) wid_64 = 1;  
	if (height < 1) height = 1;  
	int ext = (real_width - (wid_64 << 3));  
	__asm {  
		mov esi,dword ptr [src]  
			mov edi,dword ptr [dst]  
			
			mov ecx,dword ptr [height]  
y_loop:  
		push ecx  
			
			mov ecx,dword ptr [wid_64]  
x_loop:  
		mov eax,dword ptr [esi]          // read all 4 pixels  
			add esi,4  
			
			mov dword ptr [edi],eax // save dword 
			add edi,4  
			
			mov eax,dword ptr [esi]          // read all 4 pixels  
			add esi,4  
			
			mov dword ptr [edi],eax // save dword 
			add edi,4  
			// *  
			
			dec ecx  
			jnz x_loop  
			
			pop ecx  
			dec ecx  
			jz end_y_loop  
			push ecx  
			
			add esi,dword ptr [line]  
			add edi,dword ptr [ext]  
			
			mov ecx,dword ptr [wid_64]  
x_loop_2:  
		mov eax,dword ptr [esi+4]          // read both pixels  
			
			mov dword ptr [edi],eax //save dword 
			add edi,4  
			
			mov eax,dword ptr [esi]          // read both pixels  
			add esi,8  
			
			mov dword ptr [edi],eax //save dword 
			add edi,4  
			// *  
			
			dec ecx  
			jnz x_loop_2  
            
			add esi,dword ptr [line]  
			add edi,dword ptr [ext]  
			
			pop ecx  
			dec ecx  
			jnz y_loop  
			
end_y_loop:  
	}  
	
     return /*(0 << 16) | */GR_TEXFMT_ALPHA_8;  
}

