/*
*	Glide64 - Glide video plugin for Nintendo 64 emulators.
*	Copyright (c) 2002  Dave2001
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//****************************************************************
//
// Glide64 - Glide Plugin for Nintendo 64 emulators (tested mostly with Project64)
// Project started on December 29th, 2001
//
// To modify Glide64:
// * Write your name and (optional)email, commented by your work, so I know who did it, and so that you can find which parts you modified when it comes time to send it to me.
// * Do NOT send me the whole project or file that you modified.  Take out your modified code sections, and tell me where to put them.  If people sent the whole thing, I would have many different versions, but no idea how to combine them all.
//
// Official Glide64 development channel: #Glide64 on EFnet
//
// Original author: Dave2001 (Dave2999@hotmail.com)
// Other authors: Gonetz, Gugaman
//
//****************************************************************

//****************************************************************
// 16-bit Horizontal Mirror

void Mirror16bS (DWORD tex, DWORD mask, DWORD max_width, DWORD real_width, DWORD height)
{
	if (mask == 0) return;

	DWORD mask_width = (1 << mask);
	DWORD mask_mask = (mask_width-1) << 1;
	if (mask_width >= max_width) return;
	int count = max_width - mask_width;
	if (count <= 0) return;
	int line_full = real_width << 1;
	int line = line_full - (count << 1);
	if (line < 0) return;
	DWORD start = tex + (mask_width << 1);

	__asm {
		mov edi,dword ptr [start]

		mov ecx,dword ptr [height]
loop_y:

		xor edx,edx
loop_x:
		mov esi,dword ptr [tex]
		mov ebx,dword ptr [mask_width]
		add ebx,edx
		and ebx,dword ptr [mask_width]
		jnz is_mirrored

		mov eax,edx
		shl eax,1
		and eax,dword ptr [mask_mask]
		add esi,eax
		mov ax,word ptr [esi]
		mov word ptr [edi],ax
		add edi,2
		jmp end_mirror_check
is_mirrored:
		add esi,dword ptr [mask_mask]
		mov eax,edx
		shl eax,1
		and eax,dword ptr [mask_mask]
		sub esi,eax
		mov ax,word ptr [esi]
		mov word ptr [edi],ax
		add edi,2
end_mirror_check:

		inc edx
		cmp edx,dword ptr [count]
		jne loop_x

		add edi,dword ptr [line]
		mov eax,dword ptr [tex]
		add eax,dword ptr [line_full]
		mov dword ptr [tex],eax

		dec ecx
		jnz loop_y
	}
}

//****************************************************************
// 16-bit Vertical Mirror

void Mirror16bT (DWORD tex, DWORD mask, DWORD max_height, DWORD real_width)
{
	if (mask == 0) return;

	DWORD mask_height = (1 << mask);
	DWORD mask_mask = mask_height-1;
	if (max_height <= mask_height) return;
	int line_full = real_width << 1;

	DWORD dst = tex + mask_height * line_full;

	for (DWORD y=mask_height; y<max_height; y++)
	{
		if (y & mask_height)
		{
			// mirrored
			memcpy ((void*)dst, (void*)(tex + (mask_mask - (y & mask_mask)) * line_full), line_full);
		}
		else
		{
			// not mirrored
			memcpy ((void*)dst, (void*)(tex + (y & mask_mask) * line_full), line_full);
		}

		dst += line_full;
	}
}

//****************************************************************
// 16-bit Horizontal Wrap (like mirror)

void Wrap16bS (DWORD tex, DWORD mask, DWORD max_width, DWORD real_width, DWORD height)
{
	if (mask == 0) return;

	DWORD mask_width = (1 << mask);
	DWORD mask_mask = (mask_width-1) >> 1;
	if (mask_width >= max_width) return;
	int count = (max_width - mask_width) >> 1;
	if (count <= 0) return;
	int line_full = real_width << 1;
	int line = line_full - (count << 2);
	if (line < 0) return;
	DWORD start = tex + (mask_width << 1);

	__asm {
		mov edi,dword ptr [start]

		mov ecx,dword ptr [height]
loop_y:

		xor edx,edx
loop_x:

		mov esi,dword ptr [tex]
		mov eax,edx
		and eax,dword ptr [mask_mask]
		shl eax,2
		add esi,eax
		mov eax,dword ptr [esi]
		mov dword ptr [edi],eax
		add edi,4

		inc edx
		cmp edx,dword ptr [count]
		jne loop_x

		add edi,dword ptr [line]
		mov eax,dword ptr [tex]
		add eax,dword ptr [line_full]
		mov dword ptr [tex],eax

		dec ecx
		jnz loop_y
	}
}

//****************************************************************
// 16-bit Vertical Wrap

void Wrap16bT (DWORD tex, DWORD mask, DWORD max_height, DWORD real_width)
{
	if (mask == 0) return;

	DWORD mask_height = (1 << mask);
	DWORD mask_mask = mask_height-1;
	if (max_height <= mask_height) return;
	int line_full = real_width << 1;

	DWORD dst = tex + mask_height * line_full;

	for (DWORD y=mask_height; y<max_height; y++)
	{
		// not mirrored
		memcpy ((void*)dst, (void*)(tex + (y & mask_mask) * line_full), line_full);

		dst += line_full;
	}
}

//****************************************************************
// 16-bit Horizontal Clamp

void Clamp16bS (DWORD tex, DWORD width, DWORD clamp_to, DWORD real_width, DWORD real_height)
{
	if (real_width <= width) return;

	DWORD dest = tex + (width << 1);
	DWORD constant = dest-2;
	int count = clamp_to - width;

	int line_full = real_width << 1;
	int line = width << 1;

	__asm {
		mov esi,dword ptr [constant]
		mov edi,dword ptr [dest]

		mov ecx,real_height
y_loop:

		mov ax,word ptr [esi]

		mov edx,dword ptr [count]
x_loop:

		mov word ptr [edi],ax		// don't unroll or make dword, it may go into next line (doesn't have to be multiple of two)
		add edi,2

		dec edx
		jnz x_loop

		add esi,dword ptr [line_full]
		add edi,dword ptr [line]

		dec ecx
		jnz y_loop
	}
}

//****************************************************************
// 16-bit Vertical Clamp

void Clamp16bT (DWORD tex, DWORD height, DWORD real_width, DWORD clamp_to)
{
	int line_full = real_width << 1;
	DWORD dst = tex + height * line_full;
	DWORD const_line = dst - line_full;

	for (DWORD y=height; y<clamp_to; y++)
	{
		memcpy ((void*)dst, (void*)const_line, line_full);
		dst += line_full;
	}
}
