#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int   u32;

#include "gp2x_psp.h"
#include <time.h>

# ifndef CLK_TCK
# define CLK_TCK  CLOCKS_PER_SEC
# endif

#define CPU_CLOCK_IDLE 60
#define CPU_CLOCK_STD 200


//LUDO:
# define MSX_RENDER_FAST       0
# define MSX_RENDER_NORMAL     1
# define MSX_RENDER_FIT        2
# define MSX_LAST_RENDER       2

# define MAX_PATH   256
# define MSX_MAX_SAVE_STATE 5

# define MSX_WIDTH    272
# define MSX_HEIGHT   228
# define SCR_WIDTH    MSX_WIDTH 
# define SCR_HEIGHT   MSX_HEIGHT
# define SNAP_WIDTH   (MSX_WIDTH/2)
# define SNAP_HEIGHT  (MSX_HEIGHT/2)

#include <SDL.h>

  typedef struct MSX_save_t {

    SDL_Surface    *surface;
    char            used;
    char            thumb;
    time_t          date;

  } MSX_save_t;

  typedef struct MSX_t {
 
    MSX_save_t msx_save_state[MSX_MAX_SAVE_STATE];
    char msx_save_name[MAX_PATH];
    char msx_home_dir[MAX_PATH];
    int  msx_speed_limiter;
    int  msx_version;
    int  msx_ram_pages;
    int  msx_ntsc;
    int  psp_screenshot_id;
    int  psp_cpu_clock;
    int  psp_joystick_cursor;
    int  psp_display_lr;
    int  msx_snd_enable;
    int  msx_view_fps;
    int  msx_current_fps;
    int  msx_render_mode;
    int  psp_skip_max_frame;
    int  psp_skip_cur_frame;
    int  msx_use_2413;
    int  msx_use_8950;

  } MSX_t;

  extern MSX_t MSX;


//END_LUDO:

# endif
