/*
   Ludovic Jacomme <Ludovic.Jacomme@gmail.com>
*/

#include <stdlib.h>
#include <stdio.h>

#include <zlib.h>
#include <string>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include "global.h"
#include "psp_fmgr.h"
#include "psp_kbd.h"
#include "psp_danzeff.h"
#include "psp_sdl.h"

#include "Cartridge.h"
#include "ProSystem.h"
#include "Database.h"
#include "Sound.h"

extern "C" {

static word display_palette16[256] = {0};

void
psp_atari_reset()
{
  prosystem_Reset();
}

int
psp_atari_load_state(char *filename)
{
  int error;

  std::string std_filename(filename);
  error = prosystem_Load(filename) ? 0 : 1;

  return error;
}

int
psp_atari_save_state(char *filename)
{
  int error;

  std::string std_filename(filename);
  error = prosystem_Save(filename, true) ? 0 : 1;

  return error;
}

int 
psp_atari_load_rom(char *filename) 
{
  std::string std_filename(filename);
  if(! cartridge_Load(std_filename)) return 1;

# if 0
    sound_Stop( );
    display_Clear( );
# endif
  database_Load(cartridge_digest);

  prosystem_Reset();

# if 0
    std::string title = std::string(CONSOLE_TITLE) + " - " + common_Trim(cartridge_title);
    SetWindowText(console_hWnd, title.c_str( ));
    console_AddRecent(filename);
    display_ResetPalette( );
    console_SetZoom(display_zoom);
    sound_Play( );
# endif
  return 0;
}

/* LUDO: */
void
atari_synchronize(void)
{
  static u32 nextclock = 1;

  if (nextclock) {
    u32 curclock;
    do {
     curclock = SDL_GetTicks();
    } while (curclock < nextclock);
    nextclock = curclock + (u32)( 1000 / ATARI.atari_speed_limiter);
  }
}

void
atari_update_fps()
{
  static u32 next_sec_clock = 0;
  static u32 cur_num_frame = 0;
  cur_num_frame++;
  u32 curclock = SDL_GetTicks();
  if (curclock > next_sec_clock) {
    next_sec_clock = curclock + 1000;
    ATARI.atari_current_fps = cur_num_frame;
    cur_num_frame = 0;
  }
}

void
psp_atari_init_palette16()
{
  uint rsize  =  6;
  uint gsize  =  5;
  uint bsize  =  6;
      
  for(uint index = 0; index < 256; index++) {
    word r = palette_data[(index * 3) + 0];
    word g = palette_data[(index * 3) + 1];
    word b = palette_data[(index * 3) + 2];
    display_palette16[index] = psp_sdl_rgb(r, g, b);
  }
}

# if 0
//LUDO: HACK
static int loc_toggle_line = 0;

static inline void
psp_atari_put_image_normal()
{
  /* 320 x 223 */
  uint height = maria_visibleArea.GetHeight( );
  uint length = maria_visibleArea.GetLength( );

  const byte* buffer = maria_surface + 
      ((maria_visibleArea.top - maria_displayArea.top) * maria_visibleArea.GetLength( ));

  loc_toggle_line = (loc_toggle_line + 1) & 0x3;

  word* surface = (word*)psp_sdl_get_vram_addr(0, 8);
  uint pitch = PSP_LINE_SIZE;
  height = height >> 1;
  if (loc_toggle_line <= 1) {
    surface += pitch * height;
    buffer  += length * height;
  }
  for(uint indexY = 0; indexY < height; indexY++) {
    for(uint indexX = 0; indexX < length; indexX += 4) {
      surface[indexX + 0] = display_palette16[buffer[indexX + 0]];
      surface[indexX + 1] = display_palette16[buffer[indexX + 1]];
      surface[indexX + 2] = display_palette16[buffer[indexX + 2]];
      surface[indexX + 3] = display_palette16[buffer[indexX + 3]];
    }
    surface += pitch;
    buffer += length;
  }
}
# endif

static inline void
psp_atari_put_image_normal()
{
  /* 320 x 223 */
  uint height = maria_visibleArea.GetHeight( );
  uint length = maria_visibleArea.GetLength( );

  const byte* buffer = maria_surface + 
      ((maria_visibleArea.top - maria_displayArea.top) * maria_visibleArea.GetLength( ));

  uint* surface = (uint*)psp_sdl_get_vram_addr(0, 8);
  uint pitch = PSP_LINE_SIZE >> 1;
  uint maxX = length;
  //LUDO: HACK
  for(uint indexY = 0; indexY < height; indexY++) {
    for(uint indexX = 0; indexX < maxX; indexX += 2) {
      uint color = (display_palette16[buffer[indexX+1]] << 16) | display_palette16[buffer[indexX]];
      surface[indexX >> 1] = color;
    }
    surface += pitch;
    buffer += length;
  }
}

void
psp_atari_refresh_screen()
{
  if (ATARI.psp_skip_cur_frame <= 0) {

    ATARI.psp_skip_cur_frame = ATARI.psp_skip_max_frame;

    psp_atari_put_image_normal(); 

    if (psp_kbd_is_danzeff_mode()) {
      danzeff_moveTo(-10, -65);
      danzeff_render();
    }

    if (ATARI.atari_view_fps) {
      char buffer[32];
      sprintf(buffer, "FPS:%3d", (int)ATARI.atari_current_fps);
      psp_sdl_fill_print(15, 0, buffer, psp_sdl_rgb(0xff,0xff,0xff), 0 );
    }

    psp_kbd_display_active_mapping();
    psp_sdl_flip();
  
    if (psp_screenshot_mode) {
      psp_screenshot_mode--;
      if (psp_screenshot_mode <= 0) {
        psp_sdl_save_screenshot();
        psp_screenshot_mode = 0;
      }
    }
  } else if (ATARI.psp_skip_max_frame) {
    ATARI.psp_skip_cur_frame--;
  }


  if (ATARI.atari_speed_limiter) {
    atari_synchronize();
  }

  if (ATARI.atari_view_fps) {
    atari_update_fps();
  }
}

void
psp_atari_main_loop()
{
  if (bios_Load("./7800.rom")) {
    bios_enabled = true;
  }
  /* Open default rom */
  if (psp_atari_load_rom("./default.a78")) {
    psp_sdl_exit(1);
  }

  psp_atari_init_palette16();

  while (1) {
    psp_update_keys();

    if(prosystem_active && !prosystem_paused) {
      prosystem_ExecuteFrame(ATARI.keyboard_data);
      sound_Store();
      psp_atari_refresh_screen();
    }
  }
}

};
