// ----------------------------------------------------------------------------
//   ___  ___  ___  ___       ___  ____  ___  _  _
//  /__/ /__/ /  / /__  /__/ /__    /   /_   / |/ /
// /    / \  /__/ ___/ ___/ ___/   /   /__  /    /  emulator
//
// ----------------------------------------------------------------------------
// Copyright 2005 Greg Stanton
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ----------------------------------------------------------------------------
// Region.h
// ----------------------------------------------------------------------------
#include "Region.h"

byte region_type = REGION_AUTO;

static const rect REGION_VISIBLE_AREA_NTSC = {0, 26, 319, 248};
static const rect REGION_VISIBLE_AREA_PAL = {0, 26, 319, 297};
static const rect REGION_DISPLAY_AREA_NTSC = {0, 16, 319, 258};
static const rect REGION_DISPLAY_AREA_PAL = {0, 16, 319, 306};
static const byte REGION_FREQUENCY_NTSC = 60;
static const word REGION_SCANLINES_NTSC = 262;
static const byte REGION_FREQUENCY_PAL = 50;
static const word REGION_SCANLINES_PAL = 312;

// ----------------------------------------------------------------------------
// PALETTE NTSC
// ----------------------------------------------------------------------------
static const byte REGION_PALETTE_NTSC[ ] = {
  0x00,0x00,0x00,0x25,0x25,0x25,0x34,0x34,0x34,0x4f,0x4f,0x4f,
  0x5b,0x5b,0x5b,0x69,0x69,0x69,0x7b,0x7b,0x7b,0x8a,0x8a,0x8a,
  0xa7,0xa7,0xa7,0xb9,0xb9,0xb9,0xc5,0xc5,0xc5,0xd0,0xd0,0xd0,
  0xd7,0xd7,0xd7,0xe1,0xe1,0xe1,0xf4,0xf4,0xf4,0xff,0xff,0xff,
  0x4c,0x32,0x00,0x62,0x3a,0x00,0x7b,0x4a,0x00,0x9a,0x60,0x00,
  0xb5,0x74,0x00,0xcc,0x85,0x00,0xe7,0x9e,0x08,0xf7,0xaf,0x10,
  0xff,0xc3,0x18,0xff,0xd0,0x20,0xff,0xd8,0x28,0xff,0xdf,0x30,
  0xff,0xe6,0x38,0xff,0xf4,0x40,0xff,0xfa,0x48,0xff,0xff,0x50,
  0x41,0x20,0x00,0x6a,0x22,0x00,0x8f,0x2e,0x00,0xa5,0x4a,0x00,
  0xc7,0x59,0x00,0xeb,0x70,0x00,0xfc,0x81,0x00,0xff,0x90,0x00,
  0xff,0x9e,0x10,0xff,0xac,0x20,0xff,0xba,0x3a,0xff,0xbf,0x50,
  0xff,0xc6,0x6d,0xff,0xd5,0x80,0xff,0xe4,0x90,0xff,0xe6,0x99,
  0x5d,0x1f,0x0c,0x7a,0x24,0x0d,0x98,0x2c,0x0e,0xb0,0x2f,0x0f,
  0xbf,0x36,0x24,0xd3,0x4e,0x2a,0xe7,0x62,0x3e,0xf3,0x6e,0x4a,
  0xfd,0x78,0x54,0xff,0x8a,0x6a,0xff,0x98,0x7c,0xff,0xa4,0x8b,
  0xff,0xb3,0x9e,0xff,0xc2,0xb2,0xff,0xd0,0xba,0xff,0xd7,0xc0,
  0x60,0x0c,0x0c,0x7d,0x0d,0x0d,0xaa,0x15,0x15,0xcb,0x1a,0x1a,
  0xe3,0x1f,0x1f,0xf5,0x20,0x20,0xff,0x40,0x40,0xff,0x5a,0x5a,
  0xff,0x70,0x70,0xff,0x7e,0x7e,0xff,0x8f,0x8f,0xff,0x9f,0x9f,
  0xff,0xab,0xab,0xff,0xb9,0xb9,0xff,0xc9,0xc9,0xff,0xcf,0xcf,
  0x4e,0x00,0x32,0x66,0x00,0x4b,0x80,0x00,0x5f,0x95,0x0b,0x74,
  0xaa,0x22,0x88,0xbb,0x2f,0x9a,0xce,0x3f,0xad,0xd7,0x5a,0xb6,
  0xe4,0x67,0xc3,0xef,0x72,0xce,0xfb,0x7e,0xda,0xff,0x8d,0xe1,
  0xff,0x9d,0xe5,0xff,0xa5,0xe7,0xff,0xaf,0xea,0xff,0xb8,0xec,
  0x48,0x00,0x6c,0x5c,0x04,0x88,0x65,0x0d,0x90,0x7b,0x23,0xa7,
  0x93,0x3b,0xbf,0x9d,0x45,0xc9,0xa7,0x4f,0xd3,0xb2,0x5a,0xde,
  0xbd,0x65,0xe9,0xc5,0x6d,0xf1,0xce,0x76,0xfa,0xd5,0x83,0xff,
  0xda,0x90,0xff,0xde,0x9c,0xff,0xe2,0xa9,0xff,0xe6,0xb6,0xff,
  0x1b,0x00,0x70,0x22,0x1b,0x8d,0x37,0x30,0xa2,0x48,0x41,0xb3,
  0x59,0x52,0xc4,0x63,0x5c,0xce,0x6f,0x68,0xda,0x7d,0x76,0xe8,
  0x87,0x80,0xf8,0x93,0x8c,0xff,0x9d,0x97,0xff,0xa8,0xa3,0xff,
  0xb3,0xaf,0xff,0xbc,0xb8,0xff,0xc4,0xc1,0xff,0xda,0xd1,0xff,
  0x00,0x0d,0x7f,0x00,0x12,0xa7,0x00,0x18,0xc0,0x0a,0x2b,0xd1,
  0x1b,0x4a,0xe3,0x2f,0x58,0xf0,0x37,0x68,0xff,0x49,0x79,0xff,
  0x5b,0x85,0xff,0x6d,0x96,0xff,0x7f,0xa3,0xff,0x8c,0xad,0xff,
  0x96,0xb4,0xff,0xa8,0xc0,0xff,0xb7,0xcb,0xff,0xc6,0xd6,0xff,
  0x00,0x29,0x5a,0x00,0x38,0x76,0x00,0x48,0x92,0x00,0x5c,0xac,
  0x00,0x71,0xc6,0x00,0x86,0xd0,0x0a,0x9b,0xdf,0x1a,0xa8,0xec,
  0x2b,0xb6,0xff,0x3f,0xc2,0xff,0x45,0xcb,0xff,0x59,0xd3,0xff,
  0x7f,0xda,0xff,0x8f,0xde,0xff,0xa0,0xe2,0xff,0xb0,0xeb,0xff,
  0x00,0x3a,0x54,0x00,0x43,0x62,0x00,0x54,0x78,0x00,0x69,0x90,
  0x00,0x7e,0xa8,0x00,0x97,0xbb,0x00,0xaf,0xce,0x00,0xbe,0xdf,
  0x00,0xc9,0xf6,0x05,0xda,0xff,0x18,0xe5,0xff,0x34,0xea,0xff,
  0x49,0xef,0xff,0x66,0xf2,0xff,0x84,0xf4,0xff,0x9e,0xf9,0xff,
  0x00,0x4a,0x00,0x00,0x5d,0x00,0x00,0x70,0x00,0x00,0x83,0x00,
  0x00,0x95,0x00,0x00,0xab,0x00,0x07,0xbd,0x07,0x0a,0xd0,0x0a,
  0x1d,0xdf,0x1d,0x2e,0xe6,0x2e,0x3f,0xef,0x3f,0x50,0xf7,0x50,
  0x6a,0xff,0x6a,0x87,0xff,0x87,0x9b,0xff,0x9b,0xae,0xff,0xae,
  0x22,0x4a,0x03,0x27,0x53,0x04,0x30,0x64,0x05,0x3c,0x77,0x0c,
  0x45,0x8c,0x11,0x5a,0xa5,0x13,0x63,0xae,0x15,0x6b,0xb6,0x17,
  0x7b,0xc5,0x1b,0x84,0xcc,0x1e,0x8d,0xd7,0x24,0x8f,0xe1,0x2c,
  0xa2,0xe8,0x36,0xb3,0xf2,0x4a,0xbb,0xf6,0x5d,0xc4,0xf8,0x70,
  0x2e,0x3f,0x0c,0x36,0x4a,0x0f,0x40,0x56,0x15,0x46,0x5f,0x17,
  0x57,0x77,0x1a,0x65,0x85,0x1c,0x74,0x93,0x1d,0x8f,0xa5,0x25,
  0xad,0xb7,0x2c,0xbc,0xc7,0x30,0xc9,0xd5,0x33,0xd4,0xe0,0x3b,
  0xe0,0xec,0x42,0xea,0xf6,0x45,0xf0,0xfd,0x47,0xf4,0xff,0x6f,
  0x40,0x37,0x09,0x47,0x3f,0x0a,0x54,0x4f,0x0b,0x6c,0x58,0x0c,
  0x90,0x76,0x0f,0xab,0x8b,0x1a,0xc1,0xa1,0x20,0xd0,0xb0,0x2f,
  0xde,0xbe,0x3f,0xe6,0xc6,0x45,0xed,0xcd,0x57,0xf5,0xd8,0x5f,
  0xfb,0xe5,0x67,0xfc,0xee,0x6f,0xfd,0xf3,0x77,0xfd,0xf3,0x7f,
  0x42,0x20,0x00,0x5c,0x27,0x00,0x75,0x2d,0x06,0x92,0x45,0x0d,
  0xb1,0x5e,0x18,0xbb,0x72,0x20,0xc5,0x86,0x29,0xd7,0x96,0x33,
  0xe6,0xa4,0x40,0xf4,0xb1,0x4b,0xfc,0xbb,0x58,0xff,0xc6,0x6f,
  0xff,0xcd,0x80,0xff,0xd4,0x90,0xff,0xdd,0xaa,0xff,0xe4,0xbf
};

// --------------------------------------------------------------------------------------
// PALETTE PAL
// --------------------------------------------------------------------------------------
static const byte REGION_PALETTE_PAL[ ] = {
  0x00,0x00,0x00,0x1c,0x1c,0x1c,0x39,0x39,0x39,0x59,0x59,0x59,
  0x79,0x79,0x79,0x92,0x92,0x92,0xab,0xab,0xab,0xbc,0xbc,0xbc,
  0xcd,0xcd,0xcd,0xd9,0xd9,0xd9,0xe6,0xe6,0xe6,0xec,0xec,0xec,
  0xf2,0xf2,0xf2,0xf8,0xf8,0xf8,0xff,0xff,0xff,0xff,0xff,0xff,
  0x26,0x30,0x01,0x24,0x38,0x03,0x23,0x40,0x05,0x51,0x54,0x1b,
  0x80,0x69,0x31,0x97,0x81,0x35,0xaf,0x99,0x3a,0xc2,0xa7,0x3e,
  0xd5,0xb5,0x43,0xdb,0xc0,0x3d,0xe1,0xcb,0x38,0xe2,0xd8,0x36,
  0xe3,0xe5,0x34,0xef,0xf2,0x58,0xfb,0xff,0x7d,0xfb,0xff,0x7d,
  0x39,0x17,0x01,0x5e,0x23,0x04,0x83,0x30,0x08,0xa5,0x47,0x16,
  0xc8,0x5f,0x24,0xe3,0x78,0x20,0xff,0x91,0x1d,0xff,0xab,0x1d,
  0xff,0xc5,0x1d,0xff,0xce,0x34,0xff,0xd8,0x4c,0xff,0xe6,0x51,
  0xff,0xf4,0x56,0xff,0xf9,0x77,0xff,0xff,0x98,0xff,0xff,0x98,
  0x45,0x19,0x04,0x72,0x1e,0x11,0x9f,0x24,0x1e,0xb3,0x3a,0x20,
  0xc8,0x51,0x22,0xe3,0x69,0x20,0xff,0x81,0x1e,0xff,0x8c,0x25,
  0xff,0x98,0x2c,0xff,0xae,0x38,0xff,0xc5,0x45,0xff,0xc5,0x59,
  0xff,0xc6,0x6d,0xff,0xd5,0x87,0xff,0xe4,0xa1,0xff,0xe4,0xa1,
  0x4a,0x17,0x04,0x7e,0x1a,0x0d,0xb2,0x1d,0x17,0xc8,0x21,0x19,
  0xdf,0x25,0x1c,0xec,0x3b,0x38,0xfa,0x52,0x55,0xfc,0x61,0x61,
  0xff,0x70,0x6e,0xff,0x7f,0x7e,0xff,0x8f,0x8f,0xff,0x9d,0x9e,
  0xff,0xab,0xad,0xff,0xb9,0xbd,0xff,0xc7,0xce,0xff,0xc7,0xce,
  0x05,0x05,0x68,0x3b,0x13,0x6d,0x71,0x22,0x72,0x8b,0x2a,0x8c,
  0xa5,0x32,0xa6,0xb9,0x38,0xba,0xcd,0x3e,0xcf,0xdb,0x47,0xdd,
  0xea,0x51,0xeb,0xf4,0x5f,0xf5,0xfe,0x6d,0xff,0xfe,0x7a,0xfd,
  0xff,0x87,0xfb,0xff,0x95,0xfd,0xff,0xa4,0xff,0xff,0xa4,0xff,
  0x28,0x04,0x79,0x40,0x09,0x84,0x59,0x0f,0x90,0x70,0x24,0x9d,
  0x88,0x39,0xaa,0xa4,0x41,0xc3,0xc0,0x4a,0xdc,0xd0,0x54,0xed,
  0xe0,0x5e,0xff,0xe9,0x6d,0xff,0xf2,0x7c,0xff,0xf8,0x8a,0xff,
  0xff,0x98,0xff,0xfe,0xa1,0xff,0xfe,0xab,0xff,0xfe,0xab,0xff,
  0x35,0x08,0x8a,0x42,0x0a,0xad,0x50,0x0c,0xd0,0x64,0x28,0xd0,
  0x79,0x45,0xd0,0x8d,0x4b,0xd4,0xa2,0x51,0xd9,0xb0,0x58,0xec,
  0xbe,0x60,0xff,0xc5,0x6b,0xff,0xcc,0x77,0xff,0xd1,0x83,0xff,
  0xd7,0x90,0xff,0xdb,0x9d,0xff,0xdf,0xaa,0xff,0xdf,0xaa,0xff,
  0x05,0x1e,0x81,0x06,0x26,0xa5,0x08,0x2f,0xca,0x26,0x3d,0xd4,
  0x44,0x4c,0xde,0x4f,0x5a,0xee,0x5a,0x68,0xff,0x65,0x75,0xff,
  0x71,0x83,0xff,0x80,0x91,0xff,0x90,0xa0,0xff,0x97,0xa9,0xff,
  0x9f,0xb2,0xff,0xaf,0xbe,0xff,0xc0,0xcb,0xff,0xc0,0xcb,0xff,
  0x05,0x1e,0x81,0x06,0x26,0xa5,0x08,0x2f,0xca,0x26,0x3d,0xd4,
  0x44,0x4c,0xde,0x4f,0x5a,0xee,0x5a,0x68,0xff,0x65,0x75,0xff,
  0x71,0x83,0xff,0x80,0x91,0xff,0x90,0xa0,0xff,0x97,0xa9,0xff,
  0x9f,0xb2,0xff,0xaf,0xbe,0xff,0xc0,0xcb,0xff,0xc0,0xcb,0xff,
  0x0c,0x04,0x8b,0x22,0x18,0xa0,0x38,0x2d,0xb5,0x48,0x3e,0xc7,
  0x58,0x4f,0xda,0x61,0x59,0xec,0x6b,0x64,0xff,0x7a,0x74,0xff,
  0x8a,0x84,0xff,0x91,0x8e,0xff,0x99,0x98,0xff,0xa5,0xa3,0xff,
  0xb1,0xae,0xff,0xb8,0xb8,0xff,0xc0,0xc2,0xff,0xc0,0xc2,0xff,
  0x1d,0x29,0x5a,0x1d,0x38,0x76,0x1d,0x48,0x92,0x1c,0x5c,0xac,
  0x1c,0x71,0xc6,0x32,0x86,0xcf,0x48,0x9b,0xd9,0x4e,0xa8,0xec,
  0x55,0xb6,0xff,0x70,0xc7,0xff,0x8c,0xd8,0xff,0x93,0xdb,0xff,
  0x9b,0xdf,0xff,0xaf,0xe4,0xff,0xc3,0xe9,0xff,0xc3,0xe9,0xff,
  0x2f,0x43,0x02,0x39,0x52,0x02,0x44,0x61,0x03,0x41,0x7a,0x12,
  0x3e,0x94,0x21,0x4a,0x9f,0x2e,0x57,0xab,0x3b,0x5c,0xbd,0x55,
  0x61,0xd0,0x70,0x69,0xe2,0x7a,0x72,0xf5,0x84,0x7c,0xfa,0x8d,
  0x87,0xff,0x97,0x9a,0xff,0xa6,0xad,0xff,0xb6,0xad,0xff,0xb6,
  0x0a,0x41,0x08,0x0d,0x54,0x0a,0x10,0x68,0x0d,0x13,0x7d,0x0f,
  0x16,0x92,0x12,0x19,0xa5,0x14,0x1c,0xb9,0x17,0x1e,0xc9,0x19,
  0x21,0xd9,0x1b,0x47,0xe4,0x2d,0x6e,0xf0,0x40,0x78,0xf7,0x4d,
  0x83,0xff,0x5b,0x9a,0xff,0x7a,0xb2,0xff,0x9a,0xb2,0xff,0x9a,
  0x04,0x41,0x0b,0x05,0x53,0x0e,0x06,0x66,0x11,0x07,0x77,0x14,
  0x08,0x88,0x17,0x09,0x9b,0x1a,0x0b,0xaf,0x1d,0x48,0xc4,0x1f,
  0x86,0xd9,0x22,0x8f,0xe9,0x24,0x99,0xf9,0x27,0xa8,0xfc,0x41,
  0xb7,0xff,0x5b,0xc9,0xff,0x6e,0xdc,0xff,0x81,0xdc,0xff,0x81,
  0x02,0x35,0x0f,0x07,0x3f,0x15,0x0c,0x4a,0x1c,0x2d,0x5f,0x1e,
  0x4f,0x74,0x20,0x59,0x83,0x24,0x64,0x92,0x28,0x82,0xa1,0x2e,
  0xa1,0xb0,0x34,0xa9,0xc1,0x3a,0xb2,0xd2,0x41,0xc4,0xd9,0x45,
  0xd6,0xe1,0x49,0xe4,0xf0,0x4e,0xf2,0xff,0x53,0xf2,0xff,0x53,
};

// ----------------------------------------------------------------------------
// Reset
// ----------------------------------------------------------------------------
void region_Reset( ) {
  if(region_type == REGION_PAL || (region_type == REGION_AUTO && cartridge_region == REGION_PAL)) {
    maria_displayArea = REGION_DISPLAY_AREA_PAL;
    maria_visibleArea = REGION_VISIBLE_AREA_PAL;
	if(palette_default)
      palette_Load(REGION_PALETTE_PAL);  // Added check for default - bberlin
    prosystem_frequency = REGION_FREQUENCY_PAL;
    prosystem_scanlines = REGION_SCANLINES_PAL;
    tia_size = 624;
    pokey_size = 624;
  }  
  else {
    maria_displayArea = REGION_DISPLAY_AREA_NTSC;
    maria_visibleArea = REGION_VISIBLE_AREA_NTSC;
	if(palette_default)
      palette_Load(REGION_PALETTE_NTSC);  // Added check for default - bberlin
    prosystem_frequency = REGION_FREQUENCY_NTSC;
    prosystem_scanlines = REGION_SCANLINES_NTSC;
    tia_size = 524;
    pokey_size = 524;
  }
}
