#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int   u32;

#include "gp2x_psp.h"
#include <time.h>

# ifndef CLK_TCK
# define CLK_TCK  CLOCKS_PER_SEC
# endif

#define CPU_CLOCK_IDLE 60
#define CPU_CLOCK_STD 200

# define THOM_RENDER_NORMAL      0
# define THOM_LAST_RENDER        0

# define MAX_PATH            256
# define THOM_MAX_SAVE_STATE    5

# define THOM_LOAD_K7_MODE      0
# define THOM_LOAD_DISK_MODE    1
# define THOM_MAX_LOAD_MODE     1

  typedef struct THOM_t {
 
    int  thom_load_mode;
    int  thom_basic_128;
    int  thom_sound_mute;
# if 0
    char thom_save_used[THOM_MAX_SAVE_STATE];
# endif
    char thom_save_name[MAX_PATH];
    char thom_home_dir[MAX_PATH];
    int  thom_speed_limiter;
    int  psp_screenshot_id;
    int  psp_cpu_clock;
    int  psp_joystick_cursor;
    int  thom_view_fps;
    int  thom_current_fps;
    int  thom_snd_enable;
    int  thom_render_mode;
    int  psp_skip_max_frame;
    int  psp_skip_cur_frame;
    int  psp_active_joystick;

  } THOM_t;

  extern THOM_t THOM;

  extern void thom_set_basic_mode(int new_mode);

//END_LUDO:

# endif
