/*
 *  Copyright (C) 2006 Ludovic Jacomme (ludovic.jacomme@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

# ifndef _KBD_H_
# define _KBD_H_

#ifdef __cplusplus
extern "C" {
#endif

# define PSP_ALL_BUTTON_MASK 0xFFFF

 enum yape_keys_emum {

    YAPEK_1,
    YAPEK_2,
    YAPEK_3,
    YAPEK_4,
    YAPEK_5,
    YAPEK_6,
    YAPEK_7,
    YAPEK_8,
    YAPEK_9,
    YAPEK_0,
    YAPEK_MINUS,
    YAPEK_PLUS,
    YAPEK_SLASH,
    YAPEK_ASTERISK,
    YAPEK_COMMA,
    YAPEK_PERIOD,
    YAPEK_AT,
    YAPEK_EXCLAMATN,
    YAPEK_DBLQUOTE,
    YAPEK_HASH,
    YAPEK_DOLLAR,
    YAPEK_PERCENT,
    YAPEK_AMPERSAND,
    YAPEK_QUOTE,
    YAPEK_LEFTPAREN,
    YAPEK_RIGHTPAREN,
    YAPEK_EQUAL,
    YAPEK_SEMICOLON,
    YAPEK_QUESTION,
    YAPEK_COLON,
    YAPEK_LESS,
    YAPEK_GREATER,
    YAPEK_SHIFT,
    YAPEK_A,
    YAPEK_B,
    YAPEK_C,
    YAPEK_D,
    YAPEK_E,
    YAPEK_F,
    YAPEK_G,
    YAPEK_H,
    YAPEK_I,
    YAPEK_J,
    YAPEK_K,
    YAPEK_L,
    YAPEK_M,
    YAPEK_N,
    YAPEK_O,
    YAPEK_P,
    YAPEK_Q,
    YAPEK_R,
    YAPEK_S,
    YAPEK_T,
    YAPEK_U,
    YAPEK_V,
    YAPEK_W,
    YAPEK_X,
    YAPEK_Y,
    YAPEK_Z,
    YAPEK_SPACE,
    YAPEK_RETURN,
    YAPEK_BACKSPACE,
    YAPEK_POUND,
    YAPEK_INSERT,
    YAPEK_CAPSLOCK,
    YAPEK_LEFT,
    YAPEK_UP,
    YAPEK_RIGHT,
    YAPEK_DOWN,
    YAPEK_ESCAPE,
    YAPEK_HOME,
    YAPEK_CLEAR,
    YAPEK_CONTROL,
    YAPEK_COMMODORE,
    YAPEK_F1,
    YAPEK_F2,
    YAPEK_F3,
    YAPEK_F4,
    YAPEK_F5,
    YAPEK_F6,
    YAPEK_F7,
    YAPEK_HELP,
    YAPEK_JOY_UP,
    YAPEK_JOY_DOWN,
    YAPEK_JOY_LEFT,
    YAPEK_JOY_RIGHT,
    YAPEK_JOY_FIRE,
    YAPEK_MAX_KEY

  };

 enum yape_keycode_emum {

    YAPE_KEY_1 = 7,
    YAPE_KEY_2 = 31,
    YAPE_KEY_3 = 1,
    YAPE_KEY_4 = 25,
    YAPE_KEY_5 = 2,
    YAPE_KEY_6 = 26,
    YAPE_KEY_7 = 3,
    YAPE_KEY_8 = 27,
    YAPE_KEY_9 = 4,
    YAPE_KEY_0 = 28,
    YAPE_KEY_MINUS = 53,
    YAPE_KEY_PLUS = 54,
    YAPE_KEY_SLASH = 62,
    YAPE_KEY_ASTERISK = 14,
    YAPE_KEY_COMMA = 61,
    YAPE_KEY_PERIOD = 37,
    YAPE_KEY_AT = 56,
    YAPE_KEY_EQUAL = 46,
    YAPE_KEY_SEMICOLON = 22,
    YAPE_KEY_COLON = 45,
    YAPE_KEY_SHIFT = 57,
    YAPE_KEY_A = 17,
    YAPE_KEY_B = 35,
    YAPE_KEY_C = 34,
    YAPE_KEY_D = 18,
    YAPE_KEY_E = 49,
    YAPE_KEY_F = 42,
    YAPE_KEY_G = 19,
    YAPE_KEY_H = 43,
    YAPE_KEY_I = 12,
    YAPE_KEY_J = 20,
    YAPE_KEY_K = 44,
    YAPE_KEY_L = 21,
    YAPE_KEY_M = 36,
    YAPE_KEY_N = 60,
    YAPE_KEY_O = 52,
    YAPE_KEY_P = 13,
    YAPE_KEY_Q = 55,
    YAPE_KEY_R = 10,
    YAPE_KEY_S = 41,
    YAPE_KEY_T = 50,
    YAPE_KEY_U = 51,
    YAPE_KEY_V = 59,
    YAPE_KEY_W = 9,
    YAPE_KEY_X = 58,
    YAPE_KEY_Y = 11,
    YAPE_KEY_Z = 33,  
    YAPE_KEY_SPACE = 39,
    YAPE_KEY_RETURN = 8,
    YAPE_KEY_BACKSPACE = 0,
    YAPE_KEY_POUND = 16,
    YAPE_KEY_INSERT = 64, /* ?? */
    YAPE_KEY_CAPSLOCK = 63, /* ?? */
    YAPE_KEY_LEFT = 6,
    YAPE_KEY_UP =   29,
    YAPE_KEY_RIGHT = 30,
    YAPE_KEY_DOWN = 5,
    YAPE_KEY_ESCAPE = 38, /* ?? */
    YAPE_KEY_HOME = 15,
    YAPE_KEY_CONTROL = 23,
    YAPE_KEY_COMMODORE = 47,
    YAPE_KEY_F1 = 32,
    YAPE_KEY_F2 = 40,
    YAPE_KEY_F3 = 48,
    YAPE_KEY_HELP = 24
  };

  enum yape_joycode_enum {
    YAPE_JOY_UP,
    YAPE_JOY_DOWN,
    YAPE_JOY_LEFT,
    YAPE_JOY_RIGHT,
    YAPE_JOY_FIRE,
  };

# define KBD_UP           0
# define KBD_RIGHT        1
# define KBD_DOWN         2
# define KBD_LEFT         3
# define KBD_TRIANGLE     4
# define KBD_CIRCLE       5
# define KBD_CROSS        6
# define KBD_SQUARE       7
# define KBD_SELECT       8
# define KBD_START        9
# define KBD_HOME        10
# define KBD_HOLD        11
# define KBD_LTRIGGER    12
# define KBD_RTRIGGER    13

# define KBD_MAX_BUTTONS 14

# define KBD_JOY_UP      14
# define KBD_JOY_RIGHT   15
# define KBD_JOY_DOWN    16
# define KBD_JOY_LEFT    17

# define KBD_ALL_BUTTONS 18

# define KBD_UNASSIGNED         -1

# define KBD_LTRIGGER_MAPPING   -2
# define KBD_RTRIGGER_MAPPING   -3
# define KBD_NORMAL_MAPPING     -1

 struct yape_key_trans {
   int  key;
   int  yape_id;
   int  shift;
   char name[10];
 };
  

  extern int psp_screenshot_mode;
  extern int psp_kbd_mapping[ KBD_ALL_BUTTONS ];
  extern int psp_kbd_mapping_L[ KBD_ALL_BUTTONS ];
  extern int psp_kbd_mapping_R[ KBD_ALL_BUTTONS ];
  extern int psp_kbd_presses[ KBD_ALL_BUTTONS ];
  extern int kbd_ltrigger_mapping_active;
  extern int kbd_rtrigger_mapping_active;

  extern struct yape_key_trans psp_yape_key_info[YAPEK_MAX_KEY];

  extern int  psp_update_keys(void);
  extern void kbd_wait_start(void);
  extern void psp_init_keyboard(void);
  extern void psp_kbd_wait_no_button(void);
  extern int  psp_kbd_is_danzeff_mode(void);
  extern void psp_kbd_display_active_mapping(void);
  extern int  psp_kbd_load_mapping(char *kbd_filename);
  extern int  psp_update_keys(void);

#ifdef __cplusplus
}
#endif

# endif
