/*
	YAPE - Yet Another Plus/4 Emulator

	The program emulates the Commodore 264 family of 8 bit microcomputers

	This program is free software, you are welcome to distribute it,
	and/or modify it under certain conditions. For more information,
	read 'Copying'.

	(c) 2000, 2001 Attila Grsz
*/

#include "keyboard.h"
#include <string.h>

#include "global.h"

/*
 Values		: C16 keyboard matrix positions
 Positions	: SDL key scan codes
 Eg. C16 has the "return" at matrix postition 8
	 SDL has it at position 13 (0x0D), ie. the 13. position has the value 8
*/

# if 0 //LUDO:
unsigned char sdltrans[512]=
	{
//      0
	  255,255, 255, 255  ,255 ,255 ,255, 255,  0,  63, 255,  255, 255, 8, 255, 255, // 15
      255, 29,   5,  30  ,  6 ,255 ,255, 255,  255, 255, 255,  255, 255, 255, 255, 255, // 31
       39,255, 255, 255  ,255 ,255 ,255, 22,  255, 255, 255,  255,  61,  62,  37,  56, // 47
       28,  7,  31, 1    , 25 ,  2 , 26,   3,   27,   4, 255,  45, 255,  46, 255, 255,
//      64
      255,255, 255, 255  ,255 ,255  ,255, 255,  255, 255, 255,  255, 255, 255, 255, 255,
      255,255, 255, 255  ,255 ,255  ,255, 255,  255, 255, 255,   54,  14,  53, 255, 255, // 95
       38, 17,  35,  34  , 18 , 49  , 42,  19,  43,  12,  20,    44,   21,  36,  60,  52, // 111
       13, 55,  10,  41  , 50 , 51  , 59,   9,   58, 11,  33,   255,  255, 255, 255, 255,
//      128
     };
const unsigned int joystick[5]={
	273,275,274,276,305 }; // PC keycodes up, right, down, left and fire
const unsigned int origkeys[5]={
	29, 30, 5, 6, 23};

# endif

# if 0
const unsigned int joykeys[2][5]=
	{ {2, 26, 10, 18, 50 }, // keys for joystick 1 and 2 up, right, down, left and fire
	{1, 25, 9, 17, 57 } };
# else
const unsigned int joykeys[2][5]=
	{ {2, 10, 18, 26, 50 }, // keys for joystick 1 and 2 up, right, down, left and fire
	  {1,  9, 17, 25, 57 } };
# endif

//--------------------------------------------------------------

KEYS::KEYS() {
	empty();
}

void KEYS::empty(void)
{
	memset(keybuffer,0,256);
	memset(joybuffer,0,256);
}

void KEYS::pushkey(unsigned int code)
{
	*(keybuffer+code)=0x80;
}

void KEYS::releasekey(unsigned int code)
{
	*(keybuffer+code)=0x0;
}

void KEYS::releasejoy(unsigned int code)
{
  if (code < 5) {
	  *(joybuffer+joykeys[YAPE.psp_active_joystick][code])=0;
  }
}

void KEYS::pushjoy(unsigned int code)
{
  if (code < 5) {
	  *(joybuffer+joykeys[YAPE.psp_active_joystick][code])=0x80;
  }
}

unsigned char KEYS::key_trans(unsigned char r)
{
	return ~((keybuffer[r]>>7)|(keybuffer[r+8]>>6)|(keybuffer[r+16]>>5)|(keybuffer[r+24]>>4)|(keybuffer[r+32]>>3)|(keybuffer[r+40]>>2)|(keybuffer[r+48]>>1)|(keybuffer[r+56]>>0));
}

unsigned char KEYS::feedkey(unsigned char latch)
{
	static unsigned char tmp;

	tmp=0xFF;

	if ((latch&0x01)==0) tmp&=key_trans(0);
	if ((latch&0x02)==0) tmp&=key_trans(1);
	if ((latch&0x04)==0) tmp&=key_trans(2);
	if ((latch&0x08)==0) tmp&=key_trans(3);
	if ((latch&0x10)==0) tmp&=key_trans(4);
	if ((latch&0x20)==0) tmp&=key_trans(5);
	if ((latch&0x40)==0) tmp&=key_trans(6);
	if ((latch&0x80)==0) tmp&=key_trans(7);

	return tmp;
}

unsigned char KEYS::joy_trans(unsigned char r)
{
	return ~((joybuffer[r]>>7)|(joybuffer[r+8]>>6)|(joybuffer[r+16]>>5)|(joybuffer[r+24]>>4)|(joybuffer[r+32]>>3)|(joybuffer[r+40]>>2)|(joybuffer[r+48]>>1)|(joybuffer[r+56]>>0));
}

unsigned char KEYS::feedjoy(unsigned char latch)
{
	static unsigned char tmp;

	tmp=0xFF;

	if ((latch&0x01)==0)
		tmp&=joy_trans(2);
	if ((latch&0x02)==0)
		tmp&=joy_trans(1);
	if ((latch&0x04)==0)
		tmp&=joy_trans(2); // Joy2 is wired two times...

	return tmp;
}

void KEYS::joyinit(void)
{
}

KEYS::~KEYS() {

}




