#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#ifdef __cplusplus
extern "C" {
#endif

# define YAPE_RENDER_NORMAL      0
# define YAPE_RENDER_X125        1
# define YAPE_RENDER_X15         2
# define YAPE_RENDER_FIT         3
# define YAPE_LAST_RENDER        3

# define MAX_PATH            256
# define YAPE_MAX_SAVE_STATE    5

  typedef struct YAPE_t {
 
    char yape_save_used[YAPE_MAX_SAVE_STATE];
    char yape_save_name[MAX_PATH];
    char yape_home_dir[MAX_PATH];
    int  yape_speed_limiter;
    int  psp_screenshot_id;
    int  psp_cpu_clock;
    int  psp_reverse_analog;
    int  yape_snd_enable;
    int  yape_render_mode;
    int  yape_render_smooth;
    int  psp_skip_max_frame;
    int  psp_skip_cur_frame;
    int  psp_active_joystick;

  } YAPE_t;

  extern YAPE_t YAPE;

  extern int  yape_prg_to_load;
  extern char yape_prg_to_load_filename[MAX_PATH];
  extern int  yape_prg_to_load_zip;
  extern int yape_load_prg();

  extern void yape_initialize();


//END_LUDO:
#ifdef __cplusplus
}
#endif

# endif
