/*
 *  Copyright (C) 2006 Ludovic Jacomme (ludovic.jacomme@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <fcntl.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_ttf.h>

#include <pspctrl.h>
#include <pspkernel.h>
#include <pspdebug.h>
#include <pspiofilemgr.h>

#include "global.h"
#include "psp_sdl.h"
#include "psp_kbd.h"
#include "psp_menu.h"
#include "psp_fmgr.h"
#include "psp_run.h"
#include "psp_menu_kbd.h"
#include "psp_menu_set.h"
#include "psp_battery.h"
#include "psp_menu_help.h"
#include "psp_irkeyb.h"

extern SDL_Surface *back_surface;
static int psp_menu_dirty = 1;

# define MENU_SCREENSHOT   0
# define MENU_REWIND_K7    1

# if 0  //LUDO: TO_BE_DONE ?
# define MENU_LOAD_SLOT    1
# define MENU_SAVE_SLOT    2
# define MENU_DEL_SLOT     3
# endif
# define MENU_HELP         2

# define MENU_LOAD_K7      3

# define MENU_LOAD_DISK0   4
# define MENU_LOAD_DISK1   5

# define MENU_CMD_LOADM    6
# define MENU_CMD_LOAD     7
# define MENU_CMD_RUN      8

# define MENU_KEYBOARD     9
# define MENU_SETTINGS     10

# define MENU_SOFT_RESET   11
# define MENU_COLD_RESET   12
# define MENU_BACK         13
# define MENU_EXIT         14

# define MAX_MENU_ITEM (MENU_EXIT + 1)

  static menu_item_t menu_list[] =
  { 
    "Save Screenshot :",
    "Rewind K7       :",

    "Help",

# if 0 //LUDO: TO_BE_DONE
    "Load Slot",
    "Save Slot",
    "Delete Slot",
# endif

    "Load K7",

    "Load Disk 0",
    "Load Disk 1",

    "Command LOADM",
    "Command LOAD",
    "Command RUN",

    "Keyboard", 
    "Settings",

    "Soft Reset",
    "Cold Reset",

    "Back to TO7-70",
    "Exit"
  };

  static int cur_menu_id = MENU_LOAD_K7;
  static int cur_slot    = 0;

void 
psp_menu_display_save_name()
{
  char buffer[128];
  int Length;

  snprintf(buffer, 20, "Game: %s", THOM.thom_save_name);
  Length = strlen(buffer);
  psp_sdl_back2_print(460 - (8*Length), 25, buffer, PSP_MENU_TEXT2_COLOR);
}

void
string_fill_with_space(char *buffer, int size)
{
  int length = strlen(buffer);
  int index;

  for (index = length; index < size; index++) {
    buffer[index] = ' ';
  }
  buffer[size] = 0;
}

void
psp_display_screen_menu_battery(void)
{
  char buffer[64];

  int Length;
  int color;

  snprintf(buffer, 50, " [%s] ", psp_get_battery_string());
  Length = strlen(buffer);

  if (psp_is_low_battery()) color = PSP_MENU_RED_COLOR;
  else                      color = PSP_MENU_GREEN_COLOR;

  psp_sdl_back2_print(240 - ((8*Length) / 2), 6, buffer, color);
}

static void 
psp_display_screen_menu(void)
{
  char buffer[64];
  int menu_id = 0;
  int slot_id = 0;
  int color   = 0;
  int x       = 0;
  int y       = 0;
  int y_step  = 0;

  //if (psp_menu_dirty) 
  {
    psp_sdl_blit_background();
    psp_menu_dirty = 0;

    psp_sdl_draw_rectangle(10,10,459,249,PSP_MENU_BORDER_COLOR,0);
    psp_sdl_draw_rectangle(11,11,457,247,PSP_MENU_BORDER_COLOR,0);

    psp_sdl_back2_print( 30, 6, " Start+L+R: EXIT ", PSP_MENU_WARNING_COLOR);

    psp_display_screen_menu_battery();

    psp_sdl_back2_print( 370, 6, " R: RESET ", PSP_MENU_NOTE_COLOR);

    psp_sdl_back2_print(30, 254, " []: Cancel  O/X: Valid  SELECT: Back ", 
                       PSP_MENU_BORDER_COLOR);

    psp_sdl_back2_print(370, 254, " By Zx-81 ",
                       PSP_MENU_AUTHOR_COLOR);
  }
  
  x      = 20;
  y      = 25;
  y_step = 10;
  
  for (menu_id = 0; menu_id < MAX_MENU_ITEM; menu_id++) {
    color = PSP_MENU_TEXT_COLOR;
    if (cur_menu_id == menu_id) color = PSP_MENU_SEL_COLOR;
    else 
    if (menu_id == MENU_EXIT) color = PSP_MENU_WARNING_COLOR;
    else
    if (menu_id == MENU_HELP) color = PSP_MENU_GREEN_COLOR;

    psp_sdl_back2_print(x, y, menu_list[menu_id].title, color);

    if (menu_id == MENU_SCREENSHOT) {
      sprintf(buffer,"%d", THOM.psp_screenshot_id);
      string_fill_with_space(buffer, 4);
      psp_sdl_back2_print(160, y, buffer, color);
    } else
    if (menu_id == MENU_REWIND_K7) {
      sprintf(buffer,"%d", to7_GetK7Counter());
      string_fill_with_space(buffer, 6);
      psp_sdl_back2_print(160, y, buffer, color);
      y += y_step;
    } else
# if 0 //LUDO: TO_BE_DONE
    if (menu_id == MENU_DEL_SLOT) {
      y += 2 * y_step;
    } else
# endif
    if (menu_id == MENU_CMD_RUN) {
      y += y_step;
    } else
    if (menu_id == MENU_LOAD_DISK1) {
      y += y_step;
    } else
    if (menu_id == MENU_SETTINGS) {
      y += y_step;
    } else
    if (menu_id == MENU_COLD_RESET) {
      y += y_step;
    } else
    if (menu_id == MENU_BACK) {
      y += y_step;
    } else
    if (menu_id == MENU_HELP) {
      y += y_step;
    }

    y += y_step;
  }
# if 0 //LUDO: TO_BE_DONE 
  y_step = 10;
  y      = 45;

  for (slot_id = 0; slot_id < THOM_MAX_SAVE_STATE; slot_id++) {
    if (slot_id == cur_slot) color = PSP_MENU_SEL2_COLOR;
    else                     color = PSP_MENU_TEXT_COLOR;

    if (THOM.thom_save_used[slot_id]) sprintf(buffer, "%d - used" , slot_id + 1);
    else                            sprintf(buffer, "%d - empty", slot_id + 1);
    string_fill_with_space(buffer, 10);
    psp_sdl_back2_print(150, y, buffer, color);

    y += y_step;
  }
# endif

  psp_menu_display_save_name();
}

static void
psp_main_menu_cold_reset(void)
{
  /* Reset ! */
  psp_display_screen_menu();
  psp_sdl_back2_print(270,  80, "Cold Reset TO7-70 !", 
                     PSP_MENU_WARNING_COLOR);
  psp_menu_dirty = 1;
  psp_sdl_flip();
  emulator_cold_reset();
  sleep(1);
}

static void
psp_main_menu_soft_reset(void)
{
  /* Reset ! */
  psp_display_screen_menu();
  psp_sdl_back2_print(270,  80, "Soft Reset TO7-70 !", 
                     PSP_MENU_WARNING_COLOR);
  psp_menu_dirty = 1;
  psp_sdl_flip();
  emulator_soft_reset();
  sleep(1);
}

static void
psp_main_menu_cmd_loadm(void)
{
  char *RunName;
  RunName = psp_run_search(THOM.thom_save_name);
  if (RunName != (char *)0 ) {
    psp_kbd_run_command(RunName);
  } else
  if ((THOM.thom_load_mode == THOM_LOAD_DISK_MODE) ||
      (THOM.thom_basic_128 == 0                  )) {
    psp_kbd_run_command("LOADM\"\",,R\n");
  } else {
    psp_kbd_run_command("LOADM\"CASS:\",,R\n");
  }
}

static void
psp_main_menu_cmd_load(void)
{
  char *RunName;
  RunName = psp_run_search(THOM.thom_save_name);
  if (RunName != (char *)0 ) {
    psp_kbd_run_command(RunName);
  } else
  if ((THOM.thom_load_mode == THOM_LOAD_DISK_MODE) ||
      (THOM.thom_basic_128 == 0                  )) {
    psp_kbd_run_command("LOAD\"\",,R\n");
  } else {
    psp_kbd_run_command("LOAD\"CASS:\",,R\n");
  }
}

static void
psp_main_menu_cmd_rum(void)
{
  char *RunName;
  RunName = psp_run_search(THOM.thom_save_name);
  if (RunName != (char *)0 ) {
    psp_kbd_run_command(RunName);
  } else
  if ((THOM.thom_load_mode == THOM_LOAD_DISK_MODE) ||
      (THOM.thom_basic_128 == 0                  )) {
    psp_kbd_run_command("RUN\"\"\n");
  } else {
    psp_kbd_run_command("RUN\"CASS:\"\n");
  }
}

static void
psp_main_menu_load(int format, int disk_id)
{
  int ret;

  ret = psp_fmgr_menu(format, disk_id);
  if (ret ==  1) /* load OK */
  {
    psp_menu_dirty = 1;
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "File loaded !", 
                       PSP_MENU_NOTE_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
  else 
  if (ret == -1) /* Load Error */
  {
    psp_menu_dirty = 1;
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "Can't load file !", 
                       PSP_MENU_WARNING_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
}

# if 0
static void
psp_main_menu_load_slot()
{
  int error;

  if (! THOM.thom_save_used[cur_slot]) {

    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "Slot is empty !", 
                       PSP_MENU_NOTE_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);

    return;
  }

  error = thom_snapshot_load_slot(cur_slot);

  if (! error) /* save OK */
  {
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "File loaded !", 
                       PSP_MENU_NOTE_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
  else 
  {
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "Can't load file !", 
                       PSP_MENU_WARNING_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
}

static void
psp_main_menu_save_slot()
{
  int error;
  error = thom_snapshot_save_slot(cur_slot);

  if (! error) /* save OK */
  {
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "File saved !", 
                       PSP_MENU_NOTE_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
  else 
  {
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "Can't save file !", 
                       PSP_MENU_WARNING_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
}

static void
psp_main_menu_del_slot()
{
  int error;

  if (! THOM.thom_save_used[cur_slot]) {

    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "Slot is empty !", 
                       PSP_MENU_NOTE_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);

    return;
  }

  error = thom_snapshot_del_slot(cur_slot);

  if (! error) /* save OK */
  {
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "File deleted !", 
                       PSP_MENU_NOTE_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
  else 
  {
    psp_display_screen_menu();
    psp_sdl_back2_print(270,  80, "Can't delete file !", 
                       PSP_MENU_WARNING_COLOR);
    psp_menu_dirty = 1;
    psp_sdl_flip();
    sleep(1);
  }
}
# endif

static void
psp_main_menu_rewind_k7()
{
  int error;

  error = thom_rewind_k7();

  psp_display_screen_menu();
  psp_sdl_back2_print(270,  80, "K7 rewinded !", 
                     PSP_MENU_NOTE_COLOR);
  psp_sdl_flip();
  sleep(1);
}

static void
psp_main_menu_cur_slot(int step)
{
  if (step == 1) {
    cur_slot++; if (cur_slot >= THOM_MAX_SAVE_STATE) cur_slot = 0;
  } else if (step == -1) {
    cur_slot--; if (cur_slot < 0) cur_slot = THOM_MAX_SAVE_STATE - 1;
  }
}

static void
psp_main_menu_screenshot(void)
{
  psp_screenshot_mode = 10;
}

int
psp_main_menu_exit(void)
{
  SceCtrlData c;

  psp_display_screen_menu();
  psp_sdl_back2_print(270,  80, "press X to confirm !", PSP_MENU_WARNING_COLOR);
  psp_menu_dirty = 1;
  psp_sdl_flip();

  psp_kbd_wait_no_button();

  do
  {
    sceCtrlReadBufferPositive(&c, 1);
    c.Buttons &= PSP_ALL_BUTTON_MASK;

    if (c.Buttons & PSP_CTRL_CROSS) psp_sdl_exit(0);

  } while (c.Buttons == 0);

  psp_kbd_wait_no_button();

  return 0;
}



int 
psp_main_menu(void)
{
  SceCtrlData c;
  long        new_pad;
  long        old_pad;
  int         last_time;
  int         end_menu;

  thom_audio_pause();

  psp_kbd_wait_no_button();

  old_pad   = 0;
  last_time = 0;
  end_menu  = 0;

  psp_menu_dirty = 1;

  while (! end_menu)
  {
    psp_display_screen_menu();
    psp_sdl_flip();

    while (1)
    {
      sceCtrlReadBufferPositive(&c, 1);
      c.Buttons &= PSP_ALL_BUTTON_MASK;

# ifdef USE_PSP_IRKEYB
      psp_irkeyb_set_psp_key(&c);
# endif
      if (c.Buttons) break;
    }

    new_pad = c.Buttons;

    if ((old_pad != new_pad) || ((c.TimeStamp - last_time) > PSP_MENU_MIN_TIME)) {
      last_time = c.TimeStamp;
      old_pad = new_pad;

    } else continue;

    if ((c.Buttons & (PSP_CTRL_LTRIGGER|PSP_CTRL_RTRIGGER|PSP_CTRL_START)) ==
        (PSP_CTRL_LTRIGGER|PSP_CTRL_RTRIGGER|PSP_CTRL_START)) {
      /* Exit ! */
      psp_sdl_exit(0);
    } else
    if ((c.Buttons & PSP_CTRL_RTRIGGER) == PSP_CTRL_RTRIGGER) {
      psp_main_menu_soft_reset();
      end_menu = 1;
    } else
    if ((new_pad & PSP_CTRL_CROSS ) || 
        (new_pad & PSP_CTRL_CIRCLE) || 
        (new_pad & PSP_CTRL_RIGHT ) ||
        (new_pad & PSP_CTRL_LEFT  )) 
    {
      int step;

      if (new_pad & PSP_CTRL_LEFT)  step = -1;
      else 
      if (new_pad & PSP_CTRL_RIGHT) step =  1;
      else                          step =  0;

      switch (cur_menu_id ) 
      {
# if 0 //LUDO: TO_BE_DONE
        case MENU_LOAD_SLOT : if (step) psp_main_menu_cur_slot(step);
                              else      psp_main_menu_load_slot();
        break;
        case MENU_SAVE_SLOT : if (step) psp_main_menu_cur_slot(step);
                              else      psp_main_menu_save_slot();
        break;
        case MENU_DEL_SLOT  : if (step) psp_main_menu_cur_slot(step);
                              else      psp_main_menu_del_slot();
        break;
# endif

        case MENU_LOAD_K7    : psp_menu_dirty = 1;
                               psp_main_menu_load(FMGR_FORMAT_K7, 0);
                               old_pad = new_pad = 0;
                               psp_menu_dirty = 1;
        break;              

        case MENU_LOAD_DISK0 : psp_menu_dirty = 1;
                               psp_main_menu_load(FMGR_FORMAT_SAP, 0);
                               old_pad = new_pad = 0;
                               psp_menu_dirty = 1;
        break;              
        case MENU_LOAD_DISK1 : psp_menu_dirty = 1;
                               psp_main_menu_load(FMGR_FORMAT_SAP, 1);
                               old_pad = new_pad = 0;
                               psp_menu_dirty = 1;
        break;              

        case MENU_CMD_LOADM  : psp_main_menu_cmd_loadm();
                               end_menu = 1;
        break;
        case MENU_CMD_LOAD   : psp_main_menu_cmd_load();
                               end_menu = 1;
        break;
        case MENU_CMD_RUN    : psp_main_menu_cmd_rum();
                               end_menu = 1;
        break;

        case MENU_KEYBOARD   : psp_keyboard_menu();
                               psp_menu_dirty = 1;
                               old_pad = new_pad = 0;
        break;

        case MENU_SETTINGS   : psp_menu_dirty = 1;
                               psp_settings_menu();
                               psp_menu_dirty = 1;
                               old_pad = new_pad = 0;
        break;

        case MENU_REWIND_K7  : psp_main_menu_rewind_k7();
                               psp_menu_dirty = 1;
                               old_pad = new_pad = 0;
        break;
        case MENU_SCREENSHOT : psp_main_menu_screenshot();
                               end_menu = 1;
        break;              
        case MENU_SOFT_RESET : psp_main_menu_soft_reset();
                               end_menu = 1;
        break;
        case MENU_COLD_RESET : psp_main_menu_cold_reset();
                               end_menu = 1;
        break;

        case MENU_BACK      : end_menu = 1;
        break;

        case MENU_EXIT      : psp_main_menu_exit();
        break;

        case MENU_HELP      : psp_menu_dirty = 1;
                              psp_help_menu();
                              old_pad = new_pad = 0;
                              psp_menu_dirty = 1;
        break;              
      }

    } else
    if(new_pad & PSP_CTRL_UP) {

      if (cur_menu_id > 0) cur_menu_id--;
      else                 cur_menu_id = MAX_MENU_ITEM-1;

    } else
    if(new_pad & PSP_CTRL_DOWN) {

      if (cur_menu_id < (MAX_MENU_ITEM-1)) cur_menu_id++;
      else                                 cur_menu_id = 0;

    } else  
    if(new_pad & PSP_CTRL_SQUARE) {
      /* Cancel */
      end_menu = -1;
    } else 
    if(new_pad & PSP_CTRL_SELECT) {
      /* Back to THOM */
      end_menu = 1;
    }
  }
 
  psp_kbd_wait_no_button();

  psp_sdl_clear_screen( PSP_MENU_BLACK_COLOR );
  psp_sdl_flip();
  psp_sdl_clear_screen( PSP_MENU_BLACK_COLOR );
  psp_sdl_flip();

  psp_sdl_clear_blit();

  thom_audio_resume();

  return 1;
}

