/***********************************************************************************
 **
 ** Atari++ emulator (c) 2002 THOR-Software, Thomas Richter
 **
 ** $Id: gadget.cpp,v 1.2 2005/09/10 12:55:40 thor Exp $
 **
 ** In this module: Abstract base class for all gadgets used in the GUI
 **********************************************************************************/

/// Includes
#include "gadget.hpp"
///

/// Gadget::Gadget
// Construct a gadget and add it to a list of gadgets
// A gadget per se is nothing. This class must be derived to be
// worth something.
Gadget::Gadget(List<Gadget> &gadgetlist,
		     class RenderPort *rp,LONG le,LONG te,LONG w,LONG h)
  : RPort(rp), LeftEdge(le), TopEdge(te), Width(w), Height(h), Active(false),
    UserPtr(NULL)
{
  gadgetlist.AddTail(this);
}
///

/// Gadget::~Gadget
// Remove a gadget from the gadget list, then dispose it.
Gadget::~Gadget(void)
{
  Remove();
}
///

/// Gadget::Within
// Check whether a given position lies within the gadget.
bool Gadget::Within(const struct Event &ev)
{
  if (ev.X >= LeftEdge         && ev.Y >= TopEdge &&
      ev.X <  LeftEdge + Width && ev.Y <  TopEdge + Height) {
    if (ev.X < RPort->WidthOf() && ev.Y < RPort->HeightOf()) {
      return true;
    }
  }
  return false;
}
///
