/***********************************************************************************
 **
 ** Atari++ emulator (c) 2002 THOR-Software, Thomas Richter
 **
 ** $Id: instruction.hpp,v 1.1 2007/04/20 20:01:41 thor Exp $
 **
 ** In this module: Definition of the instruction primitive for the disassembler
 ** This table is generated by the CPU, and used by the disassembler.
 **********************************************************************************/

#ifndef INSTRUCTION_HPP
#define INSTRUCTION_HPP

/// Includes
#include "types.hpp"
///

/// Struct Instruction
// This helper structure is used to identify the instructions to disassemble.
// This is 
struct Instruction {
  const char *Name;   // name of the game
  //
  enum OperandType {
    NoArgs,              // doesn't take arguments
    Immediate,           // #immed
    Accu,                // address the A register
    ZPage,               // zero page without offset
    ZPage_X,             // zero page with X offset
    ZPage_Y,             // zero page with Y offset
    Indirect,            // indirect without index
    Indirect_X,          // zpage indirect preindexed with X
    Indirect_Y,          // zpage indirect postindexed with Y
    Indirect_Z,          // zpage indirect not indexed (65C02)
    Absolute,            // absolute without index
    Absolute_X,          // absolute with X offset
    Absolute_Y,          // absolute with Y offset
    AbsIndirect_X,       // indirect 16 bit with X index (65C02)
    Disp,                // 8 bit branch displacement
    ZPage_Disp           // for BBRx and BBSx: Zero page and branch displacement
  }    AddressingMode;
  //
  // Number of cycles this instruction takes.
  UBYTE Cycles;
  //
  // Construct me.
  // For building an instruction array, a default constructor
  // must be available.
  Instruction(void)
    : Name("????"), AddressingMode(NoArgs), Cycles(0)
  {
  }
  //
  // Create by name and operand type.
  Instruction(const char *name,OperandType type,UBYTE cycles)
    : Name(name), AddressingMode(type), Cycles(cycles)
  { }
};
///

///
#endif
