/***********************************************************************************
 **
 ** Atari++ emulator (c) 2002 THOR-Software, Thomas Richter
 **
 ** $Id: event.cpp,v 1.5 2005/09/10 12:55:40 thor Exp $
 **
 ** In this module: Definition of GUI events
 **********************************************************************************/

/// Includes
#include "event.hpp"
#include "gadget.hpp"
#include "display.hpp"
#include "keyboard.hpp"
///

/// EventFeeder::ForwardEvent
// Forward an event to all gadget that are part of the list maintained by
// this event feeder
int EventFeeder::ForwardEvent(struct Event &ev)
{
  class Gadget *gadget;
  int change = Nothing;
  struct Event sent;
  //
  do {
    sent = ev;
    for(gadget  = GList->First();gadget;gadget = gadget->NextOf()) {
      if (gadget->HitTest(sent)) {
	// Check whether we got a control event. If so, then we set the
	// action ID of the main menu.
	if (sent.Type == Event::Ctrl) {
	  change = sent.ControlId;
	  // Store changes back so the outside sees what we did with the event
	  ev     = sent;
	  break;
	}
      }
    }
  } while(sent.Resent);

  return change;
}
///

/// EventFeeder::PickedOption
// Create events and feed them into the gadgets. Returns true if any option
// changed. In this case, we would need to re-parse the parameters.
int EventFeeder::PickedOption(struct Event &event)
{ 
  LONG x,y;
  bool button;
  int change = Nothing;
  int ctrl;
  //
  // This main loop seems indeed strange and is not at all "event driven"
  // in the classical sense. The problem here is, though, that the display
  // frontend is so utterly primitive that we cannot depend on any kind of
  // events it may or may not generate. Hence, we need to use a "polling
  // type" front end here.
  //
  // Update the GUI by reading the keyboard event.
  event.DownUp      = Keyboard->ReadKey(event.Key,event.Shift,event.Control);
  // Eat up this event.
  Keyboard->KeyboardInterrupt();
  if (event.DownUp != LastDownUp || event.Key != LastKey) {
    change          = Comeback;
    AutoCounter     = 15;
    LastDownUp      = event.DownUp;
    LastKey         = event.Key;
    event.Type      = Event::Keyboard;
    if ((ctrl = ForwardEvent(event)))
	change      = ctrl;
  } else if (event.DownUp) {
    // Check whether the auto repeat counter is done.
    if (--AutoCounter <= 0) {
      // repeat the down event.
      AutoCounter     = 2;
      event.Type      = Event::Keyboard;
      if ((ctrl = ForwardEvent(event)))
	change        = ctrl;
    }
  }
  //
  if (change == Nothing) {
    LONG lines = Display->ScrollDistance();
    if (lines != 0) { 
      Display->MousePosition(x,y,button);
      // Ok, generate an event for the mouse wheel.
      event.Type          = Event::Wheel;
      event.ScrolledLines = lines; 
      event.Button        = button;
      event.X             = x;
      event.Y             = y;
      if ((ctrl = ForwardEvent(event)))
	change  = ctrl;
    }
  }
  //
  //
  if (change == Nothing) {
    // Update the GUI by reading the mouse position from it.
    Display->MousePosition(x,y,button);
    // Construct an event from the mouse position and the button position.
    event.Type   = Event::Mouse;
    if (button  != LastButton) {
      if (x >= 0 && y >= 0 && x < RPort->WidthOf() && y < RPort->HeightOf()) {
	event.Type = Event::Click;
      } else {
	// Ignore button presses outside the window.
	return change;
      }
    }
    event.Button = button;
    event.X      = x;
    event.Y      = y;
    if ((ctrl = ForwardEvent(event)))
      change     = ctrl;
    LastButton   = button;
  }
  
  return change;
}
///
