/*
 *  xtiger port on PSP 
 *
 *  Copyright (C) 2006 Ludovic Jacomme (ludovic.jacomme@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <fcntl.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pspctrl.h>
#include <pspkernel.h>
#include <pspdebug.h>
#include <pspiofilemgr.h>

#include "global.h"

  TI92_t TI92;
  int    psp_screenshot_mode = 0;

int
ti92_save_configuration(void)
{
  char  chFileName[MAX_PATH + 1];
  FILE* FileDesc;
  int   error = 0;

  strncpy(chFileName, TI92.psp_home_path, sizeof(chFileName)-10);
  strcat(chFileName, "/pspxti.cfg");

  FileDesc = fopen(chFileName, "w");
  if (FileDesc != (FILE *)0 ) {

    fprintf(FileDesc, "psp_cpu_clock=%d\n"     , TI92.psp_cpu_clock);
    fprintf(FileDesc, "psp_display_lr=%d\n"    , TI92.psp_display_lr);
    fprintf(FileDesc, "psp_reverse_analog=%d\n", TI92.psp_reverse_analog);
    fclose(FileDesc);

  } else {
    error = 1;
  }

  return error;
}

int
ti92_parse_configuration(void)
{
  char  chFileName[MAX_PATH + 1];
  char  Buffer[512];
  char *Scan;
  unsigned int Value;
  FILE* FileDesc;

  strncpy(chFileName, TI92.psp_home_path, sizeof(chFileName)-10);
  strcat(chFileName, "/pspxti.cfg");

  FileDesc = fopen(chFileName, "r");
  if (FileDesc == (FILE *)0 ) return 0;

  while (fgets(Buffer,512, FileDesc) != (char *)0) {

    Scan = strchr(Buffer,'\n');
    if (Scan) *Scan = '\0';
    /* For this #@$% of windows ! */
    Scan = strchr(Buffer,'\r');
    if (Scan) *Scan = '\0';
    if (Buffer[0] == '#') continue;

    Scan = strchr(Buffer,'=');
    if (! Scan) continue;

    *Scan = '\0';
    Value = atoi(Scan+1);

    if (!strcasecmp(Buffer,"psp_cpu_clock"))      TI92.psp_cpu_clock = Value;
    else
    if (!strcasecmp(Buffer,"psp_display_lr"))     TI92.psp_display_lr = Value;
    else
    if (!strcasecmp(Buffer,"psp_reverse_analog")) TI92.psp_reverse_analog = Value;
  }

  fclose(FileDesc);

  return 0;
}


void
ti92_init_resource()
{
  getcwd(TI92.psp_home_path, sizeof(TI92.psp_home_path));
  strcpy(TI92.psp_screenshot_path, TI92.psp_home_path);
  strcat(TI92.psp_screenshot_path, "/scr");

  TI92.psp_screenshot_id  = 0;
  TI92.psp_cpu_clock      = 222;
  TI92.psp_reverse_analog = 0;
  TI92.psp_display_lr     = 0;
  ti92_parse_configuration();
  scePowerSetClockFrequency(TI92.psp_cpu_clock, TI92.psp_cpu_clock, TI92.psp_cpu_clock/2);
}

void
ti92_kbd_load(void)
{
  char        TmpFileName[MAX_PATH + 1];
  struct stat aStat;

  snprintf(TmpFileName, MAX_PATH, "%s/default.kbd", TI92.psp_home_path);
  if (! stat(TmpFileName, &aStat)) {
    psp_kbd_load_mapping(TmpFileName);
  }
}

int
ti92_kbd_save(void)
{
  char TmpFileName[MAX_PATH + 1];
  snprintf(TmpFileName, MAX_PATH, "%s/default.kbd", TI92.psp_home_path);
  return( psp_kbd_save_mapping(TmpFileName) );
}


