/*
 *  xtiger port on PSP 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <SDL/SDL.h>

#include "sysdeps.h"
#include "config.h"
#include "options.h"
#include "newcpu.h"
#include "keyboard.h"
#include "specific.h"
#include "debug.h"
#include "global.h"
#include "globinfo.h"

# include "psp_kbd.h"
# include "psp_sdl.h"
# include "psp_specific.h"

/* Colors */


#define ESTAT_SCREENON 1
#define ESTAT_LINKON 2
#define ESTAT_CMDS 8

int contrast = 16;
/* Planar->Chunky conversion table */
int convtab[512];

ULONG *screenBuf = NULL;
int grayPlanes = 2;
int currPlane = 0;
/* Pointer to TI92 planar screen */

unsigned char *the_screen = NULL;

int emuState = 0;


void 
update_progbar(int size) 
{
}

void 
link_progress(int type, char *name, int size) 
{
}

int 
init_specific(void) 
{
  int i,j,k;
  unsigned char *tmptab = (unsigned char *)convtab;

  for(k = 0, i = 0; i<256; i++) {
    for(j = 7; j>=0; j--)
      if((i>>j)&1) tmptab[k++] = 1;
      else         tmptab[k++] = 0;
  }

  psp_init_keyboard();

  screenBuf=(ULONG*)malloc(TI92_WIDTH * TI92_HEIGHT);

  return(1);
}

#define filter(v, l, h) (v<l ? l : (v>h ? h : v))

int lastc = 0;

void 
set_contrast(int c) 
{
}

void 
screen_on(void) 
{
  emuState |= ESTAT_SCREENON;
}

void 
screen_off(void) 
{
  emuState &= ~ESTAT_SCREENON;
}

void CloseTigerWin(void)
{
# if 0
  ggiClose(v);
# endif
}

/** PutImage *************************************************/
/** Put an image on the screen.                             **/
/*************************************************************/

#define LINESIZE  512        //in short

#define PSP_LCD_BACKGROUND psp_sdl_rgb(181, 211, 242)
#define PSP_LCD_FOREGROUND psp_sdl_rgb(0x0, 0x0, 0x0)

static int loc_lcd_background = 0;
static int loc_lcd_foreground = 0;

static void
loc_PutImage_max()
{
  int x;
  int y;
  int color;
  char *scan_buf = (char *)screenBuf;
  u16 *vram = NULL;
  u16 *scan_vram = NULL;

  vram = (u16 *)psp_sdl_get_vram_addr(0, 8);
  scan_vram = vram;
  for (y = 0; y < TI92_HEIGHT; y++) {
    for (x = 0; x < TI92_WIDTH; x++) {
      if (scan_buf[x]) color = loc_lcd_foreground;
      else             color = loc_lcd_background;
      scan_vram[(x<<1)  ] = color;
      scan_vram[(x<<1)+1] = color;
      scan_vram[PSP_LINE_SIZE+(x<<1)  ] = color;
      scan_vram[PSP_LINE_SIZE+(x<<1)+1] = color;
    }
    scan_vram += (PSP_LINE_SIZE <<1);
    scan_buf  += TI92_WIDTH;
  }
}

static void
loc_PutImage_normal()
{
  int x;
  int y;
  int color;
  char *scan_buf = (char *)screenBuf;
  u16 *vram = NULL;
  u16 *scan_vram = NULL;

  vram = (u16 *)psp_sdl_get_vram_addr(40, 56);
  scan_vram = vram;
  for (y = 0; y < TI92_HEIGHT; y++) {
    for (x = 0; x < TI92_WIDTH; x++) {
      if (scan_buf[x]) color = loc_lcd_foreground;
      else             color = loc_lcd_background;
      scan_vram[x] = color;
    }
    scan_vram += PSP_LINE_SIZE;
    scan_buf  += TI92_WIDTH;
  }
}

static void 
loc_PutImage(void)
{
  static first = 1;

  if (first) {
    loc_lcd_background = PSP_LCD_BACKGROUND;
    loc_lcd_foreground = PSP_LCD_FOREGROUND;
    first = 0;
  }

  loc_PutImage_max();

  if (psp_kbd_is_danzeff_mode()) {
    danzeff_moveTo(-20, -55);
    danzeff_render();
  }

  if (TI92.psp_display_lr) {
    psp_kbd_display_active_mapping();
  }
  psp_sdl_flip();

  if (psp_screenshot_mode) {
    psp_screenshot_mode--;
    if (psp_screenshot_mode <= 0) {
      psp_save_screenshot();
      psp_screenshot_mode = 0;
    }
  }
}

void
psp_save_screenshot(void)
{
  char TmpFileName[MAX_PATH];
  sprintf(TmpFileName,"%s/scr/screenshot_%d.png", TI92.psp_home_path, TI92.psp_screenshot_id++);
  if (TI92.psp_screenshot_id >= 10) TI92.psp_screenshot_id = 0;
  psp_sdl_save_png(TmpFileName);
}

void 
exit_specific(void) 
{
  CloseTigerWin();
}

void set_screen_ptr(unsigned char *ptr) {
  the_screen = ptr;
}

void 
update_screen(void) 
{
  unsigned char *ptr = the_screen;
  int i,j,k;
  if(!(emuState & ESTAT_SCREENON))
    return;

  if(!grayPlanes || !currPlane) {
    for(j=0, k=0; k<128; k++)
      for(i=0; i<30; i++, ptr++) {
        screenBuf[j++] = convtab[(*ptr)<<1];
        screenBuf[j++] = convtab[((*ptr)<<1)+1];
      }
  }
  else {
    for(j=0, k=0; k<128; k++)
      for(i=0; i<30; i++, ptr++) {
        screenBuf[j++] += convtab[(*ptr)<<1];
        screenBuf[j++] += convtab[((*ptr)<<1)+1];
      }
  }

  if(currPlane++ >= grayPlanes) {
    loc_PutImage();
    currPlane = 0;
  }
}
