/*
Copyright (C) 2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "Precompiled.h"
#include "DaedThread.h"

#include <pthread.h>

namespace daedalus
{

const s32	INVALID_THREAD_HANDLE( -1 );

namespace
{
DAEDALUS_STATIC_ASSERT( sizeof( pthread_t ) == sizeof( s32 ) );

const int	gThreadPriorities[ TP_NUM_PRIORITIES ] = 
{
	0x19,		// TP_LOW
	0x18,		// TP_NORMAL
	0x17,		// TP_HIGH
	0x16,		// TP_TIME_CRITICAL
};

pthread_t	HandleToPthread( s32 handle )
{
	return handle == INVALID_THREAD_HANDLE ? 0 : reinterpret_cast< pthread_t >( handle );
}

s32 PthreadToHandle( pthread_t thread )
{
	return thread ? reinterpret_cast< s32 >( thread ) : INVALID_THREAD_HANDLE;
}

//*****************************************************************************
//	The real thread is passed in as an argument. We call it and return the result
//*****************************************************************************
void * StartThreadFunc(void * arg)
{
	DaedThread * p_p_func( reinterpret_cast< DaedThread * >( arg ) );

	int result = (*p_p_func)();

	pthread_exit( &result );
	return NULL;
}

} // anonymous namespace

//*****************************************************************************
//
//*****************************************************************************
s32		CreateThread( DaedThread p_function, bool start_on_creation )
{
	pthread_t		thread;
	pthread_attr_t	thread_attr;
	
	pthread_attr_init( &thread_attr );
	
	DAEDALUS_ASSERT( start_on_creation, "Threads can't currently be suspended on creation" );

	s32	result( ::pthread_create(&thread, &thread_attr, &StartThreadFunc, reinterpret_cast<void*>( p_function )) );

	if(result == 0)
	{
		//if(start_on_creation)
		//{
		//	PFunction = p_function;

		//	::sceKernelStartThread(thid, sizeof(DaedThread*), &PFunction);

		//	return thid;
		//}
		return PthreadToHandle( thread );
	}
	
	pthread_attr_destroy( &thread_attr );
	return INVALID_THREAD_HANDLE;
}

//*****************************************************************************
//
//*****************************************************************************
void	SetThreadPriority( s32 handle, EThreadPriority pri )
{
	DAEDALUS_ASSERT( false, "Thread priorities not supported" );
}

//*****************************************************************************
//
//*****************************************************************************
void	ReleaseThreadHandle( s32 handle )
{
	// Nothing to do?
}

//*****************************************************************************
//	Wait the specified time for the thread to finish.
//	Returns false if the thread didn't terminate
//*****************************************************************************
bool	WaitForThreadTermination( s32 handle, s32 timeout )
{
	//u32		delay( timeout > 0 ? timeout : INFINITE );
	bool	signalled( true );

	pthread_join( HandleToPthread( handle ), NULL );

	return signalled;
}


}
