// Taken from http://svn.ps2dev.org/filedetails.php?repname=psp&path=%2Ftrunk%2Fpspgl%2Fpspgl_vidmem.c&rev=0&sc=0

#include "stdafx.h"
#include "VideoMemoryManager.h"

#include "DaedMemoryHeap.h"

#include <pspge.h>

namespace
{
	static const u32 UNCACHED_MEMORY_ADDRESS = 0x40000000;

	template< typename T > T Uncached( T ptr ) 
	{
		return reinterpret_cast< T >( reinterpret_cast< u32 >( ptr ) | UNCACHED_MEMORY_ADDRESS );
	}
}

//*****************************************************************************
//
//*****************************************************************************
class IVideoMemoryManager : public CVideoMemoryManager
{
public:
	IVideoMemoryManager();
	~IVideoMemoryManager();

	virtual bool	Alloc( u32 size, void ** data, bool * isvidmem );
	virtual void	Free(void * ptr);

	virtual void	DisplayDebugInfo();

private:
	static	void	DisplayOutOfVideoMemWarning( u32 allocation_size );

private:
	CMemoryHeap *	mVideoMemoryHeap;
	CMemoryHeap *	mRamMemoryHeap;
};


//*****************************************************************************
//
//*****************************************************************************
namespace daedalus
{
template<> bool CSingleton< CVideoMemoryManager >::Create()
{
	DAEDALUS_ASSERT_Q(mpInstance == NULL);
	
	mpInstance = new IVideoMemoryManager();
	return mpInstance != NULL;
}
}

//*****************************************************************************
//
//*****************************************************************************
IVideoMemoryManager::IVideoMemoryManager()
:	mVideoMemoryHeap( CMemoryHeap::Create( Uncached( sceGeEdramGetAddr() ), sceGeEdramGetSize() ) )
,	mRamMemoryHeap( CMemoryHeap::Create( 1 * 1024 * 1024 ) )
{
	printf( "vram base: %p\n", sceGeEdramGetAddr() );
	printf( "vram size: %d KB\n", sceGeEdramGetSize() / 1024 );
}

//*****************************************************************************
//
//*****************************************************************************
IVideoMemoryManager::~IVideoMemoryManager()
{
	delete mVideoMemoryHeap;
	delete mRamMemoryHeap;
}

//*****************************************************************************
//
//*****************************************************************************
bool IVideoMemoryManager::Alloc( u32 size, void ** data, bool * isvidmem )
{
	void * mem;
	
	mem = mVideoMemoryHeap->Alloc( size );
	if( mem != NULL )
	{
		*data = mem;
		*isvidmem = true;
		return true;
	}

	DisplayOutOfVideoMemWarning( size );

	mem = mRamMemoryHeap->Alloc( size );
	if( mem != NULL )
	{
		*data = mem;
		*isvidmem = false;
		return true;
	}

	*data = NULL;
	*isvidmem = false;
	return false;
}

//*****************************************************************************
//
//*****************************************************************************
void  IVideoMemoryManager::Free(void * ptr)
{
	if( ptr == NULL )
	{

	}
	else if( mVideoMemoryHeap->IsFromHeap( ptr ) )
	{
		mVideoMemoryHeap->Free( ptr );
	}
	else if( mRamMemoryHeap->IsFromHeap( ptr ) )
	{
		mRamMemoryHeap->Free( ptr );
	}
	else
	{
		DAEDALUS_ERROR( "Memory is not from any of our heaps" );
	}
}

//*****************************************************************************
//
//*****************************************************************************
void IVideoMemoryManager::DisplayOutOfVideoMemWarning( u32 allocation_size )
{
#ifndef DAEDALUS_RELEASE_BUILD
	char	msg[ 256 ];
	sprintf( msg, "Out of video memory (allocating %d bytes)", allocation_size );
	DAEDALUS_ASSERTMSG( msg );
#endif
}

//*****************************************************************************
//
//*****************************************************************************
void IVideoMemoryManager::DisplayDebugInfo()
{
	printf( "VRAM\n" );
	mVideoMemoryHeap->DisplayDebugInfo();

	printf( "RAM\n" );
	mRamMemoryHeap->DisplayDebugInfo();
}
