#define SR_MATH_IMM_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_MATH_IMM_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_MATH_IMM		//return FALSE;

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_ADDI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM
	return SR_Emit_ADDIU(pCode, op_code, p_flags);
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_ADDIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);
			
	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_ADDIU);
	}
	else
	{
		s16 immediate = (s16)op_code.immediate;

		pCode->dwNumOptimised++;

		if (rt == REG_r0) return TRUE;

		pCode->mpCodeGenerator->GenerateADDIU( rt, rs, immediate );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_ANDI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM

	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_ANDI);
	}
	else
	{
		u16	immediate( op_code.immediate );

		pCode->dwNumOptimised++;

		if (rt == REG_r0) return TRUE;			// Skip attempts to write to r0

		pCode->mpCodeGenerator->GenerateANDI( rt, rs, immediate );
	}
	
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_ORI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM

	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_ORI);
	}
	else
	{
		u16	immediate( op_code.immediate );

		pCode->dwNumOptimised++;

		if (rt == REG_r0) return TRUE;			// Skip attempts to write to r0

		pCode->mpCodeGenerator->GenerateORI( rt, rs, immediate );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_XORI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_XORI);
	}
	else
	{
		u16	immediate( op_code.immediate );

		pCode->dwNumOptimised++;

		if (rt == 0) return TRUE;

		pCode->mpCodeGenerator->GenerateXORI( rt, rs, immediate );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_LUI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM

	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_D(rt);

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LUI);
	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (rt == 0) return TRUE;		// Don't set reg0

		pCode->mpCodeGenerator->GenerateLUI( rt, op_code.immediate );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_SLTI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM

	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_SLTI);
	}
	else
	{
		s16 immediate = (s16)op_code.immediate;

		pCode->dwNumOptimised++;

		if (rt == 0) return TRUE;		// Don't set r0

		pCode->mpCodeGenerator->GenerateSLTI( rt, rs, immediate );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_SLTIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_SLTIU);
	}
	else
	{
		s16 immediate = (s16)op_code.immediate;

		pCode->dwNumOptimised++;

		if (rt == 0) return TRUE;		// Don't set r0

		pCode->mpCodeGenerator->GenerateSLTIU( rt, rs, immediate );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_SLL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM

	// NOP!
	if (op_code._u32 == 0) 
	{
		pCode->dwNumOptimised++;
		return TRUE;
	}
	
	const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	// Skip NOPS

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SLL);
	}
	else
	{
		pCode->dwNumOptimised++;

		if (rd == 0) return TRUE;

		pCode->mpCodeGenerator->GenerateSLL( rd, rt, dwSA );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_SRL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM
	const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);
	
	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SRL);
	}
	else
	{
		pCode->dwNumOptimised++;

		if (rd == 0) return TRUE;	// Don't set reg0

		pCode->mpCodeGenerator->GenerateSRL( rd, rt, dwSA );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_SRA(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH_IMM
	const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	if (SR_MATH_IMM_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SRA);
	}
	else
	{
		pCode->dwNumOptimised++;

		if (rd == 0) return TRUE;	// Don't set reg0

		pCode->mpCodeGenerator->GenerateSRA( rd, rt, dwSA );
	}
	return TRUE;
}
