/*
Copyright (C) 2001,2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef DYNARECCODE_H_
#define DYNARECCODE_H_

typedef void (* DynarecFunctionType)();

class CCodeBufferManager;
class CCodeGenerator;

#include "AssemblyBuffer.h"
#include "Core/R4300OpCode.h"


struct SRegisterStats
{
	u32		RegReads[32];		// #times used at src
	u32		RegUpdates[32];		// #times used as dest
	u32		RegBaseUse[32];		// #times used as base

	u32		SRegReads[32];		// #times used at src
	u32		SRegUpdates[32];	// #times used as dest
	
	u32		DRegReads[32];		// #times used at src
	u32		DRegUpdates[32];	// #times used as dest

	void	Reset();
	void	Display() const;
};



class CDynarecCode
{
public:
	CDynarecCode(u32 dwPC, u32 dwOp);
	virtual ~CDynarecCode();

public:
	DynarecFunctionType		mpFunctionPointer;	// Our compiled function

	CCodeGenerator *		mpCodeGenerator;


	u32		dwStartPC;			// The starting PC of this code fragment
	u32		dwEndPC;
	OpCode	mOriginalOp;		// The original opcode
	u32		dwNumOps;			// Number of operations compiled into i386
	u32		dwNumOptimised;		// Number of operations that have been optimised

	u32		HitCount;			// The number of times the compiled code has been executed
	u32		dwOptimiseLevel;	// The level of optimisation applied

	SRegisterStats	Stats;

	u32		dwBranchTarget;		// Target address if we take the branch

	u32		dwEntry;			// Entry into global array

	void		AllocateCodeBuffer( CCodeBufferManager * p_manager );
	void		FinaliseCodeBuffer( CCodeBufferManager * p_manager );

	u32			GetCompiledCodeSize() const;

	///////////////////////////////////////////////////////////////////

public:
	//*****************************************************************************
	// Statistics
	//*****************************************************************************
	
	inline void Stat_D_S_S( u32 d, u32 s1, u32 s2)
	{
		Stats.RegUpdates[d]++;
		Stats.RegReads[s1]++;
		Stats.RegReads[s2]++;	 
	}

	inline void Stat_D_S( u32 d, u32 s)
	{
		Stats.RegUpdates[d]++;
		Stats.RegReads[s]++; 
	}

	inline void Stat_D( u32 d)
	{
		Stats.RegUpdates[d]++;
	}

	inline void Stat_S( u32 s)
	{
		Stats.RegReads[s]++;
	}

	inline void Stat_S_S( u32 s1, u32 s2)
	{
		Stats.RegReads[s1]++;
		Stats.RegReads[s2]++;
	}

	inline void Stat_Base( u32 b)
	{
		Stats.RegBaseUse[b]++; 
	}

	inline void Stat_Load_B_D( u32 b, u32 d)
	{
		Stats.RegBaseUse[b]++;
		Stats.RegUpdates[d]++;
	}

	inline void Stat_Load_B( u32 b)
	{
		Stats.RegBaseUse[b]++;
	}
	
	inline void Stat_Save_B_S( u32 b, u32 s)
	{
		Stats.RegBaseUse[b]++;
		Stats.RegReads[s]++;
	}

	inline void Stat_Save_B( u32 b)
	{
		Stats.RegBaseUse[b]++;
	}


	inline void Stat_Long_D(u32 d)
	{
	}
	inline void Stat_Word_D(u32 d)
	{
	}

	inline void Stat_Single_Unk()
	{
	}

	inline void Stat_Single_D_S_S(u32 d, u32 s1, u32 s2)
	{
		Stats.SRegUpdates[d]++;
		Stats.SRegReads[s1]++;
		Stats.SRegReads[s2]++;
	}

	inline void Stat_Single_D_S(u32 d, u32 s)
	{
		Stats.SRegUpdates[d]++;
		Stats.SRegReads[s]++;
	}

	inline void Stat_Single_S_S(u32 s1, u32 s2)
	{
		Stats.SRegReads[s1]++;
		Stats.SRegReads[s2]++;
	}
	
	inline void Stat_Single_D(u32 d)
	{
		Stats.SRegUpdates[d]++;
	}

	inline void Stat_Single_S(u32 s)
	{
		Stats.SRegReads[s]++;
	}

	inline void Stat_Double_Unk()
	{
	}

	inline void Stat_Double_D_S_S(u32 d, u32 s1, u32 s2)
	{
		Stats.DRegUpdates[d]++;
		Stats.DRegReads[s1]++;
		Stats.DRegReads[s2]++;	 
	}

	inline void Stat_Double_D_S(u32 d, u32 s)
	{
		Stats.DRegUpdates[d]++;
		Stats.DRegReads[s]++;
	}

	inline void Stat_Double_S_S(u32 s1, u32 s2)
	{
		Stats.DRegReads[s1]++;
		Stats.DRegReads[s2]++;
	}

	inline void Stat_Double_D(u32 d)
	{
		Stats.DRegUpdates[d]++;
	}

	inline void Stat_Double_S(u32 s)
	{
		Stats.DRegReads[s]++;
	}





};

#endif // DYNARECCODE_H_
