/*
Copyright (C) 2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DYNARECTABLES_H_
#define DYNARECTABLES_H_

// Return TRUE if compiled ok, FALSE otherwise
typedef BOOL (*SR_EmitInstructionType)(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);


// Opcode Jump Table
extern SR_EmitInstructionType SR_EmitInstruction[64];

// SpecialOpCode Jump Table
extern SR_EmitInstructionType SR_EmitSpecialInstruction[64];

// RegImmOpCode Jump Table
extern SR_EmitInstructionType SR_EmitRegImmInstruction[32];
// COP0 Jump Table
extern SR_EmitInstructionType SR_EmitCop0Instruction[32];

// COP1 Jump Table
extern SR_EmitInstructionType SR_EmitCop1Instruction[32];
extern SR_EmitInstructionType SR_EmitCop1BC1Instruction[4];

// Single Jump Table
extern SR_EmitInstructionType SR_EmitCop1SInstruction[64];

// Double Jump Table
extern SR_EmitInstructionType SR_EmitCop1DInstruction[64];

#endif // DYNARECTABLES_H_
