/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DYNAREC_H_
#define DYNAREC_H_

#include "Core/CPU.h"
#include "DynarecCode.h"


bool				DynaRec_Init(u32 initial_table_size);
void				DynaRec_Reset();
void				DynaRec_Fini();
CDynarecCode *		DynaRec_CompileCode(u32 dwPC);
void				DynaRec_OptimiseCode(CDynarecCode *pCode, u32 dwLevel);
void				DynaRec_Stats();
CDynarecCode *		DynaRec_GetEntry( u32 entry );
CCodeBufferManager *DynaRec_GetCodeBufferManager();

extern u32	 g_dwNumSRCompiled;
extern u32	 g_dwNumSROptimised;
extern u32	 g_dwNumSRFailed;

inline void DynaRec_ExecuteCode(CDynarecCode * pCode)
{
	// Assume that pCode is always found. Possibly an unsafe assumption, but 
	// Good for performance
	pCode->HitCount++;

	// Check if it's worth recompiling this code
	if (pCode->HitCount == 5)
	{
		DynaRec_OptimiseCode(pCode, 0);
	}

	// Execute the compiled code
	pCode->mpFunctionPointer();

	// Ignore the last instruction...
	//	*(u32 *)&g_qwCPR[0][COUNT] = (u32)g_qwCPR[0][COUNT] + 1;//(pCode->dwNumOps-1);
	//	g_dwNextInterruptCount -= 1;//(pCode->dwNumOps-1);


}

inline void DynaRec_ExecuteCode_AlreadyOptimised(CDynarecCode * pCode)
{
#ifdef _DEBUG
	// For stats
	pCode->HitCount++;
#endif
	// Execute the compiled code
	pCode->mpFunctionPointer();
}

#endif // DYNAREC_H_
