/*
Copyright (C) 2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "Precompiled.h"
#include "DaedThread.h"

#include <pspthreadman.h>

namespace daedalus
{

static const int	gThreadPriorities[ TP_NUM_PRIORITIES ] = 
{
	0x19,		// TP_LOW
	0x18,		// TP_NORMAL
	0x17,		// TP_HIGH
	0x16,		// TP_TIME_CRITICAL
};

const s32	INVALID_THREAD_HANDLE( -1 );

//*****************************************************************************
//	The real thread is passed in as an argument. We call it and return the result
//*****************************************************************************
static int StartThreadFunc(SceSize args, void *argp)
{
	if(args == sizeof(DaedThread*))
	{
		DaedThread * p_p_func( reinterpret_cast< DaedThread * >( argp ) );
	    return (*p_p_func)();
	}

	return -1;
}

//*****************************************************************************
//
//*****************************************************************************
// XXXX p_function might go out of scope, so I'm doing this. There must be a nicer way. It's not thread safe at the moment
static DaedThread	PFunction;

s32		CreateThread( DaedThread p_function, bool start_on_creation )
{
	s32	thid( ::sceKernelCreateThread("daed_thread", StartThreadFunc, gThreadPriorities[TP_NORMAL], 0x10000, 0, NULL) );

	if(thid >= 0)
	{
		if(start_on_creation)
		{
			PFunction = p_function;

			::sceKernelStartThread(thid, sizeof(DaedThread*), &PFunction);

			return thid;
		}
	}

	return INVALID_THREAD_HANDLE;
}

//*****************************************************************************
//
//*****************************************************************************
void	SetThreadPriority( s32 handle, EThreadPriority pri )
{
	if(handle != INVALID_THREAD_HANDLE)
	{
		::sceKernelChangeThreadPriority( handle, gThreadPriorities[ pri ] );
	}
}

//*****************************************************************************
//
//*****************************************************************************
void	ReleaseThreadHandle( s32 handle )
{
	// Nothing to do?
}

//*****************************************************************************
//	Wait the specified time for the thread to finish.
//	Returns false if the thread didn't terminate
//*****************************************************************************
bool	WaitForThreadTermination( s32 handle, s32 timeout )
{
	//u32		delay( timeout > 0 ? timeout : INFINITE );
	bool	signalled( true );

	// XXXX

	return signalled;
}


}
