/*
Copyright (C) 2006 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "Precompiled.h"
#include "DaedIO.h"

#include <pspiofilemgr.h>
#include <sys/stat.h>

namespace daedalus
{

	namespace IO
	{
		const char gPathSeparator( '/' );
		namespace File
		{
			bool	Move( const char * p_existing, const char * p_new )
			{
				return sceIoRename( p_existing, p_new ) >= 0;
			}

			bool	Delete( const char * p_file )
			{
				return sceIoRemove( p_file ) >= 0;
			}

			bool	Exists( const char * p_path )
			{
				FILE * fh = fopen( p_path, "rb" );
				if ( fh )
				{
					fclose( fh );
					return true;
				}
				else
				{
					return false;
				}
			}
		}
		namespace Directory
		{
			bool	Create( const char * p_path )
			{
				return sceIoMkdir( p_path, 0777 ) == 0;
			}

			bool	EnsureExists( const char * p_path )
			{
				if ( IsDirectory(p_path) )
					return true;

				// Make sure parent exists, 
				char	p_path_parent[ IO::Path::MAX_PATH_LEN+1 ];
				strncpy( p_path_parent, p_path, IO::Path::MAX_PATH_LEN );
				p_path_parent[IO::Path::MAX_PATH_LEN-1] = '\0';
				IO::Path::RemoveBackslash( p_path_parent );
				if( IO::Path::RemoveFileSpec( p_path_parent ) )
				{
					//
					//	Recursively create parents. Need to be careful of stack overflow
					//
					if( !EnsureExists( p_path_parent ) )
						return false;
				}

				return Create( p_path );
			}

			bool	IsDirectory( const char * p_path )
			{
				struct stat		s;

				if(stat( p_path, &s ) == 0)
				{
					if(s.st_mode & _IFDIR)
					{
						return true;
					}
				}

				return false;
			}
		}

		namespace Path
		{
			char *	Combine( char * p_dest, const char * p_dir, const char * p_file )
			{
				strcpy( p_dest, p_dir );
				Append( p_dest, p_file );
				return p_dest;
			}

			bool	Append( char * p_path, const char * p_more )
			{
				u32		len( strlen(p_path) );

				if(len > 0)
				{
					if(p_path[len-1] != gPathSeparator)
					{
						p_path[len] = gPathSeparator;
						p_path[len+1] = '\0';
						len++;
					}
				}
				strcat( p_path, p_more );
				return true;
			}

			const char *  FindExtension( const char * p_path )
			{
				return strrchr( p_path, '.' );
			}

			const char *	FindFileName( const char * p_path )
			{
				char * p_last_slash = strrchr( p_path, gPathSeparator );
				if ( p_last_slash )
				{
					return p_last_slash + 1;
				}
				else
				{
					return NULL;
				}
			}

			char *	RemoveBackslash( char * p_path )
			{
				u32 len = strlen( p_path );
				if ( len > 0 )
				{
					char * p_last_char( &p_path[ len - 1 ] );
					if ( *p_last_char == gPathSeparator )
					{
						*p_last_char = '\0';
					}
					return p_last_char;
				}
				return NULL;
			}

			bool	RemoveFileSpec( char * p_path )
			{
				char * last_slash = strrchr( p_path, gPathSeparator );
				if ( last_slash )
				{
					*last_slash = '\0';
					return true;
				}
				return false;
			}

			void	RemoveExtension( char * p_path )
			{
				char * ext = const_cast< char * >( FindExtension( p_path ) );
				if ( ext )
				{
					*ext = '\0';
				}
			}

			bool	AddExtension( char * p_path, const char * p_ext )
			{
				strcat( p_path, p_ext );
				return true;
			}
		}
	}
}

