/*
Copyright (C) 2006 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DAEDIO_H_
#define DAEDIO_H_

namespace daedalus
{
	namespace IO
	{
		namespace File
		{
			bool	__cdecl	Move( const char * p_existing, const char * p_new );
			bool	__cdecl	Delete( const char * p_file );
			bool	__cdecl	Exists( const char * p_path );

		}
		namespace Directory
		{
			bool	__cdecl	Create( const char * p_path );
			bool	__cdecl EnsureExists( const char * p_path );
			bool	__cdecl	IsDirectory( const char * p_path );
		}

		namespace Path
		{
			const u32	MAX_PATH_LEN = 260;

			char *			__cdecl	Combine( char * p_dest, const char * p_dir, const char * p_file );
			bool			__cdecl	Append( char * p_path, const char * p_more );
			const char *	__cdecl FindExtension( const char * p_path );
			const char *	__cdecl	FindFileName( const char * p_path );
			char *			__cdecl	RemoveBackslash( char * p_path );
			bool			__cdecl	RemoveFileSpec( char * p_path );
			void			__cdecl	RemoveExtension( char * p_path );
			bool			__cdecl	AddExtension( char * p_path, const char * p_ext );
		}
	}

}

#endif

