/*
Copyright (C) 2007 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef FRAMERATELIMITER_H_
#define FRAMERATELIMITER_H_

enum ETvFrequency
{
	TVF_50Hz = 0,
	TVF_60Hz,

	NUM_TV_FREQUENCIES,
};

void			FramerateLimiter_Reset();
void			FramerateLimiter_Limit();
f32				FramerateLimiter_GetSync();											// Returns fraction of real n64 we're running at (1 = 100%)
void			FramerateLimiter_SetLimit( bool limit );
bool			FramerateLimiter_GetLimit();
void			FramerateLimiter_SetTvFrequency( ETvFrequency frequency );			// Should be TVF_50Hz for PAL, TVF_60Hz for NTSC
u32				FramerateLimiter_GetTvFrequencyHz();

#endif // FRAMERATELIMITER_H_
