/*
Copyright (C) 2007 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef AUDIOPLUGINDLL_H__
#define AUDIOPLUGINDLL_H__

#include "Plugins/AudioPlugin.h"
#include "AudioPlugin_Spec.h"
#include "DaedCritSect.h"
#include "Debug/DBGConsole.h"



#ifdef DAEDALUS_USE_EXCEPTIONS
#define AI_TRY		try
#define AI_CATCH	catch(...)								\
		{													\
				DBGConsole_Msg(0, "Exception in [C%s]", mModuleName);	\
				/*Close();*/									\
		}
#else
#define AI_TRY
#define AI_CATCH
#endif

#define PLUGIN_SPEC_CALL		__cdecl


class CAudioPluginDll : public CAudioPlugin
{
public:
	virtual ~CAudioPluginDll();

	static CAudioPluginDll *		Create( const char * dll_name );

public:

	void DacrateChanged(ESystemType system_type)
	{
		AUTO_CRIT_SECT( mCritSect );

		if (pDacrateChanged)
		{
			AI_TRY
			{ 
				int nSystemType( SYSTEM_NTSC );

				switch( system_type )
				{
				case ST_NTSC:	nSystemType = SYSTEM_NTSC; break;		
				case ST_PAL:	nSystemType = SYSTEM_PAL; break;		
				case ST_MPAL:	nSystemType = SYSTEM_MPAL; break;		
				}
				
				pDacrateChanged(nSystemType);
			}
			AI_CATCH
		}
	}
	void LenChanged()
	{
		AUTO_CRIT_SECT( mCritSect );
		
		if (pLenChanged)
		{
			AI_TRY { pLenChanged(); }
			AI_CATCH
		}
	}

	u32 ReadLength()
	{
		u32 length( 0 );

		AUTO_CRIT_SECT( mCritSect );
		
		if (pReadLength)
		{
			AI_TRY { length = pReadLength(); }
			AI_CATCH
		}
		return length;
	}


	//
	// A special version of the function for the Audiothread, which
	// does it's own exception handling to avoid the overhead with 
	// each call
	//
	virtual void Update( bool wait )
	{
		//AUTO_CRIT_SECT( mCritSect );
		//if (pUpdate)
		//{
		//	AI_TRY { pUpdate( wait ); }
		//	AI_CATCH
		//}

		pUpdate( wait );
	}

	void DllAbout(HWND hWndParent)
	{
		AUTO_CRIT_SECT( mCritSect );
		
		if (pDllAbout)
		{
			AI_TRY { pDllAbout(hWndParent); }
			AI_CATCH
		}
	}


	void DllConfig(HWND hWndParent)
	{
		AUTO_CRIT_SECT( mCritSect );
		
		if (pDllConfig)
		{
			AI_TRY { pDllConfig(hWndParent); }
			AI_CATCH
		}
	}

	void DllTest(HWND hWndParent)
	{
		AUTO_CRIT_SECT( mCritSect );
		
		if (pDllTest)
		{
			AI_TRY { pDllTest(hWndParent); }
			AI_CATCH
		}
	}

	void ProcessAList(void)
	{
		AUTO_CRIT_SECT( mCritSect );
		
		if (pProcessAList)
		{
			AI_TRY { pProcessAList(); }
			AI_CATCH
		}
	}
	void RomClosed(void)
	{
		AUTO_CRIT_SECT( mCritSect );
		
		if (pRomClosed)
		{
			AI_TRY { pRomClosed(); }
			AI_CATCH
		}
	}

	// szName must be 100 chars
	const char *		GetPluginName() const			{ return mPluginInfo.Name; }

	virtual bool		StartEmulation();
	virtual void		StopEmulation();

private:
	CAudioPluginDll(const char * dll_name);

	bool	OpenDll();

	BOOL InitiateAudio(AUDIO_INFO ai)
	{
		BOOL bInit = FALSE;

		AUTO_CRIT_SECT( mCritSect );
		
		if (pInitiateAudio)
		{
			AI_TRY { bInit = pInitiateAudio(ai); }
			AI_CATCH
		}
	
		return bInit;
	}



private:

	void   (PLUGIN_SPEC_CALL * pDacrateChanged)(int);
	void   (PLUGIN_SPEC_CALL * pLenChanged)(void);
	DWORD  (PLUGIN_SPEC_CALL * pReadLength)(void);
	void   (PLUGIN_SPEC_CALL * pUpdate)(BOOL);
	void   (PLUGIN_SPEC_CALL * pCloseDll)();
	void   (PLUGIN_SPEC_CALL * pDllAbout)(HWND);
	void   (PLUGIN_SPEC_CALL * pDllConfig)(HWND);
	void   (PLUGIN_SPEC_CALL * pDllTest)(HWND);
	BOOL   (PLUGIN_SPEC_CALL * pInitiateAudio)(AUDIO_INFO);
	void   (PLUGIN_SPEC_CALL * pProcessAList)(void);
	void   (PLUGIN_SPEC_CALL * pRomClosed)(void);

	HINSTANCE			hModule;
	PLUGIN_INFO			mPluginInfo;
	char				mModuleName[MAX_PATH+1];

	CCritSect	mCritSect;
};


#endif AUDIOPLUGINDLL_H__
