#ifndef FFXMATHS_H__
#define FFXMATHS_H__

inline float InvSqrt(float x)
{
   float result;
   __asm__ volatile (
      "mtv     %1, S000\n"
      "vrsq.s S000, S000\n"
      "mfv     %0, S000\n"
   : "=r"(result) : "r"(x));

   return result;
} 

inline float Sqrt(float x)
{
    float result;

    __asm__ volatile (
            "mtv %1, S000\n"
            "vsqrt.s S001, S000\n"
            "mfv %0, S001\n"
    : "=r"(result) : "r"(x) );

    return result;
}

#endif // FFXMATHS_H__
