/*
Copyright (C) 2001,2006,2007 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"

#include "BlendModes.h"
#include "PSPRenderer.h"
#include "Texture.h"
#include "NativeTexture.h"
#include "RDP.h"
#include "PSPColour.h"

#include "Core/ROM.h"

#include <pspgu.h>

static const char * sc_colcombtypes32[32] =
{
	"Combined    ", "Texel0      ",
	"Texel1      ", "Primitive   ", 
	"Shade       ", "Env         ",
	"1           ", "CombAlp     ",
	"Texel0_Alp  ", "Texel1_Alp  ",
	"Prim_Alpha  ", "Shade_Alpha ",
	"Env_Alpha   ", "LOD_Frac    ",
	"PrimLODFrac ", "K5          ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ",	"0           "
};
static const char *sc_colcombtypes16[16] =
{
	"Combined    ", "Texel0      ",
	"Texel1      ", "Primitive   ", 
	"Shade       ", "Env         ",
	"1           ", "CombAlp     ",
	"Texel0_Alp  ", "Texel1_Alp  ",
	"Prim_Alp    ", "Shade_Alpha ",
	"Env_Alpha   ", "LOD_Frac    ",
	"PrimLOD_Frac", "0           "
};
static const char *sc_colcombtypes8[8] =
{
	"Combined    ", "Texel0      ",
	"Texel1      ", "Primitive   ", 
	"Shade       ", "Env         ",
	"1           ", "0           ",
};



void PrintMux( FILE * fh, u64 mux )
{
	u32 mux0 = (u32)(mux>>32);
	u32 mux1 = (u32)(mux);
	
	u32 aRGB0  = (mux0>>20)&0x0F;	// c1 c1		// a0
	u32 bRGB0  = (mux1>>28)&0x0F;	// c1 c2		// b0
	u32 cRGB0  = (mux0>>15)&0x1F;	// c1 c3		// c0
	u32 dRGB0  = (mux1>>15)&0x07;	// c1 c4		// d0

	u32 aA0    = (mux0>>12)&0x07;	// c1 a1		// Aa0
	u32 bA0    = (mux1>>12)&0x07;	// c1 a2		// Ab0
	u32 cA0    = (mux0>>9 )&0x07;	// c1 a3		// Ac0
	u32 dA0    = (mux1>>9 )&0x07;	// c1 a4		// Ad0

	u32 aRGB1  = (mux0>>5 )&0x0F;	// c2 c1		// a1
	u32 bRGB1  = (mux1>>24)&0x0F;	// c2 c2		// b1
	u32 cRGB1  = (mux0    )&0x1F;	// c2 c3		// c1
	u32 dRGB1  = (mux1>>6 )&0x07;	// c2 c4		// d1
	
	u32 aA1    = (mux1>>21)&0x07;	// c2 a1		// Aa1
	u32 bA1    = (mux1>>3 )&0x07;	// c2 a2		// Ab1
	u32 cA1    = (mux1>>18)&0x07;	// c2 a3		// Ac1
	u32 dA1    = (mux1    )&0x07;	// c2 a4		// Ad1

	fprintf(fh, "\n\t\tcase 0x%08x%08xLL:\n", mux0, mux1);
	fprintf(fh, "\t\t//aRGB0: (%s - %s) * %s + %s\n", sc_colcombtypes16[aRGB0], sc_colcombtypes16[bRGB0], sc_colcombtypes32[cRGB0], sc_colcombtypes8[dRGB0]);		
	fprintf(fh, "\t\t//aA0  : (%s - %s) * %s + %s\n", sc_colcombtypes8[aA0], sc_colcombtypes8[bA0], sc_colcombtypes8[cA0], sc_colcombtypes8[dA0]);
	fprintf(fh, "\t\t//aRGB1: (%s - %s) * %s + %s\n", sc_colcombtypes16[aRGB1], sc_colcombtypes16[bRGB1], sc_colcombtypes32[cRGB1], sc_colcombtypes8[dRGB1]);		
	fprintf(fh, "\t\t//aA1  : (%s - %s) * %s + %s\n", sc_colcombtypes8[aA1],  sc_colcombtypes8[bA1], sc_colcombtypes8[cA1],  sc_colcombtypes8[dA1]);

}

// 007
//case 0x00111404ff13ffffLL:
//aRGB0: (Texel0       - 0           ) * Texel1       + 0           
//aA0  : (Texel0       - 0           ) * Texel1       + 0           
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Shade        + 0           
void BlendMode_0x00111404ff13ffffLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
	else
	{
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
	}
}

// RR64
//case 0x00117e045ffef3f8LL:
//aRGB0: (Texel0       - Env         ) * Texel1       + Env
//aA0  : (0            - 0           ) * 0            + Texel0
//aRGB1: (Combined     - 0           ) * Shade        + 0
//aA1  : (0            - 0           ) * 0            + Combined
void BlendMode_0x00117e045ffef3f8LL( BLEND_MODE_ARGS )
{
	// RGB:  ( Shade * blend(Env,Texel0,Texel1) )
	// A:	Texel0
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		// XXXX need blend Env->T0
		details.ColourAdjuster.SetRGB( details.EnvColour );
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
	}
	else
	{
		details.ColourAdjuster.ModulateRGB( details.EnvColour );
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
	}
}

// Wetrix
//case 0x0011ffff2ffd7c38LL:
//aRGB0: (Texel0       - Texel1      ) * Primitive    + Texel1
//aA0  : (0            - 0           ) * 0            + 1
//aRGB1: (0            - 0           ) * 0            + Combined
//aA1  : (0            - 0           ) * 0            + Combined
void BlendMode_0x0011ffff2ffd7c38LL( BLEND_MODE_ARGS )
{
	// XXXX - needs t1
	details.InstallTexture = true;
	// RGB = Blend( T1, T0, Prim )
	// A   = 1
	details.ColourAdjuster.SetAOpaque();
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGB);
}

// OoT paths
//case 0x00121603ff5bfff8LL:
//aRGB0: (Texel0       - 0           ) * Shade        + 0           
//aA0  : (Texel0       - 0           ) * Primitive    + 0           
//aRGB1: (Combined     - 0           ) * Primitive    + 0           
//aA1  : (Texel1       - 0           ) * 1            + Combined  
void BlendMode_0x00121603ff5bfff8LL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation - think is correct except t1
	details.InstallTexture = true;
	// RGB = T0 * Shade * Primitive
	// A   = T0 * Primitive + T1
	if( num_cycles == 1 )
	{
		details.ColourAdjuster.SetA( details.PrimColour );
	}
	else
	{
		details.ColourAdjuster.ModulateRGB( details.PrimColour );
		details.ColourAdjuster.SetA( details.PrimColour );
	}
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// THPS
//case 0x00127244ffffec38LL:
//aRGB0: (Texel0       - 0           ) * Shade        + 0           
//aA0  : (0            - 1           ) * Texel0       + 1           
//aRGB1: (Texel1       - 0           ) * Shade        + Combined    
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x00127244ffffec38LL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	// XXXX incorrect - needs 1 - T0 for alpha, +T1*Shade for 2nd cycle
	if( num_cycles == 1 )
	{
		// RGB = T0 * Shade
		// A   = 1-T0
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
	}
	else
	{
		// RGB = T0 * Shade + T1 * Shade
		// A   = 1-T0
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
	}
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);			// RGBA - modulate fragment alpha
}

// XXXX need to come up with something more cunning for this :(
//case 0x00127e2433fdf8fcLL:
//aRGB0: (Texel0       - Primitive   ) * Shade        + Primitive   
//aA0  : (0            - 0           ) * 0            + Shade       
//aRGB1: (Texel0       - Primitive   ) * Shade        + Primitive   
//aA1  : (0            - 0           ) * 0            + Shade       
void BlendMode_0x00127e2433fdf8fcLL( BLEND_MODE_ARGS )
{
	// Just select texture RGB and shade A for now
	details.InstallTexture = true;
	sceGuTexEnvColor( details.PrimColour.GetColour() );
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGB);
}


// BK
//case 0x001298043f15ffffLL:
//aRGB0: (Texel0       - Primitive   ) * Env          + Primitive   
//aA0  : (Texel0       - 0           ) * Shade        + 0           
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Env          + 0      
void BlendMode_0x001298043f15ffffLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	// RGB = Blend( Prim, T0, Env ) * Shade
	// A   = T0 * Shade * Env

	// Assume this is only ever used in 2 cycle
	
	// Hoplessly wrong - do Prim * Shade * T0, Env * Shade * T0
	details.InstallTexture = true;
	//details.ColourAdjuster.ModulateRGB( details.PrimColour );
	//details.ColourAdjuster.ModulateA( details.EnvColour );

	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		details.ColourAdjuster.SetRGB( c32::White );		// Set RGB to 1.0, i.e. select Texture
	}
	else
	{
		// Leave RGB shade untouched

		details.ColourAdjuster.ModulateA( details.EnvColour );
	}

	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// M64 eyes decal.
//case 0x00147e2844fe7b3dLL:
//aRGB0: (Texel0       - Shade       ) * Texel0_Alp   + Shade       
//aA0  : (0            - 0           ) * 0            + Env         
//aRGB1: (Texel0       - Shade       ) * Texel0_Alp   + Shade       
//aA1  : (0            - 0           ) * 0            + Env         
void BlendMode_0x00147e2844fe7b3dLL( BLEND_MODE_ARGS )
{
	// RGB = Blend( Shade, T0, T0Alpha )  -- essentially DECAL mode on PSP
	// A   = Env
	details.InstallTexture = true;
	details.ColourAdjuster.SetA( details.EnvColour );
	sceGuTexEnvColor( details.EnvColour.GetColour() );
	sceGuTexFunc(GU_TFX_DECAL,GU_TCC_RGBA);		
}

// F0
//case 0x00147e045ffefbf8LL:
//aRGB0: (Texel0       - Env         ) * Texel0_Alp   + Env         
//aA0  : (0            - 0           ) * 0            + Env         
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Combined 
void BlendMode_0x00147e045ffefbf8LL( BLEND_MODE_ARGS )
{
	// RGB = Blend(E,T0,T0a)*Shade	~= Blend(SE, ST0, T0a)
	// A   = Env

	// XXXX needs to modulate again by shade
	details.InstallTexture = true;
	details.ColourAdjuster.SetRGBA( details.EnvColour );
	sceGuTexEnvColor( details.EnvColour.GetColour() );
	sceGuTexFunc(GU_TFX_DECAL,GU_TCC_RGBA);		
}

// 007
//case 0x001598045ffedbf8LL:
//aRGB0: (Texel0       - Env         ) * Shade_Alpha  + Env         
//aA0  : (Texel0       - Env         ) * Shade        + Env         
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x001598045ffedbf8LL( BLEND_MODE_ARGS )
{
	// XXXX incorrect, need env and prim, blend has wrong source
	details.InstallTexture = true;

	// Use the primitive for the r,g,b, override the alpha with 1.0
	details.ColourAdjuster.SetRGB( c32::White );		// XXXX Really want to replicate
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGB);
}

// 007
//case 0x00167e2c33fdf6fbLL:
//aRGB0: (Texel0       - Primitive   ) * Env_Alpha    + Primitive   
//aA0  : (0            - 0           ) * 0            + Primitive   
//aRGB1: (Texel0       - Primitive   ) * Env_Alpha    + Primitive   
//aA1  : (0            - 0           ) * 0            + Primitive   
void BlendMode_0x00167e2c33fdf6fbLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;

	// XXXX Need to blend( Prim, T0, Enva )
	details.ColourAdjuster.SetRGBA( details.PrimColour );
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGB);
}

// OoT intro
//case 0x00167e6035fcff7eLL:
//aRGB0: (Texel0       - Primitive   ) * Env_Alpha    + Texel0      
//aA0  : (0            - 0           ) * 0            + 0           
//aRGB1: (Primitive    - Env         ) * Combined     + Env         
//aA1  : (0            - 0           ) * 0            + 1           
void BlendMode_0x00167e6035fcff7eLL( BLEND_MODE_ARGS )
{
	// XXXX incorrect, need env and prim, blend has wrong source
	details.InstallTexture = true;

	// Use the primitive for the r,g,b, override the alpha with 1.0
	details.ColourAdjuster.SetRGB( details.PrimColour );
	details.ColourAdjuster.SetAOpaque(); 		// 1.0 for Alpha
	sceGuTexEnvColor( details.EnvColour.GetColour() );
	sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGB);
}



// 007
//case 0x001690031f0c93ffLL:
//aRGB0: (Texel0       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel0       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Primitive    + 0           
//aA1  : (Combined     - 0           ) * Primitive    + 0           
void BlendMode_0x001690031f0c93ffLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;

	if( num_cycles == 1 )
	{
		// Use the primitive for the r,g,b,a
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
	else
	{
		// Use the primitive for the r,g,b,a
		details.ColourAdjuster.SetRGBA( details.PrimColour );
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
	}
}


// RR64
//case 0x0022aa041f0c93ffLL:
//aRGB0: (Texel1       - Texel0      ) * Env          + Texel0
//aA0  : (Texel1       - Texel0      ) * Env          + Texel0
//aRGB1: (Combined     - 0           ) * Shade        + 0
//aA1  : (Combined     - 0           ) * Primitive    + 0
void BlendMode_0x0022aa041f0c93ffLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	//RGB:	INEXACT = ( Shade * blend(Texel0,Texel1,Env) )
	//Alpha: INEXACT: ( Prim * blend(Texel0,Texel1,Env) )
	if( num_cycles == 1 )
	{
		details.ColourAdjuster.SetRGBA( details.EnvColour );
	}
	else
	{
		details.ColourAdjuster.ModulateRGB( details.EnvColour );
		details.ColourAdjuster.SetA( details.EnvColour.ModulateA( details.PrimColour ) );
	}
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// OoT skydome?
//case 0x002527ff1ffc9238LL:
//aRGB0: (Texel1       - Texel0      ) * Prim_Alpha   + Texel0      
//aA0  : (Texel1       - Texel0      ) * Primitive    + Texel0      
//aRGB1: (0            - 0           ) * 0            + Combined    
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x002527ff1ffc9238LL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation - is blending between T0/T1 using primitive colour
	details.InstallTexture = true;
	details.ColourAdjuster.SetRGBA( details.PrimColour.ReplicateAlpha() );
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// OoT?
//case 0x00262a60150c937fLL:
//aRGB0: (Texel1       - Texel0      ) * Env_Alpha    + Texel0      
//aA0  : (Texel1       - Texel0      ) * Env          + Texel0      
//aRGB1: (Primitive    - Env         ) * Combined     + Env         
//aA1  : (Combined     - 0           ) * Primitive    + 0           
void BlendMode_0x00262a60150c937fLL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation
	details.InstallTexture = true;
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
}

//case 0x00267e041f0cfdffLL:
//aRGB0: (Texel1       - Texel0      ) * Env_Alpha    + Texel0      
//aA0  : (0            - 0           ) * 0            + 1           
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Primitive    + 0           
void BlendMode_0x00267e041f0cfdffLL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation
	details.InstallTexture = true;
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGB);
}

// OoT ground texture
//case 0x00267e041ffcfdf8LL:
//aRGB0: (Texel1       - Texel0      ) * Env_Alpha    + Texel0      
//aA0  : (0            - 0           ) * 0            + 1           
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x00267e041ffcfdf8LL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation - ok except t1?
	details.InstallTexture = true;
	// RGB = Blend(T0, T1, EnvAlpha) * Shade
	// A   = 1
	details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGB);
}

// OoT intro
//case 0x00267e60350cf37fLL:
//aRGB0: (Texel1       - Primitive   ) * Env_Alpha    + Texel0      
//aA0  : (0            - 0           ) * 0            + Texel0      
//aRGB1: (Primitive    - Env         ) * Combined     + Env         
//aA1  : (Combined     - 0           ) * Primitive    + 0           
void BlendMode_0x00267e60350cf37fLL( BLEND_MODE_ARGS )
{
	// XXXX need 2nd texture
	details.InstallTexture = true;

	// XXXX need to blend using env

	details.ColourAdjuster.SetRGBA( details.PrimColour );
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// BK
//case 0x002698041f14ffffLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel0       - 0           ) * Shade        + 0           
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Env          + 0          
void BlendMode_0x002698041f14ffffLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	//XXXX assume 2 cytes
	details.ColourAdjuster.ModulateA( details.EnvColour );
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// TSph
//case 0x0026a0041f0c93ffLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel1       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Primitive    + 0           
void BlendMode_0x0026a0041f0c93ffLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	//XXXX placeholder

	details.ColourAdjuster.SetA( details.PrimColour );
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);			// in RGBA mode alpha = texture*diffuse fragment
}

// 007
//case 0x0026a0041f1093fbLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel1       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Shade        + Primitive   
void BlendMode_0x0026a0041f1093fbLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	//XXXX placeholder

	if( num_cycles == 1 )
	{
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
	else
	{
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);			// XXXX Need to add Prim alpha
	}
}

// AFA/007 - Gun/Bits
//case 0x0026a0041f1093ffLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel1       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Shade        + 0           
void BlendMode_0x0026a0041f1093ffLL( BLEND_MODE_ARGS )
{
	// XXXX need 2nd texture
	details.InstallTexture = true;
	if( num_cycles == 1 )
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	else
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// 007
//case 0x0026a0041f1493ffLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel1       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Env          + 0           
void BlendMode_0x0026a0041f1493ffLL( BLEND_MODE_ARGS )
{
	// XXXX need 2nd texture
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
	else
	{
		details.ColourAdjuster.SetA( details.EnvColour );
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
	}
}

// THPS
//case 0x0026a0041ffc93f8LL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel1       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x0026a0041ffc93f8LL( BLEND_MODE_ARGS )
{
	// XXXX need 2nd texture
	details.InstallTexture = true;
	if( num_cycles == 1 )
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	else
	{
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
	}
}

// 007 - Floor
//case 0x0026a0041ffc93fcLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel1       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Shade       
void BlendMode_0x0026a0041ffc93fcLL( BLEND_MODE_ARGS )
{
	// XXXX need 2nd texture
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
	else
	{
		details.ColourAdjuster.SetAOpaque();	// XXXX - hack Alpha 1.0 (should be coming from fog??)
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGB);
	}
}

//case 0x0026a0041ffc93fdLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (Texel1       - Texel0      ) * Combined     + Texel0      
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Env         
void BlendMode_0x0026a0041ffc93fdLL( BLEND_MODE_ARGS )
{
	// XXXX need 2nd texture
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
	else
	{
		details.ColourAdjuster.SetA( details.EnvColour );
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGB);
	}
}

// 007 - Mountains
//case 0x0026e4041ffcfffcLL:
//aRGB0: (Texel1       - Texel0      ) * LOD_Frac     + Texel0      
//aA0  : (1            - 0           ) * Texel1       + 0           
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Shade
void BlendMode_0x0026e4041ffcfffcLL( BLEND_MODE_ARGS )
{
	// XXXX need 2nd texture
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0		XXXX Need to modulate with t1 alpha
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGB);
	}
	else
	{
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
		sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGB);
	}
}

// RR64
//case 0x00272c041ffc93f8LL:
//aRGB0: (Texel1       - Texel0      ) * PrimLODFrac  + Texel0
//aA0  : (Texel1       - Texel0      ) * 1            + Texel0
//aRGB1: (Combined     - 0           ) * Shade        + 0
//aA1  : (0            - 0           ) * 0            + Combined
void BlendMode_0x00272c041ffc93f8LL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
	else
	{
		details.ColourAdjuster.SetAOpaque();	// Alpha 1.0
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	}
}

// Zelda OoT logo flames
//case 0x00272c60350ce37fLL:
//aRGB0: (Texel1       - Primitive   ) * PrimLODFrac  + Texel0      
//aA0  : (Texel1       - 1           ) * 1            + Texel0      
//aRGB1: (Primitive    - Env         ) * Combined     + Env         
//aA1  : (Combined     - 0           ) * Primitive    + 0           
void BlendMode_0x00272c60350ce37fLL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation
	details.InstallTexture = true;

	if( num_cycles == 1 )
	{
		// RGB = T0 + x(T1-Prim)
		// A   = T0+T1-1
		sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);		// XXXX No T1
	}
	else
	{
		// RGB = Blend(Env, Prim, (T0 + x(t1-Prim)))
		// A   = (T0+T1-1)*Prim
		details.ColourAdjuster.SetRGB( details.EnvColour );
		details.ColourAdjuster.SetA( details.PrimColour  );

		sceGuTexEnvColor( details.PrimColour.GetColour() );
		sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);		// XXXX No T1

	}
}

// XWP
//case 0x00309661552efb7dLL:
//aRGB0: (Primitive    - Env         ) * Texel0       + Env         
//aA0  : (Texel0       - 0           ) * Primitive    + Env         
//aRGB1: (Primitive    - Env         ) * Texel0       + Env         
//aA1  : (Texel0       - 0           ) * Primitive    + Env         
void BlendMode_0x00309661552efb7dLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	// RGB = Blend( Env, Primitive, T0 )
	// A   = T0 * Primitive + Env
	details.ColourAdjuster.SetRGB( details.EnvColour );
	details.ColourAdjuster.SetA( details.PrimColour );
	sceGuTexEnvColor( details.PrimColour.GetColour() );
	sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);			// _RGBA = blend(e,p,t) for RGB, Modulate(t,p) for alpha

	// XXXX need to add in Env for alpha
}

//case 0x0030b2045ffefff8LL:
//aRGB0: (Primitive    - Env         ) * Texel0       + Env         
//aA0  : (Primitive    - 0           ) * Texel0       + 0           
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x0030b2045ffefff8LL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation - correct for 1 cycle?
	details.InstallTexture = true;

	// Use Env for RGB, Prim for A
	details.ColourAdjuster.SetRGB( details.EnvColour );
	details.ColourAdjuster.SetA( details.PrimColour );

	sceGuTexEnvColor( details.PrimColour.GetColour() );

	if( num_cycles == 1 )
	{
		// RGB = Blend(Env,Prim,T0)
		// A   = Prim * T0
	}
	else
	{
		// RGB = Blend(Env,Prim,T0) * Shade
		// A   = Prim * T0

		// Can't handle shade for second cycle :(
	}
	sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);	// _RGBA modulate
}

//case 0x0030b26144664924LL:
//aRGB0: (Primitive    - Shade       ) * Texel0       + Shade       
//aA0  : (Primitive    - Shade       ) * Texel0       + Shade       
//aRGB1: (Primitive    - Shade       ) * Texel0       + Shade       
//aA1  : (Primitive    - Shade       ) * Texel0       + Shade       
void BlendMode_0x0030b26144664924LL( BLEND_MODE_ARGS )
{
	// Modulate the texture*shade for RGBA
	details.InstallTexture = true;
	sceGuTexEnvColor( details.PrimColour.GetColour() );
	sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGB);			// XXXX Argh - need to interpolate alpha too!? We're just selecting Shade for now
}

// RR64
//case 0x0030b2615566db6dLL:
//aRGB0: (Primitive    - Env         ) * Texel0       + Env
//aA0  : (Primitive    - Env         ) * Texel0       + Env
//aRGB1: (Primitive    - Env         ) * Texel0       + Env
//aA1  : (Primitive    - Env         ) * Texel0       + Env
void BlendMode_0x0030b2615566db6dLL( BLEND_MODE_ARGS )
{
	// Modulate the texture*shade for RGBA
	details.InstallTexture = true;
	details.ColourAdjuster.SetRGB( details.EnvColour );
	details.ColourAdjuster.SetA( details.PrimColour );
	sceGuTexEnvColor( details.PrimColour.GetColour() );
	sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);			// XXXX Argh - need to interpolate alpha too!? We're just doing modulate(t,prim) for now
}

// SpM/RR64
//case 0x0030b3ff5ffeda38LL:
//aRGB0: (Primitive    - Env         ) * Texel0       + Env         
//aA0  : (Primitive    - Env         ) * Texel0       + Env         
//aRGB1: (0            - 0           ) * 0            + Combined    
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x0030b3ff5ffeda38LL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	// RGB = Blend( Env, Primitive, T0 )
	// A   = T0 * Primitive
	details.ColourAdjuster.SetRGB( details.EnvColour );
	details.ColourAdjuster.SetA( details.PrimColour );
	sceGuTexEnvColor( details.PrimColour.GetColour() );
	// XXXX Needs to BLEND alpha values!
	sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);			// _RGBA = blend(e,p,t) for RGB, Modulate(t,p) for alpha
}

// RR64
//case 0x0030fe045ffef3f8LL:
//aRGB0: (Primitive    - Env         ) * Texel0       + Env
//aA0  : (0            - 0           ) * 0            + Texel0
//aRGB1: (Combined     - 0           ) * Shade        + 0
//aA1  : (0            - 0           ) * 0            + Combined
void BlendMode_0x0030fe045ffef3f8LL( BLEND_MODE_ARGS )
{
	//RGB: INEXACT = ( Shade * blend(Env,Prim,Texel0) )
	//Alpha: Texel0
	details.InstallTexture = true;
	if( num_cycles == 1 )
	{
		// Correct
		details.ColourAdjuster.SetRGB( details.EnvColour );
		details.ColourAdjuster.SetAOpaque();
		sceGuTexEnvColor( details.PrimColour.GetColour() );
		sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);			// _RGBA = blend(e,p,t) for RGB, Modulate(t,1) for alpha
	}
	else
	{
		// Needs to be modulated with shade
		details.ColourAdjuster.SetRGB( details.EnvColour );
		details.ColourAdjuster.SetAOpaque();
		sceGuTexEnvColor( details.PrimColour.GetColour() );
		sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);			// _RGBA = blend(e,p,t) for RGB, Modulate(t,1) for alpha
	}
}

// RR64
//case 0x0040b467f0fffe3eLL:
//aRGB0: (Shade        - 0           ) * Texel0       + 0
//aA0  : (Primitive    - 0           ) * Texel1       + 0
//aRGB1: (Primitive    - Combined    ) * CombAlp      + Combined
//aA1  : (0            - 0           ) * 0            + 1
void BlendMode_0x0040b467f0fffe3eLL( BLEND_MODE_ARGS )
{
	// Assuming this is always 2 cycles
	//RGB: INEXACT = blend(( Texel0 * Shade ),Prim,(T0a*T1a))
	//Alpha: 1
	details.InstallTexture = true;
	details.ColourAdjuster.ModulateRGB( details.PrimColour );
	details.ColourAdjuster.SetAOpaque();
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// THPS
//case 0x005094023f15ffffLL:
//aRGB0: (Env          - Primitive   ) * Texel0       + Primitive   
//aA0  : (Texel0       - 0           ) * Texel1       + 0           
//aRGB1: (Combined     - 0           ) * Texel1       + 0           
//aA1  : (Combined     - 0           ) * Env          + 0           
void BlendMode_0x005094023f15ffffLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	// XXXX Needs T1
	if( num_cycles == 1 )
	{
		// RGB = Blend( Primitive, Env, T0 )
		// A   = T0 * T1
		details.ColourAdjuster.SetRGB( details.PrimColour );
		details.ColourAdjuster.SetAOpaque();
		sceGuTexEnvColor( details.EnvColour.GetColour() );
		sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);			// _RGBA = blend(p,e,t) for RGB, T0*1 for alpha
	}
	else
	{
		// RGB = Blend( Primitive, Env, T0 )
		// A   = T0 * T1 * Env
		details.ColourAdjuster.SetRGB( details.PrimColour );
		details.ColourAdjuster.SetA( details.EnvColour );
		sceGuTexEnvColor( details.EnvColour.GetColour() );
		sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);			// _RGBA = blend(p,e,t) for RGB, T0*Env for alpha
	}
}

// AFA
//case 0x00627fff1ffcfc38LL:
//aRGB0: (1            - Texel0      ) * Shade        + Texel0      
//aA0  : (0            - 0           ) * 0            + 1           
//aRGB1: (0            - 0           ) * 0            + Combined    
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x00627fff1ffcfc38LL( BLEND_MODE_ARGS )
{
	// RGB = Blend( T0, 1, Shade )
	// A   = 1
	details.InstallTexture = true;

	details.ColourAdjuster.SetAOpaque();	// Alpha 1.0

	// XXXX this is just selecting the texture colour, ignoring the blend
	// Could do this by manually shading texture...

	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGB);
}

// BK
//case 0x0062fe043f15f9ffLL:
//aRGB0: (1            - Primitive   ) * Env          + Primitive   
//aA0  : (0            - 0           ) * 0            + Shade       
//aRGB1: (Combined     - 0           ) * Shade        + 0           
//aA1  : (Combined     - 0           ) * Env          + 0           
void BlendMode_0x0062fe043f15f9ffLL( BLEND_MODE_ARGS )
{
	c32		blend( details.PrimColour.Interpolate( c32::White, details.EnvColour ) );

	if( num_cycles == 1 )
	{
		details.ColourAdjuster.SetRGB( blend );
	}
	else
	{
		details.ColourAdjuster.ModulateRGB( blend );
		details.ColourAdjuster.ModulateA( details.EnvColour );
	}
}

// BK
//case 0x00ff95fffffcfe38LL:
//aRGB0: (0            - 0           ) * 0            + Texel0      
//aA0  : (Texel0       - 0           ) * Texel1       + 0           
//aRGB1: (0            - 0           ) * 0            + Combined    
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x00ff95fffffcfe38LL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	// XXXX needs t1 in alpha
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
}

// XWP
//case 0x00ff97ffff2cfa7dLL:
//aRGB0: (0            - 0           ) * 0            + Texel0      
//aA0  : (Texel0       - 0           ) * Primitive    + Env         
//aRGB1: (0            - 0           ) * 0            + Texel0      
//aA1  : (Texel0       - 0           ) * Primitive    + Env         
void BlendMode_0x00ff97ffff2cfa7dLL( BLEND_MODE_ARGS )
{
	details.InstallTexture = true;
	details.ColourAdjuster.SetRGB( c32::White );
	details.ColourAdjuster.SetA( details.PrimColour );

	// XXXX need to add in Env to alpha
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// SFR
//case 0x00ffabfffffc9238LL:
//aRGB0: (0            - 0           ) * 0            + Texel0
//aA0  : (Texel1       - Texel0      ) * Env          + Texel0
//aRGB1: (0            - 0           ) * 0            + Combined
//aA1  : (0            - 0           ) * 0            + Combined
void BlendMode_0x00ffabfffffc9238LL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation - needs t1
	// RGB = T0
	// A   =  blend(Texel0,Texel1,Env)
	details.InstallTexture = true;
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
}

// OoT, letters
//case 0x00ffadfffffd9238LL:
//aRGB0: (0            - 0           ) * 0            + Primitive   
//aA0  : (Texel1       - Texel0      ) * 1            + Texel0      
//aRGB1: (0            - 0           ) * 0            + Combined    
//aA1  : (0            - 0           ) * 0            + Combined    
void BlendMode_0x00ffadfffffd9238LL( BLEND_MODE_ARGS )
{
	// XXXX placeholder implementation - needs t1
	// RGB = Prim
	// A   = (T1-T0)+T0 = T1
	details.InstallTexture = true;
	details.RecolourTextureWhite = true;
	details.ColourAdjuster.SetRGB( details.PrimColour );		// Want to select texture alpha
	details.ColourAdjuster.SetAOpaque();
	sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
}

// CV
//case 0x00ffd5fffffcf238LL:
//aRGB0: (0            - 0           ) * 0            + Texel0      
//aA0  : (Env          - 0           ) * Texel1       + Texel0      
//aRGB1: (0            - 0           ) * 0            + Combined    
//aA1  : (0            - 0           ) * 0            + Combined 
void BlendMode_0x00ffd5fffffcf238LL( BLEND_MODE_ARGS )
{
	// XXXX needs Env*T1 for alpha
	details.InstallTexture = true;
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
}


OverrideBlendModeFn		LookupOverrideBlendModeFunction( u64 mux )
{
	switch(mux)
	{
#define BLEND_MODE( x )		case (x):	return BlendMode_##x;

        BLEND_MODE( 0x00111404ff13ffffLL );
        BLEND_MODE( 0x00117e045ffef3f8LL );
		BLEND_MODE( 0x0011ffff2ffd7c38LL );
		BLEND_MODE( 0x00121603ff5bfff8LL );
		BLEND_MODE( 0x00127244ffffec38LL );
		BLEND_MODE( 0x00127e2433fdf8fcLL );
		BLEND_MODE( 0x001298043f15ffffLL );
		BLEND_MODE( 0x00147e2844fe7b3dLL );
		BLEND_MODE( 0x001598045ffedbf8LL );
		BLEND_MODE( 0x00167e2c33fdf6fbLL );
		BLEND_MODE( 0x00167e6035fcff7eLL );
		BLEND_MODE( 0x001690031f0c93ffLL );
		BLEND_MODE( 0x0022aa041f0c93ffLL );
		BLEND_MODE( 0x002527ff1ffc9238LL );
		BLEND_MODE( 0x00262a60150c937fLL );
		BLEND_MODE( 0x00267e041f0cfdffLL );
		BLEND_MODE( 0x00267e041ffcfdf8LL );
		BLEND_MODE( 0x00267e60350cf37fLL );
		BLEND_MODE( 0x002698041f14ffffLL );
		BLEND_MODE( 0x0026a0041f0c93ffLL );
		BLEND_MODE( 0x0026a0041f1093fbLL );
		BLEND_MODE( 0x0026a0041f1093ffLL );
		BLEND_MODE( 0x0026a0041f1493ffLL );
		BLEND_MODE( 0x0026a0041ffc93f8LL );
		BLEND_MODE( 0x0026a0041ffc93fcLL );
		BLEND_MODE( 0x0026a0041ffc93fdLL );
        BLEND_MODE( 0x0026e4041ffcfffcLL );
        BLEND_MODE( 0x00272c041ffc93f8LL );
		BLEND_MODE( 0x00272c60350ce37fLL );
		BLEND_MODE( 0x00309661552efb7dLL );
		BLEND_MODE( 0x0030b2045ffefff8LL );
		BLEND_MODE( 0x0030b26144664924LL );
	    BLEND_MODE( 0x0030b2615566db6dLL );
		BLEND_MODE( 0x0030b3ff5ffeda38LL );
        BLEND_MODE( 0x0030fe045ffef3f8LL );
        BLEND_MODE( 0x0040b467f0fffe3eLL );
		BLEND_MODE( 0x005094023f15ffffLL );
		BLEND_MODE( 0x00627fff1ffcfc38LL );
		BLEND_MODE( 0x0062fe043f15f9ffLL );
		BLEND_MODE( 0x00ff95fffffcfe38LL );
		BLEND_MODE( 0x00ff97ffff2cfa7dLL );
        BLEND_MODE( 0x00ffabfffffc9238LL );
		BLEND_MODE( 0x00ffadfffffd9238LL );
		BLEND_MODE( 0x00ffd5fffffcf238LL );

#undef BLEND_MODE
	}

	return NULL;
}
