
#define TEST_DISABLE_MATH_FUNCS //return PATCH_RET_NOT_PROCESSED;


u32 Patch___ll_mul()
{
TEST_DISABLE_MATH_FUNCS
	u32 dwHiA = gGPR[REG_a0]._u32[0];
	u32 dwLoA = gGPR[REG_a1]._u32[0];
	u32 dwHiB = gGPR[REG_a2]._u32[0];
	u32 dwLoB = gGPR[REG_a3]._u32[0];

	u64 qwA = ((u64)dwHiA << 32) | (u64)dwLoA;
	u64 qwB = ((u64)dwHiB << 32) | (u64)dwLoB;

	u64 qwR = qwA * qwB;

	gGPR[REG_v0]._s64 = (s64)qwR >> 32;
	gGPR[REG_v1]._s64 = (s64)(s32)(qwR & 0xFFFFFFFF);

	return PATCH_RET_JR_RA;
}


// By Jun Su
u32 Patch___ll_div() 
{ 
TEST_DISABLE_MATH_FUNCS
	s64 op1, op2, result; 
	
	// Fixed by  StrmnNrmn - regs cast to 32 bits so shift didn't work
	// This was breaking 007
	op1 = (s64)((u64)gGPR[REG_a0]._u32[0] << 32 | (u64)gGPR[REG_a1]._u32[0]); 
	op2 = (s64)((u64)gGPR[REG_a2]._u32[0] << 32 | (u64)gGPR[REG_a3]._u32[0]); 
	
	if (op2==0) 
	{ 
		return PATCH_RET_NOT_PROCESSED; 
	} 
	else 
	{ 
		result = op1 / op2; 
		// StrmnNrmn - the s32 casts were originally u32. Not sure if this is needed
		gGPR[REG_v1]._s64 = (s64)(s32)(result & 0xffffffff); 
		gGPR[REG_v0]._s64 = (s64)(s32)(result>>32); 
		return PATCH_RET_JR_RA; 
	} 
} 

// By Jun Su
u32 Patch___ull_div() 
{ 
TEST_DISABLE_MATH_FUNCS
	u64 op1, op2, result; 
	
	// Fixed by  StrmnNrmn - regs cast to 32 bits so shift didn't work
	op1 = (u64)((u64)gGPR[REG_a0]._u32[0] << 32 | (u64)gGPR[REG_a1]._u32[0]); 
	op2 = (u64)((u64)gGPR[REG_a2]._u32[0] << 32 | (u64)gGPR[REG_a3]._u32[0]); 
	
	if (op2==0) 
	{ 
		return PATCH_RET_NOT_PROCESSED; 
	} 
	else 
	{ 
		result = op1 / op2; 
		// StrmnNrmn - the s32 casts were originally u32. Not sure if this is needed
		gGPR[REG_v1]._s64 = (s64)(s32)(result & 0xffffffff); 
		gGPR[REG_v0]._s64 = (s64)(s32)(result>>32); 
		return PATCH_RET_JR_RA; 
	} 
} 


// By Jun Su
u32 Patch___ull_rshift() 
{ 
TEST_DISABLE_MATH_FUNCS
	u64 op1, op2, result; 
	
	// Fixed by  StrmnNrmn - regs cast to 32 bits so shift didn't work
	op1 = (u64)((u64)gGPR[REG_a0]._u32[0] << 32 | (u64)gGPR[REG_a1]._u32[0]); 
	op2 = (u64)((u64)gGPR[REG_a2]._u32[0] << 32 | (u64)gGPR[REG_a3]._u32[0]); 
	
	result = op1 >> op2; 
	// StrmnNrmn - the s32 casts were originally u32. Not sure if this is needed
	gGPR[REG_v1]._s64 = (s64)(s32)(result & 0xffffffff); 
	gGPR[REG_v0]._s64 = (s64)(s32)(result>>32); 
	return PATCH_RET_JR_RA; 
} 

// By Jun Su
u32 Patch___ll_lshift() 
{ 
TEST_DISABLE_MATH_FUNCS
	s64 op1, result; 
	u64 op2; 

	// Fixed by  StrmnNrmn - regs cast to 32 bits so shift didn't work
	op1 = (s64)((u64)gGPR[REG_a0]._u32[0] << 32 | (u64)gGPR[REG_a1]._u32[0]); 
	op2 = (u64)((u64)gGPR[REG_a2]._u32[0] << 32 | (u64)gGPR[REG_a3]._u32[0]); 
	
	result = op1 << op2; 
	// StrmnNrmn - the s32 casts were originally u32. Not sure if this is needed
	gGPR[REG_v1]._s64 = (s64)(s32)(result & 0xffffffff); 
	gGPR[REG_v0]._s64 = (s64)(s32)(result>>32); 
	return PATCH_RET_JR_RA; 
} 


// By Jun Su
u32 Patch___ll_rshift() 
{ 
TEST_DISABLE_MATH_FUNCS
	s64 op1, result; 
	u64 op2; 
	
	// Fixed by  StrmnNrmn - regs cast to 32 bits so shift didn't work
	op1 = (s64)((u64)gGPR[REG_a0]._u32[0] << 32 | (u64)gGPR[REG_a1]._u32[0]); 
	op2 = (u64)((u64)gGPR[REG_a2]._u32[0] << 32 | (u64)gGPR[REG_a3]._u32[0]); 
	
	result = op1 >> op2; 
	// StrmnNrmn - the s32 casts were originally u32. Not sure if this is needed
	gGPR[REG_v1]._s64 = (s64)(s32)(result & 0xffffffff); 
	gGPR[REG_v0]._s64 = (s64)(s32)(result>>32); 
	return PATCH_RET_JR_RA; 
} 

// By Jun Su
u32 Patch___ll_mod() 
{ 
TEST_DISABLE_MATH_FUNCS
	s64 op1, op2, result; 
	
	// Fixed by  StrmnNrmn - regs cast to 32 bits so shift didn't work
	op1 = (s64)((u64)gGPR[REG_a0]._u32[0] << 32 | (u64)gGPR[REG_a1]._u32[0]); 
	op2 = (s64)((u64)gGPR[REG_a2]._u32[0] << 32 | (u64)gGPR[REG_a3]._u32[0]); 
	
	if (op2==0) 
	{ 
		return PATCH_RET_NOT_PROCESSED; 
	} 
	else 
	{ 
		result = op1 % op2; 
		// StrmnNrmn - the s32 casts were originally u32. Not sure if this is needed
		gGPR[REG_v1]._s64 = (s64)(s32)(result & 0xffffffff); 
		gGPR[REG_v0]._s64 = (s64)(s32)(result>>32); 
		return PATCH_RET_JR_RA; 
	} 
} 





u32 Patch_sqrtf()
{
TEST_DISABLE_MATH_FUNCS
	f32 f = ToFloat(g_qwCPR[1][12]);
	ToFloat(g_qwCPR[1][00]) = sqrtf(f);
	return PATCH_RET_JR_RA;
}



u32 Patch_sinf()
{
TEST_DISABLE_MATH_FUNCS
	// FP12 is input
	// FP00 is output
	f32 f = ToFloat(g_qwCPR[1][12]);

	f32 r = sinf(f);

	//DBGConsole_Msg(0, "sinf(%f) = %f (ra 0x%08x)", f, r, (u32)gGPR[REG_ra]);

	ToFloat(g_qwCPR[1][00]) = r;

/*	g_dwNumCosSin++;
	if ((g_dwNumCosSin % 100000) == 0)
	{
		DBGConsole_Msg(0, "%d sin/cos calls intercepted", g_dwNumCosSin);
	}*/
	return PATCH_RET_JR_RA;

}
u32 Patch_cosf()
{
TEST_DISABLE_MATH_FUNCS
	// FP12 is input
	// FP00 is output
	f32 f = ToFloat(g_qwCPR[1][12]);

	f32 r = cosf(f);

	//DBGConsole_Msg(0, "cosf(%f) = %f (ra 0x%08x)", f, r, (u32)gGPR[REG_ra]);

	ToFloat(g_qwCPR[1][00]) = r;

/*	g_dwNumCosSin++;
	if ((g_dwNumCosSin % 100000) == 0)
	{
		DBGConsole_Msg(0, "%d sin/cos calls intercepted", g_dwNumCosSin);
	}*/
	return PATCH_RET_JR_RA;

}
