#define SR_MATH_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_MATH_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_MATH		//return FALSE;

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_MFHI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D(rd);
	
	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_MFHI);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateMFHI( rd );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_MFLO(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D(rd);
	
	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_MFLO);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateMFLO( rd );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_MULTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_MULTU);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateMULTU( rs, rt );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_ADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	// Ignore exceptions - just use unsigned routine
	return SR_Emit_Special_ADDU(pCode, op_code, p_flags);
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_ADDU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH

	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_ADDU);
	}
	else
	{
		pCode->dwNumOptimised++;

		if (rd == 0) return TRUE;	// Don't clear r0

		pCode->mpCodeGenerator->GenerateADDU( rd, rs, rt );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_SUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	// Ignore exceptions - just use unsigned routine
	return SR_Emit_Special_SUBU(pCode,op_code, p_flags);
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_SUBU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH

	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SUBU);
	}
	else
	{
		pCode->dwNumOptimised++;

		if (rd == 0) return TRUE;	// Don't clear r0

		pCode->mpCodeGenerator->GenerateSUBU( rd, rs, rt );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_AND(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH

	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_AND);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Don't write to r0
		if (rd == 0) return TRUE;	// Don't clear r0

		pCode->mpCodeGenerator->GenerateAND( rd, rs, rt );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_OR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);


	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_OR);
	}
	else
	{

		pCode->dwNumOptimised++;

		// Don't write to r0
		if (rd == 0) return TRUE;	// Don't clear r0

		pCode->mpCodeGenerator->GenerateOR( rd, rs, rt );
	}
	return TRUE;

}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_XOR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);


	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_XOR);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Don't write to r0
		if (rd == 0) return TRUE;	// Don't clear r0

		pCode->mpCodeGenerator->GenerateXOR( rd, rs, rt );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_NOR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_NOR);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Don't write to r0
		if (rd == 0) return TRUE;	// Don't clear r0

		pCode->mpCodeGenerator->GenerateNOR( rd, rs, rt );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_SLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH

	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SLT);
	}
	else
	{
		pCode->dwNumOptimised++;

		if (rd == 0) return TRUE;		// Don't set r0

		pCode->mpCodeGenerator->GenerateSLT( rd, rs, rt );
	}
	
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_SLTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_MATH
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	if (SR_MATH_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SLTU);
	}
	else
	{
		pCode->dwNumOptimised++;

		if (rd == 0) return TRUE;		// Don't set r0

		pCode->mpCodeGenerator->GenerateSLTU( rd, rs, rt );
	}

	return TRUE;
}
