#define SR_COP1_D_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_COP1_D_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_COP1_D		//return FALSE;

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_ADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S_S(reg_fd, reg_fs, reg_ft);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs+ft
		pCode->mpCodeGenerator->GenerateADD_D( reg_fd, reg_fs, reg_ft );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_SUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S_S(reg_fd, reg_fs, reg_ft);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs-ft
		pCode->mpCodeGenerator->GenerateSUB_D( reg_fd, reg_fs, reg_ft );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_MUL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S_S(reg_fd, reg_fs, reg_ft);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs*ft
		pCode->mpCodeGenerator->GenerateMUL_D( reg_fd, reg_fs, reg_ft );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_DIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S_S(reg_fd, reg_fs, reg_ft);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs/ft
		pCode->mpCodeGenerator->GenerateDIV_D( reg_fd, reg_fs, reg_ft );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_SQRT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S(reg_fd, reg_fs);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = sqrtf(fs)
		pCode->mpCodeGenerator->GenerateSQRT_D( reg_fd, reg_fs );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_ABS(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S(reg_fd, reg_fs);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_MOV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S(reg_fd, reg_fs);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs
		pCode->mpCodeGenerator->GenerateMOV_D( reg_fd, reg_fs );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_NEG(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_D_S(reg_fd, reg_fs);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = -fs
		pCode->mpCodeGenerator->GenerateNEG_D( reg_fd, reg_fs );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_ROUND_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_TRUNC_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_CEIL_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_FLOOR_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_ROUND_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_TRUNC_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	//if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	/*else
	{
		pCode->dwNumOptimised++;

		// TODO: This should really TRUNC
		// This does the same as R4300.cpp, but it's possibly wrong
		SR_FP_D_CVT_W(reg_fd, reg_fs);
	}*/


	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_CEIL_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_FLOOR_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_CVT_S(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Single_D(reg_fd);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateCVT_S_D( reg_fd, reg_fs );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
// TODO: There is a bug in SR_DP_D_CVT_W that causes the fades in mario to flash
BOOL SR_Emit_Cop1_D_CVT_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	//if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	/*else
	{
		pCode->dwNumOptimised++;

		SR_FP_D_CVT_W(reg_fd, reg_fs);
	}*/

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_CVT_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Double_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_F(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_UN(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_EQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	
	pCode->Stat_Double_S_S(reg_fs, reg_ft);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs <= ft?
		pCode->mpCodeGenerator->GenerateCompare_D( reg_fs, reg_ft, FLAG_C_EQ );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_UEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_OLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_ULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_OLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_ULE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_SF(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_NGLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_SEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_NGL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_LT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	
	pCode->Stat_Double_S_S(reg_fs, reg_ft);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs < ft?
		pCode->mpCodeGenerator->GenerateCompare_D(reg_fs, reg_ft, FLAG_C_LT);
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_NGE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_LE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	
	pCode->Stat_Double_S_S(reg_fs, reg_ft);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs <= ft?
		pCode->mpCodeGenerator->GenerateCompare_D(reg_fs, reg_ft, FLAG_C_LE);
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_D_NGT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_GetInstructionHandler( op_code ));
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
// Notice source is Word, dest is double!
BOOL SR_Emit_Cop1_W_CVT_D(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_D
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	//pCode->Stat_Word_S(reg_fs);
	//pCode->Stat_Double_D(reg_fd);
	pCode->Stat_Double_D_S(reg_fd, reg_fs);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_W_CVT_D);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateCVT_D_W( reg_fd, reg_fs );
	}

	return TRUE;
}
