/*
Copyright (C) 2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DYNARECINTERNAL_H_
#define DYNARECINTERNAL_H_

#include "Core\R4300.h"
#include "Core\CPU.h"

#include "DynarecCode.h"

class CCodeGeneratorX86;

#define SR_FLAGS_BRANCHES			0x00000001
#define SR_FLAGS_BRANCHES_TO_START	0x00000002
#define SR_FLAGS_HANDLE_BRANCH		0x00000004

void	SR_Emit_Generic_R4300(CDynarecCode *pCode, OpCode op_code, CPU_Instruction pF);

// Get the lo and high half indices for MIPS registers
#define lohalf(x)		(x*2 + 0)
#define hihalf(x)		(x*2 + 1)


inline u8 *	GetRegisterAddressLo( u32 mreg )
{
	return ((u8 *)&gGPR[0]) + (lohalf(mreg)*4);

	// gGPR[mreg]._u32[0];
}

inline u8 *	GetRegisterAddressHi( u32 mreg )
{
	return ((u8 *)&gGPR[0]) + (hihalf(mreg)*4);

	// gGPR[mreg]._u32[1];
}



#endif // DYNARECINTERNAL_H_
