#include "stdafx.h"
#include "DynaRecInstructions.h"
#include "DynaRec.h"
#include "DynaRecTables.h"
#include "DynaRecInternal.h"
#include "CodeGenerator.h"

#include "Debug\Debug.h"
#include "Debug\DBGConsole.h"

#include "Core\R4300.h"

#include "Core\Registers.h"			// For REG_?? / RegNames

#include "OSHLE\ultra_R4300.h"

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	return FALSE;
}

BOOL SR_Emit_DBG_BreakPoint(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
#ifdef DAEDALUS_BREAKPOINTS_ENABLED
	DWORD dwBreakPoint = op_code.bp_index;

	op_code = g_BreakPoints[dwBreakPoint].mOriginalOp;
	// Use the original opcode
	return SR_EmitInstruction[op_code.op](pCode, op_code, p_flags);
#else

	return FALSE;
#endif
}


BOOL SR_Emit_SRHack_UnOpt(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	CDynarecCode * pcode( DynaRec_GetEntry( op_code.dynarec_index ) );
	if (pcode == NULL)
	{
		DBGConsole_Msg(0, "No compiled code here!.");
		return FALSE;
	}

	op_code = pcode->mOriginalOp;

	// Recurse, using the original opcode
	return SR_EmitInstruction[op_code.op](pCode, op_code, p_flags);
}

BOOL SR_Emit_SRHack_Opt(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	CDynarecCode * pcode( DynaRec_GetEntry( op_code.dynarec_index ) );
	if (pcode == NULL)
	{
		DBGConsole_Msg(0, "No compiled code here!.");
		return FALSE;
	}

	op_code = pcode->mOriginalOp;

	// Recurse, using the original opcode
	return SR_EmitInstruction[op_code.op](pCode, op_code, p_flags);
}


BOOL SR_Emit_SRHack_NoOpt(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	CDynarecCode * pcode( DynaRec_GetEntry( op_code.dynarec_index ) );

	op_code = pcode->mOriginalOp;
	// Recurse, using the original opcode
	return SR_EmitInstruction[op_code.op](pCode, op_code, p_flags);
}

BOOL SR_Emit_Special(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	return SR_EmitSpecialInstruction[op_code.spec_op](pCode, op_code, p_flags);
}

BOOL SR_Emit_RegImm(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	return SR_EmitRegImmInstruction[op_code.regimm_op](pCode, op_code, p_flags);
}

BOOL SR_Emit_CoPro0(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	return SR_EmitCop0Instruction[op_code.cop0_op](pCode, op_code, p_flags);
}

BOOL SR_Emit_CoPro1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{ 
	return SR_EmitCop1Instruction[op_code.cop1_op](pCode, op_code, p_flags);
}


#include "dr_branch.inl"
#include "dr_cop1.inl"
#include "dr_cop1_s.inl"
#include "dr_cop1_d.inl"
#include "dr_load.inl"
#include "dr_math.inl"
#include "dr_math_imm.inl"
#include "dr_store.inl"


BOOL SR_Emit_LL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_LLD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_LDC2(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_SC(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_SCD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_SDC2(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }




BOOL SR_Emit_BEQL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// We can't execute this op yet, as we need to ensure that dwPC is set correctly
	// if branch is not taken
	return FALSE;

}
BOOL SR_Emit_BNEL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// We can't execute this op yet, as we need to ensure that dwPC is set correctly
	// if branch is not taken
	return FALSE;
}

BOOL SR_Emit_BLEZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// We can't execute this op yet, as we need to ensure that dwPC is set correctly
	// if branch is not taken
	return FALSE;
}

BOOL SR_Emit_BGTZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// We can't execute this op yet, as we need to ensure that dwPC is set correctly
	// if branch is not taken
	return FALSE;
}



BOOL SR_Emit_DADDI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_DADDI);
	return TRUE;
}

BOOL SR_Emit_DADDIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_D_S(rt, rs);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_DADDIU);
	return TRUE;
}

BOOL SR_Emit_LDL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_LDL);
	return TRUE;
}


BOOL SR_Emit_LDR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_LDR);
	return TRUE;
}



BOOL SR_Emit_LWL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);


	SR_Emit_Generic_R4300(pCode, op_code, R4300_LWL);
	return TRUE;
}



BOOL SR_Emit_LWR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_LWR);
	return TRUE;
}

BOOL SR_Emit_LWU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_LWU);
	return TRUE;
}

BOOL SR_Emit_LD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_LD);
	return TRUE;
}



BOOL SR_Emit_SWL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_SWL);
	return TRUE;
}


BOOL SR_Emit_SDL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_SDL);
	return TRUE;
}

BOOL SR_Emit_SDR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_SDR);
	return TRUE;
}

BOOL SR_Emit_SWR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_SWR);
	return TRUE;
}

BOOL SR_Emit_CACHE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// Ignore	
	if (pCode->dwOptimiseLevel >= 1)
	{
		pCode->dwNumOptimised++;
	}

	return TRUE;
}





BOOL SR_Emit_SD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_SD);
	return TRUE;
}


////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////


BOOL SR_Emit_Special_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }


BOOL SR_Emit_Special_SLLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SLLV);
	return TRUE;
}

BOOL SR_Emit_Special_SRLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SRLV);
	return TRUE;
}

BOOL SR_Emit_Special_SRAV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_SRAV);
	return TRUE;
}

BOOL SR_Emit_Special_DSLLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSLLV);
	return TRUE;
}

BOOL SR_Emit_Special_DSRLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSRLV);
	return TRUE;
}

BOOL SR_Emit_Special_DSRAV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSRAV);
	return TRUE;
}


BOOL SR_Emit_Special_SYSCALL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Special_BREAK(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Special_SYNC(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }



// Move to MultHi/Lo is not very common
BOOL SR_Emit_Special_MTHI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_S(rs);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_MTHI);
	return TRUE;
}


BOOL SR_Emit_Special_MTLO(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_S(rs);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_MTLO);
	return TRUE;
}


BOOL SR_Emit_Special_MULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_MULT);
	return TRUE;
}



BOOL SR_Emit_Special_DIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DIV);
	return TRUE;
}


BOOL SR_Emit_Special_DIVU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DIVU);
	return TRUE;
}

BOOL SR_Emit_Special_DMULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DMULT);
	return TRUE;
}

BOOL SR_Emit_Special_DMULTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DMULTU);
	return TRUE;
}

BOOL SR_Emit_Special_DDIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DDIV);
	return TRUE;
}

BOOL SR_Emit_Special_DDIVU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S_S(rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DDIVU);
	return TRUE;
}

BOOL SR_Emit_Special_TGE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Special_TGEU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Special_TLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Special_TLTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Special_TEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Special_TNE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }






BOOL SR_Emit_Special_DSLL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	//const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSLL);
	return TRUE;
}

BOOL SR_Emit_Special_DSRL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	//const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSRL);
	return TRUE;
}

BOOL SR_Emit_Special_DSRA(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	//const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSRA);
	return TRUE;
}

BOOL SR_Emit_Special_DSLL32(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	//const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSLL32);
	return TRUE;
}

BOOL SR_Emit_Special_DSRL32(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	//const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSRL32);
	return TRUE;
}

BOOL SR_Emit_Special_DSRA32(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	//const u32 dwSA = op_code.sa;
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSRA32);
	return TRUE;
}

BOOL SR_Emit_Special_DADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DADD);
	return TRUE;
}

BOOL SR_Emit_Special_DADDU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DADDU);
	return TRUE;
}

BOOL SR_Emit_Special_DSUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSUB);
	return TRUE;
}

BOOL SR_Emit_Special_DSUBU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S_S(rd, rs, rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_DSUBU);
	return TRUE;
}






////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

BOOL SR_Emit_RegImm_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }

BOOL SR_Emit_RegImm_BLTZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_BGEZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }

BOOL SR_Emit_RegImm_TGEI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_TGEIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_TLTI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_TLTIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_TEQI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_TNEI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }

BOOL SR_Emit_RegImm_BLTZAL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_BGEZAL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_BLTZALL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_RegImm_BGEZALL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }

////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////

BOOL SR_Emit_Cop0_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }

BOOL SR_Emit_Cop0_MFC0(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// Don't emit is this is refering to COUNT, as it's not maintained
	// during the execution of recompiled code
	const EN64Reg rt = EN64Reg( op_code.rt );
	const u32 reg_fs = op_code.fs;

	//gGPR[rt] = (s64)(s32)g_qwCPR[0][reg_fs];

	switch (reg_fs)
	{
		case C0_COUNT:
			// Could emit instruction to set count here?
			return FALSE;
	}
	
	pCode->Stat_D(rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop0_MFC0);
	return TRUE;
}

BOOL SR_Emit_Cop0_MTC0(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){

	// Don't emit is this is refering to COUNT, as it's not maintained
	// during the execution of recompiled code
	const EN64Reg rt = EN64Reg( op_code.rt );
	const u32 reg_fs = op_code.fs;

	//g_qwCPR[0][reg_fs] = gGPR[rt];
	

	//return FALSE;

	switch (reg_fs)
	{
		case C0_COMPARE:
		case C0_COUNT:
			// Could emit instruction to set count here?
			return FALSE;
	}
	
	pCode->Stat_S(rt);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop0_MTC0);
	return TRUE;
}

BOOL SR_Emit_Cop0_TLB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////


BOOL SR_Emit_Cop1_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }

BOOL SR_Emit_Cop1_BCInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	return SR_EmitCop1BC1Instruction[ op_code.cop1_bc ](pCode, op_code, p_flags);
}

BOOL SR_Emit_Cop1_SInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	return SR_EmitCop1SInstruction[op_code.cop1_funct](pCode, op_code, p_flags);
}

BOOL SR_Emit_Cop1_DInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	return SR_EmitCop1DInstruction[op_code.cop1_funct](pCode, op_code, p_flags);
}

BOOL SR_Emit_Cop1_WInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	switch (op_code.cop1_funct)
	{
		case Cop1OpFunc_CVT_S:
		{
			return SR_Emit_Cop1_W_CVT_S(pCode, op_code, p_flags);
		}

		case Cop1OpFunc_CVT_D:
		{
			return SR_Emit_Cop1_W_CVT_D(pCode, op_code, p_flags);
		}
	}
	return FALSE;
}






BOOL SR_Emit_Cop1_LInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }


BOOL SR_BC1_BC1F(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	
	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_BC1_BC1F);
	return TRUE;
}

BOOL SR_BC1_BC1T(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	
	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_BC1_BC1T);
	return TRUE;
}

BOOL SR_BC1_BC1FL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// Can't yet execute Likely Instructions
	return FALSE;
	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_BC1_BC1FL);
	return TRUE;
}

BOOL SR_BC1_BC1TL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	// Can't yet execute Likely Instructions
	return FALSE;
	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_BC1_BC1TL);
	return TRUE;
}


////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////


BOOL SR_Emit_Cop1_S_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }
BOOL SR_Emit_Cop1_D_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags){ return FALSE; }




BOOL SR_Emit_Cop1_DMFC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const u32 reg_fs = op_code.fs;

	pCode->Stat_D(rt);
	pCode->Stat_Double_S(reg_fs);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_DMFC1);

	return TRUE;
}


BOOL SR_Emit_Cop1_DMTC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
	const EN64Reg rt = EN64Reg( op_code.rt );
	const u32 reg_fs = op_code.fs;

	pCode->Stat_S(rt);
	pCode->Stat_Double_D(reg_fs);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_DMTC1);
	return TRUE;
}
