/*
Copyright (C) 2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DYNARECFP_H_
#define DYNARECFP_H_

class CCodeGeneratorX86;

enum FPREG_TYPE
{
	FP_SINGLE, 
	FP_DOUBLE
};

void SR_FP_Init(CCodeGeneratorX86 * pCode);
void SR_FP_FlushAllRegs();
void SR_FP_StackPicture();
void SR_FP_ExchReg(DWORD dwSP1, DWORD dwSP2);
void SR_FP_LoadReg(u32 reg_fs, FPREG_TYPE nType);
void SR_FP_SaveReg(u32 reg_fs);
void SR_FP_DiscardReg(u32 reg_fs);
void SR_FP_EvictOldestRegister();
void SR_FP_PopValueOffStack(DWORD dwSI);
void SR_FP_PushRegs();
void SR_FP_PopRegs();
void SR_FP_Touch(u32 reg_fs);
void SR_FP_Prepare_D_S_S(u32 reg_fd, u32 reg_fs, u32 reg_ft, FPREG_TYPE nType);
void SR_FP_Prepare_D_S(u32 reg_fd, u32 reg_fs, FPREG_TYPE nType);
void SR_FP_Prepare_S_S(u32 reg_fs, u32 reg_ft, FPREG_TYPE nType);
void SR_FP_CopyRegToST0(u32 reg_fs);
void SR_FP_AssignToST0(u32 reg_fd, FPREG_TYPE nType);

void SR_FP_LWC1(u32 reg_fd);
void SR_FP_SWC1(u32 reg_fs);
void SR_FP_MFC1(u32 reg_fs);
void SR_FP_MTC1(u32 reg_fd);
void SR_FP_ADD(u32 reg_fd, u32 reg_fs, u32 reg_ft, FPREG_TYPE nType);
void SR_FP_SUB(u32 reg_fd, u32 reg_fs, u32 reg_ft, FPREG_TYPE nType);
void SR_FP_MUL(u32 reg_fd, u32 reg_fs, u32 reg_ft, FPREG_TYPE nType);
void SR_FP_DIV(u32 reg_fd, u32 reg_fs, u32 reg_ft, FPREG_TYPE nType);
void SR_FP_SQRT(u32 reg_fd, u32 reg_fs, FPREG_TYPE nType);
void SR_FP_NEG(u32 reg_fd, u32 reg_fs, FPREG_TYPE nType);
void SR_FP_MOV(u32 reg_fd, u32 reg_fs, FPREG_TYPE nType);
void SR_FP_C(u32 reg_fs, u32 reg_ft, WORD nFlag, FPREG_TYPE nType);

void SR_FP_S_CVT_D(u32 reg_fd, u32 reg_fs);
void SR_FP_D_CVT_S(u32 reg_fd, u32 reg_fs);
void SR_FP_W_CVT_S(u32 reg_fd, u32 reg_fs);
void SR_FP_W_CVT_D(u32 reg_fd, u32 reg_fs);
void SR_FP_S_CVT_W(u32 reg_fd, u32 reg_fs);

extern DWORD g_dwFPTimeNow;


#endif // DYNARECFP_H_
