/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "StdAfx.h"

#if 0

#include "DynarecCode.h"

#include "Core\Registers.h"

#include "OSHLE\ultra_r4300.h"


typedef bool (*AnalyseInstructionType)( CDynarecCode *pCode, OpCode op, u32 * p_flags );


static bool Analyse_Unk( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_DBG_BreakPoint( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SRHack_UnOpt( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SRHack_Opt( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SRHack_NoOpt( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_J( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_JAL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BEQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BNE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BLEZ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BGTZ( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_ADDI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_ADDIU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SLTI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SLTIU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_ANDI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_ORI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_XORI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LUI( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_CoPro0( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_CoPro1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BEQL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BNEL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BLEZL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BGTZL( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_DADDI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_DADDIU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LDL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LDR( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_LB( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LH( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LWL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LW( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LBU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LHU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LWR( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LWU( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_SB( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SH( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SWL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SW( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SDL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SDR( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SWR( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_CACHE( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_LL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LWC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LLD( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LDC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LDC2( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_LD( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_SC( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SWC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SCD( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SDC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SDC2( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_SD( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_Unk( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SLL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SRL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SRA( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SLLV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SRLV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SRAV( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_JR( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_JALR( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SYSCALL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_BREAK( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SYNC( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_MFHI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_MTHI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_MFLO( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_MTLO( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSLLV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSRLV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSRAV( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_MULT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_MULTU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DIV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DIVU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DMULT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DMULTU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DDIV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DDIVU( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_ADD( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_ADDU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SUB( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SUBU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_AND( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_OR( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_XOR( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_NOR( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_SLT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_SLTU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DADD( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DADDU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSUB( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSUBU( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_TGE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_TGEU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_TLT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_TLTU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_TEQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_TNE( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Special_DSLL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSRL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSRA( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSLL32( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSRL32( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Special_DSRA32( CDynarecCode *pCode, OpCode op, u32 * p_flags );


static bool Analyse_RegImm_Unk( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_BLTZ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_BGEZ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_BLTZL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_BGEZL( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_RegImm_TGEI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_TGEIU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_TLTI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_TLTIU( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_TEQI( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_TNEI( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_RegImm_BLTZAL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_BGEZAL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_BLTZALL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_RegImm_BGEZALL( CDynarecCode *pCode, OpCode op, u32 * p_flags );


static bool Analyse_Cop0_Unk( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop0_MFC0( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop0_MTC0( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop0_TLB( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_Unk( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_MFC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_DMFC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_CFC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_MTC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_DMTC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_CTC1( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_BCInstr( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_SInstr( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_DInstr( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_WInstr( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_LInstr( CDynarecCode *pCode, OpCode op, u32 * p_flags );


static bool Analyse_BC1_BC1F( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BC1_BC1T( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BC1_BC1FL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_BC1_BC1TL( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_S_Unk( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_ADD( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_SUB( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_MUL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_DIV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_SQRT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_ABS( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_MOV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_NEG( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_S_ROUND_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_TRUNC_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_CEIL_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_FLOOR_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_ROUND_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_TRUNC_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_CEIL_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_FLOOR_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_S_CVT_D( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_CVT_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_CVT_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_S_F( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_UN( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_EQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_UEQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_OLT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_ULT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_OLE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_ULE( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_S_SF( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_NGLE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_SEQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_NGL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_LT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_NGE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_LE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_S_NGT( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_D_Unk( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_ADD( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_SUB( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_MUL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_DIV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_SQRT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_ABS( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_MOV( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_NEG( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_D_ROUND_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_TRUNC_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_CEIL_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_FLOOR_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_ROUND_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_TRUNC_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_CEIL_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_FLOOR_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_D_CVT_S( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_CVT_W( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_CVT_L( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_D_F( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_UN( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_EQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_UEQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_OLT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_ULT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_OLE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_ULE( CDynarecCode *pCode, OpCode op, u32 * p_flags );

static bool Analyse_Cop1_D_SF( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_NGLE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_SEQ( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_NGL( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_LT( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_NGE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_LE( CDynarecCode *pCode, OpCode op, u32 * p_flags );
static bool Analyse_Cop1_D_NGT( CDynarecCode *pCode, OpCode op, u32 * p_flags );



// Opcode Jump Table
AnalyseInstructionType AnalyseInstruction[64] =
{
	Analyse_Special, Analyse_RegImm, Analyse_J, Analyse_JAL, Analyse_BEQ, Analyse_BNE, Analyse_BLEZ, Analyse_BGTZ,
	Analyse_ADDI, Analyse_ADDIU, Analyse_SLTI, Analyse_SLTIU, Analyse_ANDI, Analyse_ORI, Analyse_XORI, Analyse_LUI,
	Analyse_CoPro0, Analyse_CoPro1, Analyse_Unk, Analyse_Unk, Analyse_BEQL, Analyse_BNEL, Analyse_BLEZL, Analyse_BGTZL,
	Analyse_DADDI, Analyse_DADDIU, Analyse_LDL, Analyse_LDR, /*Analyse_Patch*/Analyse_Unk, Analyse_SRHack_UnOpt, Analyse_SRHack_Opt, Analyse_SRHack_NoOpt,
	Analyse_LB, Analyse_LH, Analyse_LWL, Analyse_LW, Analyse_LBU, Analyse_LHU, Analyse_LWR, Analyse_LWU,
	Analyse_SB, Analyse_SH, Analyse_SWL, Analyse_SW, Analyse_SDL, Analyse_SDR, Analyse_SWR, Analyse_CACHE,
	Analyse_LL, Analyse_LWC1, Analyse_Unk, Analyse_Unk, Analyse_LLD, Analyse_LDC1, Analyse_LDC2, Analyse_LD,
	Analyse_SC, Analyse_SWC1, Analyse_DBG_BreakPoint, Analyse_Unk, Analyse_SCD, Analyse_SDC1, Analyse_SDC2, Analyse_SD
};

// SpecialOpCode Jump Table
AnalyseInstructionType AnalyseSpecialInstruction[64] =
{
	Analyse_Special_SLL, Analyse_Special_Unk, Analyse_Special_SRL, Analyse_Special_SRA, Analyse_Special_SLLV, Analyse_Special_Unk, Analyse_Special_SRLV, Analyse_Special_SRAV,
	Analyse_Special_JR, Analyse_Special_JALR, Analyse_Special_Unk, Analyse_Special_Unk, Analyse_Special_SYSCALL, Analyse_Special_BREAK, Analyse_Special_Unk, Analyse_Special_SYNC,
	Analyse_Special_MFHI, Analyse_Special_MTHI, Analyse_Special_MFLO, Analyse_Special_MTLO, Analyse_Special_DSLLV, Analyse_Special_Unk, Analyse_Special_DSRLV, Analyse_Special_DSRAV,
	Analyse_Special_MULT, Analyse_Special_MULTU, Analyse_Special_DIV, Analyse_Special_DIVU, Analyse_Special_DMULT, Analyse_Special_DMULTU, Analyse_Special_DDIV, Analyse_Special_DDIVU,
	Analyse_Special_ADD, Analyse_Special_ADDU, Analyse_Special_SUB, Analyse_Special_SUBU, Analyse_Special_AND, Analyse_Special_OR, Analyse_Special_XOR, Analyse_Special_NOR,
	Analyse_Special_Unk, Analyse_Special_Unk, Analyse_Special_SLT, Analyse_Special_SLTU, Analyse_Special_DADD, Analyse_Special_DADDU, Analyse_Special_DSUB, Analyse_Special_DSUBU,
	Analyse_Special_TGE, Analyse_Special_TGEU, Analyse_Special_TLT, Analyse_Special_TLTU, Analyse_Special_TEQ, Analyse_Special_Unk, Analyse_Special_TNE, Analyse_Special_Unk,
	Analyse_Special_DSLL, Analyse_Special_Unk, Analyse_Special_DSRL, Analyse_Special_DSRA, Analyse_Special_DSLL32, Analyse_Special_Unk, Analyse_Special_DSRL32, Analyse_Special_DSRA32
};

// RegImmOpCode Jump Table
AnalyseInstructionType AnalyseRegImmInstruction[32] =
{
	Analyse_RegImm_BLTZ,   Analyse_RegImm_BGEZ,   Analyse_RegImm_BLTZL,   Analyse_RegImm_BGEZL,   Analyse_RegImm_Unk,  Analyse_RegImm_Unk, Analyse_RegImm_Unk,  Analyse_RegImm_Unk,
	Analyse_RegImm_TGEI,   Analyse_RegImm_TGEIU,  Analyse_RegImm_TLTI,    Analyse_RegImm_TLTIU,   Analyse_RegImm_TEQI, Analyse_RegImm_Unk, Analyse_RegImm_TNEI, Analyse_RegImm_Unk,
	Analyse_RegImm_BLTZAL, Analyse_RegImm_BGEZAL, Analyse_RegImm_BLTZALL, Analyse_RegImm_BGEZALL, Analyse_RegImm_Unk,  Analyse_RegImm_Unk, Analyse_RegImm_Unk,  Analyse_RegImm_Unk,
	Analyse_RegImm_Unk,    Analyse_RegImm_Unk,    Analyse_RegImm_Unk,     Analyse_RegImm_Unk,     Analyse_RegImm_Unk,  Analyse_RegImm_Unk, Analyse_RegImm_Unk,  Analyse_RegImm_Unk
};

// COP0 Jump Table
AnalyseInstructionType AnalyseCop0Instruction[32] =
{
	Analyse_Cop0_MFC0, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_MTC0, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk,
	Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk,
	Analyse_Cop0_TLB, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk,
	Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk, Analyse_Cop0_Unk,
};


// COP1 Jump Table
AnalyseInstructionType AnalyseCop1Instruction[32] =
{
	Analyse_Cop1_MFC1,    Analyse_Cop1_DMFC1,  Analyse_Cop1_CFC1, Analyse_Cop1_Unk, Analyse_Cop1_MTC1,   Analyse_Cop1_DMTC1,  Analyse_Cop1_CTC1, Analyse_Cop1_Unk,
	Analyse_Cop1_BCInstr, Analyse_Cop1_Unk,    Analyse_Cop1_Unk,  Analyse_Cop1_Unk, Analyse_Cop1_Unk,    Analyse_Cop1_Unk,    Analyse_Cop1_Unk,  Analyse_Cop1_Unk,
	Analyse_Cop1_SInstr,  Analyse_Cop1_DInstr, Analyse_Cop1_Unk,  Analyse_Cop1_Unk, Analyse_Cop1_WInstr, Analyse_Cop1_LInstr, Analyse_Cop1_Unk,  Analyse_Cop1_Unk,
	Analyse_Cop1_Unk,     Analyse_Cop1_Unk,    Analyse_Cop1_Unk,  Analyse_Cop1_Unk, Analyse_Cop1_Unk,    Analyse_Cop1_Unk,    Analyse_Cop1_Unk,  Analyse_Cop1_Unk
};

AnalyseInstructionType AnalyseCop1BC1Instruction[4] =
{
	Analyse_BC1_BC1F, Analyse_BC1_BC1T, Analyse_BC1_BC1FL, Analyse_BC1_BC1TL
};


// Single Jump Table
AnalyseInstructionType AnalyseCop1SInstruction[64] =
{
	Analyse_Cop1_S_ADD,     Analyse_Cop1_S_SUB,     Analyse_Cop1_S_MUL,    Analyse_Cop1_S_DIV,     Analyse_Cop1_S_SQRT,    Analyse_Cop1_S_ABS,     Analyse_Cop1_S_MOV,    Analyse_Cop1_S_NEG,
	Analyse_Cop1_S_ROUND_L, Analyse_Cop1_S_TRUNC_L,	Analyse_Cop1_S_CEIL_L, Analyse_Cop1_S_FLOOR_L, Analyse_Cop1_S_ROUND_W, Analyse_Cop1_S_TRUNC_W, Analyse_Cop1_S_CEIL_W, Analyse_Cop1_S_FLOOR_W,
	Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk, 
	Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk, 
	Analyse_Cop1_S_Unk,     Analyse_Cop1_S_CVT_D,   Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk,     Analyse_Cop1_S_CVT_W,   Analyse_Cop1_S_CVT_L,   Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk,
	Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,     Analyse_Cop1_S_Unk,    Analyse_Cop1_S_Unk, 
	Analyse_Cop1_S_F,       Analyse_Cop1_S_UN,      Analyse_Cop1_S_EQ,     Analyse_Cop1_S_UEQ,     Analyse_Cop1_S_OLT,     Analyse_Cop1_S_ULT,     Analyse_Cop1_S_OLE,    Analyse_Cop1_S_ULE,
	Analyse_Cop1_S_SF,      Analyse_Cop1_S_NGLE,    Analyse_Cop1_S_SEQ,    Analyse_Cop1_S_NGL,     Analyse_Cop1_S_LT,      Analyse_Cop1_S_NGE,     Analyse_Cop1_S_LE,     Analyse_Cop1_S_NGT
};

// Double Jump Table
AnalyseInstructionType AnalyseCop1DInstruction[64] =
{
	Analyse_Cop1_D_ADD,     Analyse_Cop1_D_SUB,     Analyse_Cop1_D_MUL, Analyse_Cop1_D_DIV, Analyse_Cop1_D_SQRT, Analyse_Cop1_D_ABS, Analyse_Cop1_D_MOV, Analyse_Cop1_D_NEG,
	Analyse_Cop1_D_ROUND_L, Analyse_Cop1_D_TRUNC_L,	Analyse_Cop1_D_CEIL_L, Analyse_Cop1_D_FLOOR_L, Analyse_Cop1_D_ROUND_W, Analyse_Cop1_D_TRUNC_W, Analyse_Cop1_D_CEIL_W, Analyse_Cop1_D_FLOOR_W,
	Analyse_Cop1_D_Unk,     Analyse_Cop1_D_Unk,     Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, 
	Analyse_Cop1_D_Unk,     Analyse_Cop1_D_Unk,     Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, 
	Analyse_Cop1_D_CVT_S,   Analyse_Cop1_D_Unk,     Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_CVT_W, Analyse_Cop1_D_CVT_L, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk,
	Analyse_Cop1_D_Unk,     Analyse_Cop1_D_Unk,     Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, Analyse_Cop1_D_Unk, 
	Analyse_Cop1_D_F,       Analyse_Cop1_D_UN,      Analyse_Cop1_D_EQ, Analyse_Cop1_D_UEQ, Analyse_Cop1_D_OLT, Analyse_Cop1_D_ULT, Analyse_Cop1_D_OLE, Analyse_Cop1_D_ULE,
	Analyse_Cop1_D_SF,      Analyse_Cop1_D_NGLE,    Analyse_Cop1_D_SEQ, Analyse_Cop1_D_NGL, Analyse_Cop1_D_LT, Analyse_Cop1_D_NGE, Analyse_Cop1_D_LE, Analyse_Cop1_D_NGT
};

#define SR_FLAGS_BRANCHES 0


bool Analyse_J( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	// No registers modified!

	*p_flags |= SR_FLAGS_BRANCHES;
	return true;
}

bool Analyse_JAL( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_D( REG_ra );
	
	*p_flags |= SR_FLAGS_BRANCHES;
	return true;
}

bool Analyse_Special_JR( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_S( op.rs );

	*p_flags |= SR_FLAGS_BRANCHES;

	return true;

}

bool Analyse_Special_JALR( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_D_S( op.rd, op.rs );

	*p_flags |= SR_FLAGS_BRANCHES;

	return true;
}

bool Analyse_BEQ( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	if ((s16)op.immediate == -1)
		return false;

	*p_flags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S_S( op.rs, op.rt );

	return true;
}

bool Analyse_BNE( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	if ((s16)op.immediate == -1)
		return false;

	*p_flags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S_S( op.rs, op.rt );
	
	return true;
}

bool Analyse_BLEZ( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	if ((s16)op.immediate == -1)
		return false;

	*p_flags |= SR_FLAGS_BRANCHES;

	pCode->Stat_S( op.rs );
	
	return true;
}

bool Analyse_BGTZ( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	if ((s16)op.immediate == -1)
		return false;
	
	*p_flags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S( op.rs );

	return true;
}

bool Analyse_RegImm_BLTZ( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	if ( (s16)op.immediate == -1)
		return false;

	pCode->Stat_S( op.rs );

	*p_flags |= SR_FLAGS_BRANCHES;
	return true;
}

bool Analyse_RegImm_BGEZ( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	if ((s16)op.immediate == -1)
		return false;

	pCode->Stat_S( op.rs );
	
	*p_flags |= SR_FLAGS_BRANCHES;

	return true;
}

bool Analyse_Emit_LB( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_Load_B_D( op.base, op.rt );

	return true;
}


bool Analyse_Emit_LBU( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_Load_B_D( op.base, op.rt );

	return true;
}


bool Analyse_Emit_LH( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_Load_B_D( op.base, op.rt );
	
	return true;
}

bool Analyse_Emit_LHU( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_Load_B_D( op.base, op.rt );
	
	return true;
}


bool Analyse_Emit_LW( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_Load_B_D( op.base, op.rt );

	return true;
}

bool Analyse_Emit_LWC1( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_Load_B( op.base );
	pCode->Stat_Single_D( op.ft );

	return true;
}

bool Analyse_Emit_LDC1( CDynarecCode *pCode, OpCode op, u32 * p_flags )
{
	pCode->Stat_Load_B( op.base );
	pCode->Stat_Double_D( op.ft );

	return true;
}






#endif


