/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __DAEDALUS_R4300_H__
#define __DAEDALUS_R4300_H__

#include "R4300OpCode.h"
#include "R4300Instruction.h"

#define ToInt(x)	*((int *)&x)
#define ToQuad(x)	*((u64 *)&x)
#define ToFloat(x)	*((float *)&x)
#define ToDouble(x)	*((double *)&x)

void R4300_SetSR( u32 new_value );

#ifdef _DEBUG
inline void CHECK_R0() {}
/*inline void CHECK_R0()
{
	if (gGPR[0]._u64 != 0)
	{
		DBGConsole_Msg(0, "Warning: Attempted write to r0!");
		gGPR[0]._u64 = 0;			// Ensure r0 is always zero (easier than trapping writes?)
	}
}*/

#else
inline void CHECK_R0() {}
#endif

extern CPU_Instruction R4300Instruction[64];
extern CPU_Instruction R4300SpecialInstruction[64];

CPU_Instruction	R4300_GetInstructionHandler( OpCode op_code );
bool			R4300_InstructionHandlerNeedsPC( OpCode op_code );

void R4300_CALL_TYPE R4300_Unk( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_J( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_JAL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BEQ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BNE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BLEZ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BGTZ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_ADDI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_ADDIU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SLTI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SLTIU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_ANDI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_ORI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_XORI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LUI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_CoPro0( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_CoPro1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_CoPro1_Disabled( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BEQL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BNEL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BLEZL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BGTZL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_DADDI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_DADDIU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LDL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LDR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Patch( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LB( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LH( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LWL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LW( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LBU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LHU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LWR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LWU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SB( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SH( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SWL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SW( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SDL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SDR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SWR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_CACHE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LWC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LLD( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LDC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LDC2( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_LD( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SC( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SWC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_DBG_Bkpt( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SCD( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SDC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SDC2( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_SD( R4300_CALL_SIGNATURE );


void R4300_CALL_TYPE R4300_Special_Unk( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SLL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SRL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SRA( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SLLV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SRLV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SRAV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_JR_CheckBootAddress( R4300_CALL_SIGNATURE );		// Special version to check for jump to game boot address
void R4300_CALL_TYPE R4300_Special_JR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_JALR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SYSCALL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_BREAK( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SYNC( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_MFHI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_MTHI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_MFLO( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_MTLO( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSLLV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSRLV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSRAV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_MULT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_MULTU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DIV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DIVU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DMULT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DMULTU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DDIV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DDIVU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_ADD( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_ADDU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SUB( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SUBU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_AND( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_OR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_XOR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_NOR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SLT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_SLTU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DADD( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DADDU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSUB( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSUBU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_TGE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_TGEU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_TLT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_TLTU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_TEQ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_TNE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSLL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSRL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSRA( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSLL32( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSRL32( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Special_DSRA32( R4300_CALL_SIGNATURE );


void R4300_CALL_TYPE R4300_RegImm_Unk( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BLTZ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BGEZ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BLTZL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BGEZL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_TGEI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_TGEIU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_TLTI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_TLTIU( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_TEQI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_TNEI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BLTZAL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BGEZAL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BLTZALL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_RegImm_BGEZALL( R4300_CALL_SIGNATURE );


void R4300_CALL_TYPE R4300_Cop0_Unk( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop0_MFC0( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop0_MTC0( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop0_TLB( R4300_CALL_SIGNATURE );


void R4300_CALL_TYPE R4300_TLB_Unk( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_TLB_TLBR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_TLB_TLBWI( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_TLB_TLBWR( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_TLB_TLBP( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_TLB_ERET( R4300_CALL_SIGNATURE );



void R4300_CALL_TYPE R4300_Cop1_Unk( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_MFC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_DMFC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_CFC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_MTC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_DMTC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_CTC1( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_BCInstr( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_SInstr( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_DInstr( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_WInstr( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_LInstr( R4300_CALL_SIGNATURE );

void R4300_CALL_TYPE R4300_BC1_BC1F( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BC1_BC1T( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BC1_BC1FL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_BC1_BC1TL( R4300_CALL_SIGNATURE );


void R4300_CALL_TYPE R4300_Cop1_S_Unk( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_ADD( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_SUB( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_MUL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_DIV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_SQRT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_ABS( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_MOV( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_NEG( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_ROUND_L( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_TRUNC_L( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_CEIL_L( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_FLOOR_L( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_ROUND_W( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_TRUNC_W( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_CEIL_W( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_FLOOR_W( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_CVT_D( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_CVT_W( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_CVT_L( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_F( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_UN( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_EQ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_UEQ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_OLT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_ULT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_OLE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_ULE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_SF( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_NGLE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_SEQ( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_NGL( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_LT( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_NGE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_LE( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_S_NGT( R4300_CALL_SIGNATURE );


void R4300_CALL_TYPE R4300_Cop1_W_CVT_S( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_W_CVT_D( R4300_CALL_SIGNATURE );

void R4300_CALL_TYPE R4300_Cop1_L_CVT_S( R4300_CALL_SIGNATURE );
void R4300_CALL_TYPE R4300_Cop1_L_CVT_D( R4300_CALL_SIGNATURE );

template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_Unk( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_ADD( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_SUB( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_MUL( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_DIV( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_SQRT( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_ABS( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_MOV( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_NEG( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_ROUND_L( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_TRUNC_L( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_CEIL_L( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_FLOOR_L( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_ROUND_W( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_TRUNC_W( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_CEIL_W( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_FLOOR_W( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_CVT_S( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_CVT_W( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_CVT_L( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_F( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_UN( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_EQ( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_UEQ( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_OLT( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_ULT( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_OLE( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_ULE( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_SF( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_NGLE( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_SEQ( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_NGL( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_LT( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_NGE( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_LE( R4300_CALL_SIGNATURE );
template< bool FullLength > void R4300_CALL_TYPE R4300_Cop1_D_NGT( R4300_CALL_SIGNATURE );


#endif
