/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DAEDTHREAD_H_
#define DAEDTHREAD_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

namespace daedalus
{
	typedef u32 ( __stdcall * DaedThread )( void );			// No arguments for now - need to fix this

	extern const s32	INVALID_THREAD_HANDLE;

	enum EThreadPriority
	{
		TP_LOW = 0,
		TP_NORMAL,
		TP_HIGH,
		TP_TIME_CRITICAL,
		TP_NUM_PRIORITIES,
	};

	//
	//	Returns a thread handle - you must check it for error status (== INVALID_THREAD_HANDLE)
	//
	s32		__cdecl CreateThread( DaedThread p_function, bool start_on_creation );

	//
	//	Adjusts a thread's priority
	//
	void	__cdecl SetThreadPriority( s32 handle, EThreadPriority pri );

	//
	//	Releases a handle to a thread. This doesn't stop the thread - it just frees resources
	//
	void	__cdecl ReleaseThreadHandle( s32 handle );

	//
	//	Terminates a running thread
	//
	void	__cdecl TerminateThread( s32 handle );

	//
	//	Wait the specified time for the thread to finish.
	//	Returns true if the thread has terminated, false if it is still running
	//	If timeout < 0 this function will block until the thread has finished, otherwise it is a time in MS to wait for
	//
	bool	__cdecl WaitForThreadTermination( s32 handle, s32 timeout );

}


#endif // DAEDTHREAD_H_
