/*
Copyright (C) 2006 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef UICONTEXT_H_
#define UICONTEXT_H_

#include "PSPGraphics/PSPColour.h"
#include "UIAlignment.h"

class CNativeTexture;
class v2;

class CUIContext
{
	public:
		virtual ~CUIContext();

		static CUIContext *		Create();

		virtual void				BeginRender() = 0;
		virtual void				EndRender() = 0;

		virtual c32					GetBackgroundColour() const = 0;
		virtual void				SetBackgroundColour( c32 colour ) = 0;

		virtual u32					GetScreenWidth() const = 0;
		virtual u32					GetScreenHeight() const = 0;

		virtual c32					GetDefaultTextColour() const = 0;
		virtual c32					GetSelectedTextColour() const = 0;

		virtual void				Update( float elapsed_time ) = 0;

		virtual void				RenderTexture( CNativeTexture * p_texture, const v2 & tl, const v2 & wh, c32 colour ) = 0;
		virtual void				RenderTexture( CNativeTexture * p_texture, s32 x, s32 y, c32 colour ) = 0;
		virtual void				ClearBackground()													{ ClearBackground( GetBackgroundColour() ); }
		virtual void				ClearBackground( c32 colour ) = 0;
		virtual void				DrawRect( s32 x, s32 y, u32 w, u32 h, c32 colour ) = 0;
		virtual void				DrawLine( s32 x0, s32 y0, s32 x1, s32 y1, c32 colour ) = 0;

		virtual void				DrawText( s32 x, s32 y, const char * text, c32 colour )				{ DrawText( x, y, text, strlen( text ), colour ); }
		virtual void				DrawText( s32 x, s32 y, const char * text, u32 length, c32 colour ) = 0;

		virtual s32					DrawTextArea( s32 left, s32 top, u32 width, u32 height, const char * text, c32 colour, EVerticalAlign vertical_align ) = 0;
};

#endif	// UICONTEXT_H_
