/*
Copyright (C) 2006 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DRAWTEXT_H_
#define DRAWTEXT_H_

#include <vector>
#include "PSPGraphics/PSPColour.h"
#include "SysPSP/UI/UIAlignment.h"

class CDrawText
{
	public:
		static void		Initialise();

		static void		Render( s32 x, s32 y, const char * p_str, c32 colour )	{ Render( x, y, p_str, strlen( p_str ), colour ); }
		static void		Render( s32 x, s32 y, const char * p_str, u32 length, c32 colour );
		static s32		GetTextWidth( const char * p_str )								{ return GetTextWidth( p_str, strlen( p_str ) ); }
		static s32		GetTextWidth( const char * p_str, u32 length );

		static s32		GetFontHeight();

		static void		Destroy();
};

namespace DrawTextUtilities
{
	extern const c32	TextWhite;
	extern const c32	TextWhiteDisabled;
	extern const c32	TextBlue;
	extern const c32	TextBlueDisabled;
	extern const c32	TextRed;
	extern const c32	TextRedDisabled;

	void			DrawShadowText( s32 x, s32 y, const char * p_str, u32 length, c32 colour );
	inline void		DrawShadowText( s32 x, s32 y, const char * p_str, c32 colour )			{ DrawShadowText( x, y, p_str, strlen( p_str ), colour ); }

	s32				AlignText( s32 min_x, s32 max_x, const char * p_str, u32 length, EAlignType align_type );
	inline s32		AlignText( s32 min_x, s32 max_x, const char * p_str, EAlignType align_type )	{ return AlignText( min_x, max_x, p_str, strlen( p_str ), align_type ); }
	void			WrapText( s32 width, const char * p_str, u32 length, std::vector<u32> & lengths );
	inline void		WrapText( s32 width, const char * p_str, std::vector<u32> & lengths )			{ WrapText( width, p_str, strlen( p_str ), lengths ); }
}

#endif	// DRAWTEXT_H_
