/*
Copyright (C) 2003 Azimer
Copyright (C) 2001,2006 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//
//	N.B. This source code is derived from Azimer's Audio plugin (v0.55?)
//	and modified by StrmnNrmn to work with Daedalus PSP. Thanks Azimer!
//	Drop me a line if you get chance :)
//

#include "stdafx.h"
// PSP Audio headers

#include <pspaudiolib.h>
#include <pspkernel.h>

#include <stdio.h>
#include "AudioCode.h"
#include "AudioBuffer.h"

#include "Debug/DBGConsole.h"

#include "DaedThread.h"

//*****************************************************************************
//
//*****************************************************************************
AudioCode::AudioCode()
:	mAudioBuffer( new CAudioBuffer )
,	mAudioPlaying( false )
,	mFrequency( 44100 )
,	mSemaphore( sceKernelCreateSema( "AudioCode", 0, 1, 1, NULL ) )
{
	DAEDALUS_ASSERT( mSemaphore >= 0, "Couldn't create semaphore!" )
}

//*****************************************************************************
//
//*****************************************************************************
AudioCode::~AudioCode( )
{
	StopAudio();
}

//*****************************************************************************
//
//*****************************************************************************
void AudioCode::SetFrequency( u32 frequency )
{
	DBGConsole_Msg( 0, "Audio frequency: %d", frequency );
	mFrequency = frequency;
}

//*****************************************************************************
//
//*****************************************************************************
void	AudioCode::SetAdaptFrequency( bool adapt )
{
	mAudioBuffer->SetAdaptFrequency( adapt );
}

//*****************************************************************************
//
//*****************************************************************************
u32 AudioCode::AddBuffer( u8 *start, u32 length )
{
	if (length == 0)
		return 0;

	if (!mAudioPlaying)
		StartAudio();

	u32		num_samples( length / sizeof( Sample ) );

	sceKernelWaitSema( mSemaphore, 1, NULL );

	do
	{
		if( mAudioBuffer->CanAdd( num_samples, mFrequency ) )
		{
			mAudioBuffer->AddSamples( reinterpret_cast< const Sample * >( start ), num_samples, mFrequency );
			break;
		}
		else
		{
			sceKernelSignalSema( mSemaphore, 1 );
			//DBGConsole_Msg( 0, "Buffer full, sleeping" );
			sceKernelDelayThreadCB( 1 );
			sceKernelWaitSema( mSemaphore, 1, NULL );
		}
	}
	while( true );

	sceKernelSignalSema( mSemaphore, 1 );
	return 0;
}

//*****************************************************************************
// Fills up a buffer and remixes the audio
//*****************************************************************************
void AudioCode::FillBuffer( Sample * buffer, u32 num_samples )
{
	sceKernelWaitSema( mSemaphore, 1, NULL );

	mAudioBuffer->Fill( buffer, num_samples );

	sceKernelSignalSema( mSemaphore, 1 );
}

//*****************************************************************************
//
//*****************************************************************************
namespace
{

void audioCallback( void * buf, unsigned int length, void * userdata )
{
	AudioCode * ac( reinterpret_cast< AudioCode * >( userdata ) );

	ac->FillBuffer( reinterpret_cast< Sample * >( buf ), length );
}

}

//*****************************************************************************
//
//*****************************************************************************
void AudioCode::StartAudio()
{
	if (mAudioPlaying)
		return;

	mAudioPlaying = true;

	pspAudioInit();
	pspAudioSetChannelCallback( 0, audioCallback, this );
}

//*****************************************************************************
//
//*****************************************************************************
void AudioCode::StopAudio()
{
	if (!mAudioPlaying)
		return;

	mAudioPlaying = false;
	
	pspAudioEnd();
}

//*****************************************************************************
//
//*****************************************************************************
u32 AudioCode::GetReadStatus()
{
	// TODO!
	return 0;
}
