#define SR_STORE_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_STORE_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_STORE		//return FALSE;

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_SW(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_STORE
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);
		
	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_SW);
	}
	else
	{
		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateSW( rt, base, nOffset );
	}
	
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_SH(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_STORE
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);
	
	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_SH);
	}
	else
	{
		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateSH( rt, base, nOffset );
	}
	
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_SB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_STORE
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Save_B_S(base, rt);

	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_SB);
	}
	else
	{
		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateSB( rt, base, nOffset );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_SWC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_STORE
	const EN64Reg base = EN64Reg( op_code.base );
	const u32 reg_ft = op_code.ft;

	pCode->Stat_Save_B(base);
	pCode->Stat_Single_S(reg_ft);
	
	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_SWC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->mpCodeGenerator->GenerateSWC1( reg_ft, base, nOffset );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_SDC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_STORE
	const EN64Reg base = EN64Reg( op_code.base );
	const u32 reg_ft = op_code.ft;

	pCode->Stat_Save_B(base);
	pCode->Stat_Double_S(reg_ft);
	
	//if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_SDC1);
	}

	return TRUE;
}
