#define SR_BRANCH_OPTIMISE_FLAG		(pCode->dwOptimiseLevel < 1)
//#define SR_BRANCH_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_BRANCH		//return FALSE;


//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_J(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	// No registers modified!

	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_J);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_JAL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	pCode->Stat_D(REG_ra);
	
	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_JAL);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_JR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	const EN64Reg rs = EN64Reg( op_code.rs );

	pCode->Stat_S(rs);

	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	// We use this, rather than R4300_Special_JR because this op is hacked
	// to allow us to detect when the rom jumps to the game boot 
	// address (so that we can apply the patches).
	// The special version of this op patches the "normal" version of
	// the op back intot he jump talbe after the patches
	// have been applied
	SR_Emit_Generic_R4300(pCode, op_code, R4300SpecialInstruction[SpecOp_JR]);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Special_JALR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rd = EN64Reg( op_code.rd );

	pCode->Stat_D_S(rd, rs);

	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Special_JALR);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_BEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	s32  nOffset = (s32)(s16)op_code.immediate;

	if (nOffset == -1)
		return FALSE;

	*p_flags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S_S(rs, rt);

	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;

	
	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, dwCurrPC );

		SR_Emit_Generic_R4300(pCode, op_code, R4300_BEQ);
	}
	else
	{
		pCode->dwNumOptimised++;

		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common for BEQs
			DPF(DEBUG_DYNREC, "!!Detected block-referential BEQ jump!");

			// Get the next op:
			*p_flags |= SR_FLAGS_BRANCHES_TO_START;
		}

		*p_flags |= SR_FLAGS_HANDLE_BRANCH;

		pCode->mpCodeGenerator->GenerateBEQ( rs, rt, dwJumpPC );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_BNE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const EN64Reg rs = EN64Reg( op_code.rs );
	const EN64Reg rt = EN64Reg( op_code.rt );
	const s32 nOffset = (s32)(s16)op_code.immediate;
	
	if (nOffset == -1)
		return FALSE;

	*p_flags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S_S(rs, rt);
	
	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;
	
	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, dwCurrPC );

		SR_Emit_Generic_R4300(pCode, op_code, R4300_BNE);
	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common
			DPF(DEBUG_DYNREC, "!!Detected block-referential BNE jump!");

			// Get the next op:
			*p_flags |= SR_FLAGS_BRANCHES_TO_START;
		}

		*p_flags |= SR_FLAGS_HANDLE_BRANCH;

		pCode->mpCodeGenerator->GenerateBNE( rs, rt, dwJumpPC );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_BLEZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const EN64Reg rs = EN64Reg( op_code.rs );
	s32  nOffset = (s32)(s16)op_code.immediate;
	
	if (nOffset == -1)
		return FALSE;

	*p_flags |= SR_FLAGS_BRANCHES;

	pCode->Stat_S(rs);
	
	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;

	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, dwCurrPC );

		SR_Emit_Generic_R4300(pCode, op_code, R4300_BLEZ);
	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common
			DPF(DEBUG_DYNREC, "!!Detected block-referential BLEZ jump!");

			// Get the next op:
			*p_flags |= SR_FLAGS_BRANCHES_TO_START;
		}

		*p_flags |= SR_FLAGS_HANDLE_BRANCH;

		pCode->mpCodeGenerator->GenerateBLEZ( rs, dwJumpPC );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_BGTZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const EN64Reg rs = EN64Reg( op_code.rs );
	s32  nOffset = (s32)(s16)op_code.immediate;
	
	if (nOffset == -1)
		return FALSE;
	
	*p_flags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S(rs);
	
	
	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;

	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, dwCurrPC );
		SR_Emit_Generic_R4300(pCode, op_code, R4300_BGTZ);
	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common
			DPF(DEBUG_DYNREC, "!!Detected block-referential BGTZ jump!");

			// Get the next op:
			*p_flags |= SR_FLAGS_BRANCHES_TO_START;
		}

		*p_flags |= SR_FLAGS_HANDLE_BRANCH;

		pCode->mpCodeGenerator->GenerateBGTZ( rs, dwJumpPC );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_RegImm_BLTZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const EN64Reg rs = EN64Reg( op_code.rs );
	const s16 wOffset = (s16)op_code.immediate;

	if (wOffset == -1)
		return FALSE;

	pCode->Stat_S(rs);

	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_RegImm_BLTZ);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_RegImm_BGEZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const EN64Reg rs = EN64Reg( op_code.rs );
	const s16 wOffset = (s16)op_code.immediate;

	if (wOffset == -1)
		return FALSE;

	pCode->Stat_S(rs);
	
	*p_flags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	pCode->mpCodeGenerator->SetVar( &gCPUState.CurrentPC, pCode->dwStartPC + (pCode->dwNumOps*4) );

	SR_Emit_Generic_R4300(pCode, op_code, R4300_RegImm_BGEZ);
	return TRUE;
}
