/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __DAEDALUSASSERT_H__
#define __DAEDALUSASSERT_H__

//
// This static assert is bastardised from Boost:
// http://www.boost.org/boost/static_assert.hpp
//  (C) Copyright John Maddock 2000.
//  Use, modification and distribution are subject to the 
//  Boost Software License, Version 1.0. (See accompanying file 
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//  See http://www.boost.org/libs/static_assert for documentation.
//
template <bool> struct STATIC_ASSERTION_FAILURE;
template <> struct STATIC_ASSERTION_FAILURE<true>{};
template<int x> struct static_assert_test{};

#define DAEDALUS_STATIC_ASSERT( x )								\
   typedef static_assert_test<sizeof(STATIC_ASSERTION_FAILURE< (bool)( x ) >)>	static_assert_typedef_##__COUNTER__


// Ideas for the ignored assert taken from Game Programming Gems I
#ifdef DAEDALUS_RELEASE_BUILD

#define DAEDALUS_ASSERT( e, msg )		{}
#define DAEDALUS_ASSERT_Q( e )			{}
#define DAEDALUS_ASSERTMSG( msg )		{}
#define DAEDALUS_ERROR( msg )			{}

#else

#ifdef DAEDALUS_PSP
#define DAEDALUS_HALT			asm( "break\r\n" )
#else
#define DAEDALUS_HALT			__asm { int 3 }
#endif

int __cdecl DaedalusAssert( const char * msg, const char * expression, const char * file, unsigned int line );

//
// Use this to report on problems with the emulator - not the emulated title
//
#define DAEDALUS_ASSERT( e, msg )										\
{																		\
	static bool ignore = false;											\
	if ( !(e) && !ignore )												\
	{																	\
		int i = DaedalusAssert( (msg), #e,  __FILE__, __LINE__ );		\
		if ( i == 1 )													\
		{																\
			DAEDALUS_HALT;	/* User breakpoint */						\
		}																\
		else if ( i == 0 )												\
		{																\
			ignore = true;	/* Ignore throughout session */				\
		}																\
	}																	\
}

//
// Use this to assert without specifying a message
//
#define DAEDALUS_ASSERT_Q( e )											\
{																		\
	static bool ignore = false;											\
	if ( !(e) && !ignore )												\
	{																	\
		int i = DaedalusAssert( "", #e, __FILE__, __LINE__ );			\
		if ( i == 1 )													\
		{																\
			DAEDALUS_HALT;	/* User breakpoint */						\
		}																\
		else if ( i == 0 )												\
		{																\
			ignore = true;	/* Ignore throughout session */				\
		}																\
	}																	\
}

//
// Use this to assert unconditionally - e.g. for unhandled cases
//
#define DAEDALUS_ASSERTMSG( msg )										\
{																		\
	static bool ignore = false;											\
	if ( !ignore )														\
	{																	\
		int i = DaedalusAssert( msg, "", __FILE__, __LINE__ );			\
		if ( i == 1 )													\
		{																\
			DAEDALUS_HALT;	/* User breakpoint */						\
		}																\
		else if ( i == 0 )												\
		{																\
			ignore = true;	/* Ignore throughout session */				\
		}																\
	}																	\
}

#define DAEDALUS_ERROR( msg )			DAEDALUS_ASSERTMSG( msg )


#endif

#endif // __DAEDALUSASSERT_H__
