/*
Copyright (C) 2006 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "Precompiled.h"
#include "DaedIO.h"

#include <Shlwapi.h>

namespace daedalus
{

	namespace IO
	{
		namespace File
		{
			bool	Move( const char * p_existing, const char * p_new )
			{
				return ::MoveFile( p_existing, p_new ) ? true : false;
			}

			bool	Delete( const char * p_file )
			{
				return ::DeleteFile( p_file ) ? true : false;
			}

			bool	Exists( const char * p_path )
			{
				return ::PathFileExists( p_path ) ? true : false;
			}
		}
		namespace Directory
		{
			bool	Create( const char * p_path )
			{
				return ::CreateDirectory( p_path, NULL ) ? true : false;
			}

			bool	EnsureExists( const char * p_path )
			{
				if ( IsDirectory(p_path) )
					return true;

				// Make sure parent exists, 
				char	p_path_parent[ IO::Path::MAX_PATH_LEN+1 ];
				strncpy( p_path_parent, p_path, IO::Path::MAX_PATH_LEN );
				p_path_parent[IO::Path::MAX_PATH_LEN-1] = '\0';
				IO::Path::RemoveBackslash( p_path_parent );
				if( IO::Path::RemoveFileSpec( p_path_parent ) )
				{
					//
					//	Recursively create parents. Need to be careful of stack overflow
					//
					if( !EnsureExists( p_path_parent ) )
						return false;
				}

				return Create( p_path );
			}

			bool	IsDirectory( const char * p_path )
			{
				return ::PathIsDirectory( p_path ) ? true : false;
			}
		}

		namespace Path
		{
			char *	Combine( char * p_dest, const char * p_dir, const char * p_file )
			{
				return ::PathCombine( p_dest, p_dir, p_file );
			}

			bool	Append( char * p_path, const char * p_more )
			{
				return ::PathAppend( p_path, p_more ) ? true : false;
			}

			const char *  FindExtension( const char * p_path )
			{
				return ::PathFindExtension( p_path );
			}

			const char *	FindFileName( const char * p_path )
			{
				return ::PathFindFileName( p_path );
			}

			char *	RemoveBackslash( char * p_path )
			{
				return ::PathRemoveBackslash( p_path );
			}

			bool	RemoveFileSpec( char * p_path )
			{
				return ::PathRemoveFileSpec( p_path ) ? true : false;
			}

			void	RemoveExtension( char * p_path )
			{
				::PathRemoveExtension( p_path );
			}

			bool	AddExtension( char * p_path, const char * p_ext )
			{
				return ::PathAddExtension( p_path, p_ext ) ? true : false;
			}
		}
	}
}
