/*

  Copyright (C) 2002 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "Precompiled.h"

using namespace daedalus;

//*****************************************************************************
// Perform a sprintf to static text buffer, and return the resulting string
//*****************************************************************************
const char * __cdecl DSPrintf( const char * fmt, ... )
{
	const u32		MAX_BUFFERS = 10;
	static u32		current_buffer = 0;
	static char		buffers[ MAX_BUFFERS ][ 2048 ];
    va_list			va;
	u32				buffer_idx( current_buffer );

	current_buffer = ( current_buffer + 1 ) % MAX_BUFFERS;

	// Format the output
	va_start( va, fmt );
	// Don't use wvsprintf as it doesn't handle floats!
	vsprintf( buffers[ buffer_idx ], fmt, va );
	va_end( va );
	
	return buffers[ buffer_idx ];
}

